/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.crafting.recipe;

import com.klikli_dev.occultism.crafting.recipe.input.ItemHandlerRecipeInput;
import com.klikli_dev.occultism.crafting.recipe.result.WeightedRecipeResult;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class MinerRecipe
implements Recipe<ItemHandlerRecipeInput> {
    public static final MapCodec<MinerRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(r -> r.input), (App)WeightedRecipeResult.CODEC.fieldOf("result").forGetter(r -> r.result)).apply((Applicative)instance, MinerRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MinerRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, r -> r.input, WeightedRecipeResult.STREAM_CODEC, r -> r.result, MinerRecipe::new);
    public static Serializer SERIALIZER = new Serializer();
    protected final Ingredient input;
    protected final WeightedRecipeResult result;

    public MinerRecipe(Ingredient input, WeightedRecipeResult result) {
        this.input = input;
        this.result = result;
    }

    public boolean isSpecial() {
        return true;
    }

    public WeightedRecipeResult getWeightedResult() {
        return this.result;
    }

    public boolean matches(ItemHandlerRecipeInput inv, Level level) {
        return this.input.test(inv.getItem(0));
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack assemble(ItemHandlerRecipeInput pCraftingContainer, HolderLookup.Provider pRegistries) {
        return this.getResultItem(pRegistries).copy();
    }

    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        return this.result.getStack();
    }

    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{this.input});
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public RecipeType<?> getType() {
        return (RecipeType)OccultismRecipes.MINER_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<MinerRecipe> {
        public MapCodec<MinerRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, MinerRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

