/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.network.messages;

import com.klikli_dev.occultism.api.common.data.MachineReference;
import com.klikli_dev.occultism.common.entity.job.ManageMachineJob;
import com.klikli_dev.occultism.common.item.spirit.BookOfCallingItem;
import com.klikli_dev.occultism.network.IMessage;
import com.klikli_dev.occultism.util.ItemNBTUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class MessageSetManagedMachine
implements IMessage {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"set_managed_machine");
    public static final CustomPacketPayload.Type<MessageSetManagedMachine> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageSetManagedMachine> STREAM_CODEC = CustomPacketPayload.codec(MessageSetManagedMachine::encode, MessageSetManagedMachine::new);
    public MachineReference managedMachine;

    public MessageSetManagedMachine(RegistryFriendlyByteBuf buf) {
        this.decode(buf);
    }

    public MessageSetManagedMachine(MachineReference managedMachine) {
        this.managedMachine = managedMachine;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (stack.getItem() instanceof BookOfCallingItem) {
            ItemNBTUtil.getSpiritEntity(stack).ifPresent(spirit -> spirit.getJob().filter(ManageMachineJob.class::isInstance).map(ManageMachineJob.class::cast).ifPresent(job -> {
                if (job.getManagedMachine() != null) {
                    job.getManagedMachine().customName = this.managedMachine.customName;
                    job.getManagedMachine().extractFacing = this.managedMachine.extractFacing;
                    job.getManagedMachine().insertFacing = this.managedMachine.insertFacing;
                    ItemNBTUtil.updateItemNBTFromEntity(stack, spirit);
                    player.inventoryMenu.broadcastChanges();
                }
            }));
        }
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buf) {
        MachineReference.STREAM_CODEC.encode((Object)buf, (Object)this.managedMachine);
    }

    @Override
    public void decode(RegistryFriendlyByteBuf buf) {
        this.managedMachine = (MachineReference)MachineReference.STREAM_CODEC.decode((Object)buf);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

