/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.bookstate;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.bookstate.visual.BookVisualState;
import com.klikli_dev.modonomicon.bookstate.visual.CategoryVisualState;
import com.klikli_dev.modonomicon.bookstate.visual.EntryVisualState;
import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public class BookVisualStates {
    public static final Codec<BookVisualStates> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, BookVisualState.CODEC).fieldOf("bookStates").forGetter(s -> s.bookStates), (App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)BookAddress.CODEC.listOf()).fieldOf("bookBookmarks").forGetter(s -> s.bookBookmarks)).apply((Applicative)instance, BookVisualStates::new));
    public static final StreamCodec<ByteBuf, BookVisualStates> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
    public Map<ResourceLocation, BookVisualState> bookStates;
    public Map<ResourceLocation, List<BookAddress>> bookBookmarks;

    public BookVisualStates() {
        this((Map<ResourceLocation, BookVisualState>)Object2ObjectMaps.emptyMap(), (Map<ResourceLocation, List<BookAddress>>)Object2ObjectMaps.emptyMap());
    }

    public BookVisualStates(Map<ResourceLocation, BookVisualState> bookStates, Map<ResourceLocation, List<BookAddress>> bookBookmarks) {
        this.bookStates = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap(bookStates));
        this.bookBookmarks = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
        bookBookmarks.forEach((bookId, entries) -> this.bookBookmarks.put((ResourceLocation)bookId, new ArrayList(entries)));
    }

    public BookVisualState getBookState(Book book) {
        return this.bookStates.computeIfAbsent(book.getId(), id -> new BookVisualState());
    }

    public CategoryVisualState getCategoryState(BookCategory category) {
        return this.getBookState((Book)category.getBook()).categoryStates.computeIfAbsent(category.getId(), id -> new CategoryVisualState());
    }

    public EntryVisualState getEntryState(BookEntry entry) {
        return this.getCategoryState((BookCategory)entry.getCategory()).entryStates.computeIfAbsent(entry.getId(), id -> new EntryVisualState());
    }

    public List<BookAddress> getBookmarks(Book book) {
        return this.bookBookmarks.computeIfAbsent(book.getId(), id -> new ArrayList());
    }

    public void setBookState(Book book, BookVisualState state) {
        this.bookStates.put(book.getId(), state);
    }

    public void setEntryState(BookEntry entry, EntryVisualState state) {
        this.getCategoryState((BookCategory)entry.getCategory()).entryStates.put(entry.getId(), state);
    }

    public void setCategoryState(BookCategory category, CategoryVisualState state) {
        this.getBookState((Book)category.getBook()).categoryStates.put(category.getId(), state);
    }

    public void setBookmarks(Book book, List<BookAddress> bookmarks) {
        this.bookBookmarks.put(book.getId(), bookmarks);
    }

    public void addBookmark(Book book, BookAddress bookmark) {
        this.getBookmarks(book).add(bookmark);
    }

    public boolean removeBookmark(Book book, BookAddress bookmark) {
        return this.getBookmarks(book).remove(bookmark);
    }
}

