/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.markdown;

import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.client.gui.book.markdown.ComponentNodeRendererContext;
import com.klikli_dev.modonomicon.client.gui.book.markdown.LinkRenderer;
import com.mojang.brigadier.StringReader;
import java.util.function.Consumer;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.ItemStack;
import org.commonmark.node.Link;
import org.commonmark.node.Node;
import org.commonmark.node.Text;

public class ItemLinkRenderer
implements LinkRenderer {
    public static final String PROTOCOL_ITEM = "item://";
    public static final int PROTOCOL_ITEM_LENGTH = "item://".length();
    public static final TextColor ITEM_LINK_COLOR = TextColor.fromRgb((int)171610);

    public static boolean isItemLink(String linkText) {
        return linkText.toLowerCase().startsWith(PROTOCOL_ITEM);
    }

    @Override
    public boolean visit(Link link, Consumer<Node> visitChildren, ComponentNodeRendererContext context) {
        if (link.getDestination().startsWith(PROTOCOL_ITEM)) {
            BookErrorManager.get().setContext("Item Link: {}, \n{}", link.getDestination(), BookErrorManager.get().getContextHelper());
            TextColor currentColor = context.getCurrentStyle().getColor();
            ItemParser itemParser = new ItemParser(context.getProvider());
            ItemStack itemStack = ItemStack.EMPTY;
            try {
                String itemId = link.getDestination().substring(PROTOCOL_ITEM_LENGTH);
                StringReader reader = new StringReader(itemId);
                ItemParser.ItemResult itemResult = itemParser.parse(reader);
                ItemInput itemInput = new ItemInput(itemResult.item(), itemResult.components());
                itemStack = itemInput.createItemStack(1, false);
            }
            catch (Exception e) {
                BookErrorManager.get().error("Failed to parse item link.", e);
            }
            context.setCurrentStyle(context.getCurrentStyle().withColor(currentColor == null ? ITEM_LINK_COLOR : currentColor).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(itemStack))).withClickEvent(new ClickEvent(ClickEvent.Action.CHANGE_PAGE, link.getDestination())));
            if (link.getLastChild() == null) {
                link.appendChild((Node)new Text(Component.translatable((String)itemStack.getItem().getDescriptionId()).getString()));
            }
            visitChildren.accept((Node)link);
            context.setCurrentStyle(context.getCurrentStyle().withColor(currentColor).withHoverEvent(null));
            BookErrorManager.get().setContext(null, new Object[0]);
            return true;
        }
        return false;
    }
}

