/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.job;

import com.google.common.collect.ImmutableList;
import com.klikli_dev.occultism.common.entity.job.SpiritJobFactory;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.registry.OccultismMemoryTypes;
import com.klikli_dev.occultism.registry.OccultismSpiritJobs;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.util.INBTSerializable;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.util.BrainUtils;

public abstract class SpiritJob
implements INBTSerializable<CompoundTag> {
    public SpiritEntity entity;
    public ResourceLocation factoryId;

    public SpiritJob(SpiritEntity entity) {
        this.entity = entity;
    }

    public static SpiritJob from(SpiritEntity entity, CompoundTag nbt) {
        SpiritJobFactory factory = (SpiritJobFactory)OccultismSpiritJobs.REGISTRY.get().getValue(new ResourceLocation(nbt.m_128461_("factoryId")));
        SpiritJob job = factory.create(entity);
        job.deserializeNBT(nbt);
        return job;
    }

    public ResourceLocation getFactoryID() {
        return this.factoryId;
    }

    public void setFactoryId(ResourceLocation factoryId) {
        this.factoryId = factoryId;
    }

    public CompoundTag serializeNBT() {
        return this.writeJobToNBT(new CompoundTag());
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.readJobFromNBT(nbt);
    }

    public final void init() {
        this.entity.remakeBrain();
        BrainUtils.setMemory((LivingEntity)this.entity, OccultismMemoryTypes.WORK_AREA_CENTER.get(), (Object)this.entity.getWorkAreaCenter());
        BrainUtils.setMemory((LivingEntity)this.entity, OccultismMemoryTypes.WORK_AREA_SIZE.get(), (Object)this.entity.getWorkAreaSize().getValue());
        BrainUtils.setMemory((LivingEntity)this.entity, OccultismMemoryTypes.DEPOSIT_POSITION.get(), (Object)this.entity.getDepositPosition().orElse(null));
        BrainUtils.setMemory((LivingEntity)this.entity, OccultismMemoryTypes.DEPOSIT_FACING.get(), (Object)this.entity.getDepositFacing());
        this.onInit();
    }

    protected abstract void onInit();

    public List<ExtendedSensor<SpiritEntity>> getSensors() {
        return ImmutableList.of();
    }

    public BrainActivityGroup<SpiritEntity> getCoreTasks() {
        return BrainActivityGroup.empty();
    }

    public BrainActivityGroup<SpiritEntity> getIdleTasks() {
        return BrainActivityGroup.empty();
    }

    public void handleAdditionalBrainSetup(Brain<? extends SpiritEntity> brain) {
    }

    public abstract void cleanup();

    public void update() {
    }

    public CompoundTag writeJobToNBT(CompoundTag compound) {
        compound.m_128359_("factoryId", this.getFactoryID().toString());
        return compound;
    }

    public void readJobFromNBT(CompoundTag compound) {
    }

    public boolean canPickupItem(ItemEntity entity) {
        return false;
    }

    public List<Ingredient> getItemsToPickUp() {
        return List.of();
    }

    public EntityDimensions getDimensions(Pose pPose, EntityDimensions original) {
        return original;
    }

    public void onChangeWorkArea() {
    }
}

