/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.misc;

import com.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.klikli_dev.occultism.common.data.NonNullArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class StorageControllerItemStackHandler
extends ItemStackHandler {
    protected int maxStackSize;
    protected int maxSlots;
    protected boolean overrideItemStackSizes;
    protected IStorageController storageController;

    public StorageControllerItemStackHandler(IStorageController storageController, int size, int maxStackSize, boolean overrideItemStackSizes) {
        this.stacks = NonNullArrayList.withSize(size, ItemStack.f_41583_);
        this.storageController = storageController;
        this.maxSlots = size;
        this.maxStackSize = maxStackSize;
        this.overrideItemStackSizes = overrideItemStackSizes;
    }

    public void setSize(int size) {
        if (size < 0) {
            return;
        }
        this.maxSlots = size;
        if (size > this.stacks.size()) {
            this.stacks.addAll(Collections.nCopies(size - this.stacks.size(), ItemStack.f_41583_));
        } else if (size < this.stacks.size()) {
            this.prune();
        }
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (slot > this.maxSlots - 1) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack result = this.extractItemOverride(slot, amount, simulate);
        if (!simulate && this.stacks.size() > this.maxSlots && ((ItemStack)this.stacks.get(slot)).m_41619_()) {
            this.stacks.remove(slot);
        }
        return result;
    }

    public ItemStack extractItemOverride(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        if (existing.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int toExtract = Math.min(amount, this.getStackLimit(-1, existing));
        if (existing.m_41613_() <= toExtract) {
            if (!simulate) {
                this.stacks.set(slot, (Object)ItemStack.f_41583_);
                this.onContentsChanged(slot);
                return existing;
            }
            return existing.m_41777_();
        }
        if (!simulate) {
            this.stacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.m_41613_() - toExtract)));
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public int getSlotLimit(int slot) {
        return this.maxStackSize;
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return this.overrideItemStackSizes ? this.getSlotLimit(slot) : Math.min(this.getSlotLimit(slot), stack.m_41741_());
    }

    public CompoundTag serializeNBT() {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (((ItemStack)this.stacks.get(i)).m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            ItemStack stack = (ItemStack)this.stacks.get(i);
            itemTag.m_128405_("Slot", i);
            stack.m_41739_(itemTag);
            itemTag.m_128405_("RealSize", stack.m_41613_());
            nbtTagList.add((Object)itemTag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Items", (Tag)nbtTagList);
        nbt.m_128405_("Size", this.stacks.size());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.setSize(nbt.m_128425_("Size", 3) ? nbt.m_128451_("Size") : this.stacks.size());
        ListTag tagList = nbt.m_128437_("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.m_128728_(i);
            int slot = itemTags.m_128451_("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            ItemStack stack = ItemStack.m_41712_((CompoundTag)itemTags);
            stack.m_41764_(itemTags.m_128451_("RealSize"));
            this.stacks.set(slot, (Object)stack);
        }
        this.onLoad();
    }

    protected void onContentsChanged(int slot) {
        this.storageController.onContentsChanged();
    }

    public void prune() {
        for (int i = this.stacks.size() - 1; i >= 0 && this.stacks.size() > this.maxSlots; --i) {
            if (!((ItemStack)this.stacks.get(i)).m_41619_()) continue;
            this.stacks.remove(i);
        }
    }
}

