/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.integration.jei.recipes;

import com.klikli_dev.occultism.crafting.recipe.CrushingRecipe;
import com.klikli_dev.occultism.integration.jei.JeiRecipeTypes;
import com.klikli_dev.occultism.util.GuiGraphicsExt;
import com.mojang.blaze3d.systems.RenderSystem;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;

public class CrushingRecipeCategory
implements IRecipeCategory<CrushingRecipe> {
    private final IDrawable background;
    private final Component localizedName;
    private final IDrawable overlay;

    public CrushingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(168, 56);
        this.localizedName = Component.m_237115_((String)"occultism.jei.crushing");
        this.overlay = guiHelper.createDrawable(new ResourceLocation("occultism", "textures/gui/jei/arrow.png"), 0, 0, 64, 46);
    }

    protected void drawStringCentered(GuiGraphics guiGraphics, Font font, Component text, int x, int y) {
        GuiGraphicsExt.drawString(guiGraphics, font, text, (float)x - (float)font.m_92852_((FormattedText)text) / 2.0f, (float)y, 0, false);
    }

    public RecipeType<CrushingRecipe> getRecipeType() {
        return JeiRecipeTypes.CRUSHING;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CrushingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 56, 12).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 94, 12).addItemStack(recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()));
    }

    public void draw(CrushingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        this.overlay.draw(guiGraphics, 76, 14);
        this.drawStringCentered(guiGraphics, Minecraft.m_91087_().f_91062_, this.getTitle(), 84, 0);
        int y = 35;
        if (recipe.getMinTier() >= 0) {
            this.drawStringCentered(guiGraphics, Minecraft.m_91087_().f_91062_, (Component)Component.m_237110_((String)"jei.occultism.crushing.min_tier", (Object[])new Object[]{recipe.getMinTier()}), 84, y);
            y += 10;
        }
        if (recipe.getMaxTier() >= 0) {
            this.drawStringCentered(guiGraphics, Minecraft.m_91087_().f_91062_, (Component)Component.m_237110_((String)"jei.occultism.crushing.max_tier", (Object[])new Object[]{recipe.getMaxTier()}), 84, y);
        }
    }
}

