/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.api.datagen.book;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookConditionModel;
import com.klikli_dev.modonomicon.book.BookCategoryBackgroundParallaxLayer;
import com.klikli_dev.modonomicon.registry.ItemRegistry;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class BookCategoryModel {
    protected BookModel book;
    protected ResourceLocation id;
    protected String name;
    protected BookIconModel icon = BookIconModel.create((ItemLike)ItemRegistry.MODONOMICON_PURPLE.get());
    protected int sortNumber = -1;
    protected ResourceLocation background = new ResourceLocation(ModonomiconConstants.Data.Category.DEFAULT_BACKGROUND);
    protected int backgroundWidth = 512;
    protected int backgroundHeight = 512;
    protected float backgroundTextureZoomMultiplier = 1.0f;
    protected List<BookCategoryBackgroundParallaxLayer> backgroundParallaxLayers = new ArrayList<BookCategoryBackgroundParallaxLayer>();
    protected ResourceLocation entryTextures = new ResourceLocation(ModonomiconConstants.Data.Category.DEFAULT_ENTRY_TEXTURES);
    protected List<BookEntryModel> entries = new ArrayList<BookEntryModel>();
    @Nullable
    protected BookConditionModel condition = null;
    protected boolean showCategoryButton = true;

    protected BookCategoryModel(ResourceLocation id, String name) {
        this.id = id;
        this.name = name;
    }

    public static BookCategoryModel create(ResourceLocation id, String name) {
        return new BookCategoryModel(id, name);
    }

    @Nullable
    public BookConditionModel getCondition() {
        return this.condition;
    }

    public boolean showCategoryButton() {
        return this.showCategoryButton;
    }

    public List<BookEntryModel> getEntries() {
        return this.entries;
    }

    public BookModel getBook() {
        return this.book;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.name);
        json.add("icon", (JsonElement)this.icon.toJson());
        json.addProperty("sort_number", (Number)this.sortNumber);
        json.addProperty("background", this.background.toString());
        json.addProperty("background_width", (Number)this.backgroundWidth);
        json.addProperty("background_height", (Number)this.backgroundHeight);
        json.addProperty("background_texture_zoom_multiplier", (Number)Float.valueOf(this.backgroundTextureZoomMultiplier));
        json.add("background_parallax_layers", (JsonElement)this.backgroundParallaxLayers.stream().map(layer -> (JsonElement)BookCategoryBackgroundParallaxLayer.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, layer).get().orThrow()).collect(JsonArray::new, JsonArray::add, JsonArray::addAll));
        json.addProperty("entry_textures", this.entryTextures.toString());
        if (this.condition != null) {
            json.add("condition", (JsonElement)this.condition.toJson());
        }
        json.addProperty("show_category_button", Boolean.valueOf(this.showCategoryButton));
        return json;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public BookIconModel getIcon() {
        return this.icon;
    }

    public int getSortNumber() {
        return this.sortNumber;
    }

    public ResourceLocation getBackground() {
        return this.background;
    }

    public int getBackgroundWidth() {
        return this.backgroundWidth;
    }

    public int getBackgroundHeight() {
        return this.backgroundHeight;
    }

    public List<BookCategoryBackgroundParallaxLayer> getBackgroundParallaxLayers() {
        return this.backgroundParallaxLayers;
    }

    public ResourceLocation getEntryTextures() {
        return this.entryTextures;
    }

    public BookCategoryModel withIcon(BookIconModel icon) {
        this.icon = icon;
        return this;
    }

    public BookCategoryModel withIcon(ResourceLocation texture) {
        this.icon = BookIconModel.create(texture);
        return this;
    }

    public BookCategoryModel withIcon(ResourceLocation texture, int width, int height) {
        this.icon = BookIconModel.create(texture, width, height);
        return this;
    }

    public BookCategoryModel withIcon(ItemLike item) {
        this.icon = BookIconModel.create(item);
        return this;
    }

    public BookCategoryModel withSortNumber(int sortNumber) {
        this.sortNumber = sortNumber;
        return this;
    }

    public BookCategoryModel withBackground(ResourceLocation background) {
        this.background = background;
        return this;
    }

    public BookCategoryModel withBackgroundSize(int width, int height) {
        this.backgroundWidth = width;
        this.backgroundHeight = height;
        return this;
    }

    public BookCategoryModel withBackgroundTextureZoomMultiplier(float backgroundTextureZoomMultiplier) {
        this.backgroundTextureZoomMultiplier = backgroundTextureZoomMultiplier;
        return this;
    }

    public BookCategoryModel withBackgroundParallaxLayers(BookCategoryBackgroundParallaxLayer ... layers) {
        this.backgroundParallaxLayers.addAll(List.of(layers));
        return this;
    }

    public BookCategoryModel withBackgroundParallaxLayer(BookCategoryBackgroundParallaxLayer layer) {
        this.backgroundParallaxLayers.add(layer);
        return this;
    }

    public BookCategoryModel withBackgroundParallaxLayer(ResourceLocation layerTexture) {
        this.backgroundParallaxLayers.add(new BookCategoryBackgroundParallaxLayer(layerTexture));
        return this;
    }

    public BookCategoryModel withEntryTextures(ResourceLocation entryTextures) {
        this.entryTextures = entryTextures;
        return this;
    }

    public BookCategoryModel withEntries(List<BookEntryModel> entries) {
        entries.forEach(this::linkEntry);
        this.entries.addAll(entries);
        return this;
    }

    protected BookEntryModel linkEntry(BookEntryModel entry) {
        entry.category = this;
        if (!entry.id.m_135815_().startsWith(this.id.m_135815_())) {
            entry.id = new ResourceLocation(entry.id.m_135827_(), this.id.m_135815_() + "/" + entry.id.m_135815_());
        }
        return entry;
    }

    public BookCategoryModel withEntries(BookEntryModel ... entries) {
        return this.withEntries(List.of(entries));
    }

    public BookCategoryModel withEntry(BookEntryModel entry) {
        this.entries.add(this.linkEntry(entry));
        return this;
    }

    public BookCategoryModel withCondition(BookConditionModel condition) {
        this.condition = condition;
        return this;
    }

    public BookCategoryModel withShowCategoryButton(boolean showCategoryButton) {
        this.showCategoryButton = showCategoryButton;
        return this;
    }
}

