/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class BookIcon {
    private final ItemStack itemStack;
    private final ResourceLocation texture;
    private final int width;
    private final int height;

    public BookIcon(ItemStack stack) {
        this.itemStack = stack;
        this.texture = null;
        this.width = 16;
        this.height = 16;
    }

    public BookIcon(ResourceLocation texture, int width, int height) {
        this.texture = texture;
        this.itemStack = ItemStack.f_41583_;
        this.width = width;
        this.height = height;
    }

    public static BookIcon fromJson(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            return BookIcon.fromString(new ResourceLocation(jsonElement.getAsString()));
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (jsonObject.has("item")) {
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"item")));
            return new BookIcon(new ItemStack((ItemLike)item));
        }
        if (jsonObject.has("texture")) {
            int width = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"width", (int)16);
            int height = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"height", (int)16);
            ResourceLocation texture = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"texture"));
            return new BookIcon(texture, width, height);
        }
        throw new JsonParseException("BookIcon must have either item or texture defined." + String.valueOf(jsonElement));
    }

    private static BookIcon fromString(ResourceLocation value) {
        if (value.m_135815_().endsWith(".png")) {
            return new BookIcon(value, 16, 16);
        }
        Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(value);
        return new BookIcon(new ItemStack((ItemLike)item));
    }

    public static BookIcon fromNetwork(FriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            ResourceLocation texture = buffer.m_130281_();
            int width = buffer.m_130242_();
            int height = buffer.m_130242_();
            return new BookIcon(texture, width, height);
        }
        ResourceLocation rl = buffer.m_130281_();
        Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(rl);
        return new BookIcon(new ItemStack((ItemLike)item));
    }

    public void render(GuiGraphics guiGraphics, int x, int y) {
        if (this.texture != null) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.m_280411_(this.texture, x, y, 16, 16, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        } else {
            guiGraphics.m_280480_(this.itemStack, x, y);
        }
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.texture != null);
        if (this.texture != null) {
            buffer.m_130085_(this.texture);
            buffer.m_130130_(this.width);
            buffer.m_130130_(this.height);
        } else {
            buffer.m_130085_(BuiltInRegistries.f_257033_.m_7981_((Object)this.itemStack.m_41720_()));
        }
    }
}

