/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.client.gui.book.BookCategoryScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookContentScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookErrorScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookHistoryEntry;
import com.klikli_dev.modonomicon.client.gui.book.BookOverviewScreen;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.platform.ClientServices;
import java.util.Stack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class BookGuiManager {
    private static final BookGuiManager instance = new BookGuiManager();
    private final Stack<BookHistoryEntry> history = new Stack();
    public Book currentBook;
    public BookCategory currentCategory;
    public BookEntry currentEntry;
    public BookOverviewScreen currentOverviewScreen;
    public BookCategoryScreen currentCategoryScreen;
    public BookContentScreen currentContentScreen;
    public BookOverviewScreen openOverviewScreen;

    private BookGuiManager() {
    }

    public static BookGuiManager get() {
        return instance;
    }

    public boolean showErrorScreen(ResourceLocation bookId) {
        if (BookErrorManager.get().hasErrors(bookId)) {
            Book book = BookDataManager.get().getBook(bookId);
            Minecraft.m_91087_().m_91152_((Screen)new BookErrorScreen(book));
            return true;
        }
        return false;
    }

    public void safeguardBooksBuilt() {
        if (!BookDataManager.get().areBooksBuilt()) {
            BookDataManager.get().tryBuildBooks((Level)Minecraft.m_91087_().f_91073_);
            BookDataManager.get().prerenderMarkdown();
        }
    }

    public void openBook(ResourceLocation bookId) {
        this.safeguardBooksBuilt();
        if (this.showErrorScreen(bookId)) {
            return;
        }
        Book book = BookDataManager.get().getBook(bookId);
        if (this.currentBook == book && this.currentOverviewScreen != null) {
            Minecraft.m_91087_().m_91152_((Screen)this.currentOverviewScreen);
            this.currentOverviewScreen.onDisplay();
        } else {
            this.currentBook = book;
            this.currentOverviewScreen = new BookOverviewScreen(this.currentBook);
            Minecraft.m_91087_().m_91152_((Screen)this.currentOverviewScreen);
            this.currentOverviewScreen.onDisplay();
        }
    }

    public void openEntry(ResourceLocation bookId, ResourceLocation entryId, int page) {
        Book book = BookDataManager.get().getBook(bookId);
        BookEntry entry = book.getEntry(entryId);
        this.openEntry(bookId, entry.getCategoryId(), entryId, page);
    }

    public void pushHistory(ResourceLocation bookId, @Nullable ResourceLocation entryId, int page) {
        Book book = BookDataManager.get().getBook(bookId);
        BookEntry entry = book.getEntry(entryId);
        this.history.push(new BookHistoryEntry(bookId, entry.getCategoryId(), entryId, page));
    }

    public void pushHistory(ResourceLocation bookId, @Nullable ResourceLocation categoryId, @Nullable ResourceLocation entryId, int page) {
        this.history.push(new BookHistoryEntry(bookId, categoryId, entryId, page));
    }

    public void pushHistory(BookHistoryEntry entry) {
        this.history.push(entry);
    }

    public BookHistoryEntry popHistory() {
        return this.history.pop();
    }

    public BookHistoryEntry peekHistory() {
        return this.history.peek();
    }

    public int getHistorySize() {
        return this.history.size();
    }

    public void resetHistory() {
        this.history.clear();
    }

    public void openEntry(ResourceLocation bookId, @Nullable ResourceLocation categoryId, @Nullable ResourceLocation entryId, int page) {
        Book book;
        this.safeguardBooksBuilt();
        if (bookId == null) {
            throw new IllegalArgumentException("bookId cannot be null");
        }
        if (this.showErrorScreen(bookId)) {
            return;
        }
        if (!BookDataManager.get().areBooksBuilt()) {
            BookDataManager.get().tryBuildBooks((Level)Minecraft.m_91087_().f_91073_);
            BookDataManager.get().prerenderMarkdown();
        }
        if (this.currentBook != (book = BookDataManager.get().getBook(bookId))) {
            this.currentBook = book;
        }
        if (this.currentOverviewScreen == null || this.currentOverviewScreen.getBook() != book) {
            this.currentOverviewScreen = new BookOverviewScreen(book);
        }
        Minecraft.m_91087_().m_91152_((Screen)this.currentOverviewScreen);
        if (categoryId == null) {
            return;
        }
        BookCategory category = book.getCategory(categoryId);
        if (this.currentCategory != category) {
            this.currentCategory = category;
        }
        if (this.currentCategoryScreen == null || this.currentCategoryScreen.getCategory() != category) {
            this.currentOverviewScreen.changeCategory(category);
            this.currentCategoryScreen = this.currentOverviewScreen.getCurrentCategoryScreen();
        }
        if (entryId == null) {
            return;
        }
        BookEntry entry = book.getEntry(entryId);
        if (this.currentEntry != entry) {
            this.currentEntry = entry;
        }
        if (this.currentContentScreen == null || this.currentContentScreen.getEntry() != entry) {
            this.currentContentScreen = this.currentCategoryScreen.openEntry(entry);
        } else {
            if (!this.isEntryAlreadyDisplayed(entry)) {
                ClientServices.GUI.pushGuiLayer(this.currentContentScreen);
            }
            this.currentCategoryScreen.setOpenEntry(entry.getId());
        }
        if (this.currentContentScreen != null) {
            this.currentContentScreen.goToPage(page, false);
        }
    }

    public boolean isEntryAlreadyDisplayed(BookEntry entry) {
        BookContentScreen bookContentScreen;
        Screen screen = Minecraft.m_91087_().f_91080_;
        return screen instanceof BookContentScreen && (bookContentScreen = (BookContentScreen)screen).getEntry().equals(entry);
    }
}

