/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.item;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.data.BookDataManager;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ModonomiconItem
extends Item {
    public ModonomiconItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public static Book getBook(ItemStack stack) {
        ResourceLocation res = ModonomiconItem.getBookId(stack);
        if (res == null) {
            return null;
        }
        return BookDataManager.get().getBook(res);
    }

    private static ResourceLocation getBookId(ItemStack stack) {
        if (!stack.m_41782_() || !stack.m_41783_().m_128441_("modonomicon:book_id")) {
            return null;
        }
        String bookStr = stack.m_41783_().m_128461_("modonomicon:book_id");
        return ResourceLocation.m_135820_((String)bookStr);
    }

    public static void setBookClosed(ItemStack stack) {
        if (stack != null && stack.m_41782_()) {
            stack.m_41783_().m_128359_("modonomicon:book_open_state", "closed");
        }
    }

    public static boolean isBookOpen(ItemStack stack) {
        if (stack != null && stack.m_41782_() && stack.m_41783_().m_128441_("modonomicon:book_open_state")) {
            return "open".equals(stack.m_41783_().m_128461_("modonomicon:book_open_state"));
        }
        return false;
    }

    public Book getBookFor(ItemStack stack) {
        return ModonomiconItem.getBook(stack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemInHand = pPlayer.m_21120_(pUsedHand);
        if (!itemInHand.m_41782_()) {
            itemInHand.m_41784_();
        }
        itemInHand.m_41783_().m_128359_("modonomicon:book_open_state", "open");
        if (pLevel.f_46443_) {
            if (itemInHand.m_41782_()) {
                Book book = this.getBookFor(itemInHand);
                BookGuiManager.get().openBook(book.getId());
            } else {
                Modonomicon.LOG.error("ModonomiconItem: ItemStack has no tag!");
            }
        }
        return InteractionResultHolder.m_19092_((Object)itemInHand, (boolean)pLevel.f_46443_);
    }

    public Component m_7626_(ItemStack pStack) {
        Book book = this.getBookFor(pStack);
        if (book != null) {
            return Component.m_237115_((String)book.getName());
        }
        return super.m_7626_(pStack);
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        Book book = this.getBookFor(stack);
        if (book != null) {
            if (flagIn.m_7050_()) {
                tooltip.add((Component)Component.m_237113_((String)"Book ID: ").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)Component.m_237113_((String)book.getId().toString()).m_130940_(ChatFormatting.RED)));
            }
            if (!book.getTooltip().isBlank()) {
                tooltip.add((Component)Component.m_237115_((String)book.getTooltip()).m_130940_(ChatFormatting.GRAY));
            }
        } else {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.modonomicon.no_book_found_for_stack", (Object[])new Object[]{!stack.m_41782_() ? Component.m_237113_((String)"{}") : NbtUtils.m_178061_((Tag)stack.m_41783_())}).m_130940_(ChatFormatting.DARK_GRAY));
        }
    }
}

