/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.common.blocks;

import com.ambient_expanded.registry.ParticleRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public class ButterflyBushBlock
extends BushBlock
implements BonemealableBlock {
    public ButterflyBushBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public void animateTick(BlockState state, Level p_401092_, BlockPos p_401110_, RandomSource p_401309_) {
        if (p_401309_.nextInt(30) == 0 && p_401092_.isMoonVisible() && p_401092_.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, p_401110_) <= p_401110_.getY()) {
            p_401092_.playLocalSound(p_401110_, SoundEvents.FIREFLY_BUSH_IDLE, SoundSource.AMBIENT, 1.0f, 1.0f, false);
        }
        if (!p_401092_.isMoonVisible()) {
            double d0 = (double)p_401110_.getX() + p_401309_.nextDouble() * 10.0 - 5.0;
            double d1 = (double)p_401110_.getY() + p_401309_.nextDouble() * 5.0;
            double d2 = (double)p_401110_.getZ() + p_401309_.nextDouble() * 10.0 - 5.0;
            p_401092_.addParticle((ParticleOptions)ParticleRegistry.BUTTERFLY.get(), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public boolean isValidBonemealTarget(LevelReader p_401250_, BlockPos p_401361_, BlockState p_401191_) {
        return BonemealableBlock.hasSpreadableNeighbourPos((LevelReader)p_401250_, (BlockPos)p_401361_, (BlockState)p_401191_);
    }

    public boolean isBonemealSuccess(Level p_401200_, RandomSource p_401387_, BlockPos p_401374_, BlockState p_401380_) {
        return true;
    }

    public void performBonemeal(ServerLevel p_401091_, RandomSource p_401012_, BlockPos p_401218_, BlockState p_401130_) {
        BonemealableBlock.findSpreadableNeighbourPos((Level)p_401091_, (BlockPos)p_401218_, (BlockState)p_401130_).ifPresent(p_401015_ -> p_401091_.setBlockAndUpdate(p_401015_, this.defaultBlockState()));
    }
}

