/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.common.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.IShearable;

public class DeadLeavesBlock
extends Block
implements SimpleWaterloggedBlock,
IShearable {
    public static final MapCodec<DeadLeavesBlock> CODEC = DeadLeavesBlock.simpleCodec(DeadLeavesBlock::new);
    public static final BooleanProperty WATERLOGGED;
    protected static final VoxelShape SHAPE;

    public MapCodec<? extends DeadLeavesBlock> codec() {
        return CODEC;
    }

    public DeadLeavesBlock(BlockBehaviour.Properties p_54422_) {
        super(p_54422_);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected boolean skipRendering(BlockState p_154268_, BlockState p_154269_, Direction p_154270_) {
        return p_154269_.is((Block)this) ? true : super.skipRendering(p_154268_, p_154269_, p_154270_);
    }

    protected void entityInside(BlockState p_154263_, Level p_154264_, BlockPos p_154265_, Entity p_154266_, InsideBlockEffectApplier p_405853_) {
        if (!(p_154266_ instanceof LivingEntity) || p_154266_.getInBlockState().is((Block)this)) {
            p_154266_.makeStuckInBlock(p_154263_, new Vec3((double)0.9f, 1.5, (double)0.9f));
            if (p_154264_.isClientSide()) {
                boolean flag;
                RandomSource randomsource = p_154264_.getRandom();
                boolean bl = flag = p_154266_.xOld != p_154266_.getX() || p_154266_.zOld != p_154266_.getZ();
                if (flag && randomsource.nextBoolean()) {
                    p_154264_.addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.TINTED_LEAVES, (int)8607809), p_154266_.getX(), (double)(p_154265_.getY() + 1), p_154266_.getZ(), (double)(Mth.randomBetween((RandomSource)randomsource, (float)-1.0f, (float)1.0f) * 0.083333336f), (double)0.05f, (double)(Mth.randomBetween((RandomSource)randomsource, (float)-1.0f, (float)1.0f) * 0.083333336f));
                }
            }
        }
    }

    protected boolean isPathfindable(BlockState p_154258_, PathComputationType p_154261_) {
        return true;
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void fallOn(Level p_153362_, BlockState p_153363_, BlockPos p_153364_, Entity p_153365_, float p_153366_) {
        p_153365_.causeFallDamage((double)p_153366_, 0.05f, p_153362_.damageSources().fall());
    }

    protected VoxelShape getBlockSupportShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return Shapes.empty();
    }

    protected int getLightBlock(BlockState p_54460_) {
        return 1;
    }

    protected BlockState updateShape(BlockState p_54440_, LevelReader p_374064_, ScheduledTickAccess p_374538_, BlockPos p_54444_, Direction p_54441_, BlockPos p_54445_, BlockState p_54442_, RandomSource p_374122_) {
        if (((Boolean)p_54440_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_374538_.scheduleTick(p_54444_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(p_374064_));
        }
        return p_54440_;
    }

    protected FluidState getFluidState(BlockState p_221384_) {
        return (Boolean)p_221384_.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_221384_);
    }

    public void animateTick(BlockState p_221374_, Level p_221375_, BlockPos p_221376_, RandomSource p_221377_) {
        BlockPos blockpos;
        BlockState blockstate;
        if (!(!p_221375_.isRainingAt(p_221376_.above()) || p_221377_.nextInt(15) != 1 || (blockstate = p_221375_.getBlockState(blockpos = p_221376_.below())).canOcclude() && blockstate.isFaceSturdy((BlockGetter)p_221375_, blockpos, Direction.UP))) {
            ParticleUtils.spawnParticleBelow((Level)p_221375_, (BlockPos)p_221376_, (RandomSource)p_221377_, (ParticleOptions)ParticleTypes.DRIPPING_WATER);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        BlockState blockstate = (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
        return blockstate;
    }

    static {
        SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        WATERLOGGED = BlockStateProperties.WATERLOGGED;
    }
}

