/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.common.entity.bear;

import com.ambient_expanded.common.entity.bear.BearAnimations;
import com.ambient_expanded.common.entity.bear.BearRenderState;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class BearModel
extends EntityModel<BearRenderState> {
    private final ModelPart body_roll;
    private final ModelPart body_roll2;
    private final ModelPart body_scratch;
    private final ModelPart body_attack;
    private final ModelPart body;
    private final ModelPart body_fish;
    private final ModelPart head_attack;
    private final ModelPart head;
    private final ModelPart head_scratch;
    private final ModelPart leg0;
    private final ModelPart leg0_scratch;
    private final ModelPart leg2;
    private final ModelPart leg2_scratch;
    private final ModelPart leg1;
    private final ModelPart leg1_scratch;
    private final ModelPart leg3;
    private final ModelPart leg3_scratch;
    private final KeyframeAnimation walkAnimation;
    private final KeyframeAnimation fishAnimation;
    private final KeyframeAnimation attackAnimation;
    private final KeyframeAnimation scratchAnimation;

    public BearModel(ModelPart root) {
        super(root);
        this.body_roll = root.getChild("body_roll");
        this.body_roll2 = this.body_roll.getChild("body_roll2");
        this.body_scratch = this.body_roll2.getChild("body_scratch");
        this.body_attack = this.body_scratch.getChild("body_attack");
        this.body = this.body_attack.getChild("body");
        this.body_fish = this.body.getChild("body_fish");
        this.head_attack = this.body_fish.getChild("head_attack");
        this.head = this.head_attack.getChild("head");
        this.head_scratch = this.head.getChild("head_scratch");
        this.leg0 = this.body_attack.getChild("leg0");
        this.leg0_scratch = this.leg0.getChild("leg0_scratch");
        this.leg2 = this.body_attack.getChild("leg2");
        this.leg2_scratch = this.leg2.getChild("leg2_scratch");
        this.leg1 = this.body_scratch.getChild("leg1");
        this.leg1_scratch = this.leg1.getChild("leg1_scratch");
        this.leg3 = this.body_scratch.getChild("leg3");
        this.leg3_scratch = this.leg3.getChild("leg3_scratch");
        this.walkAnimation = BearAnimations.WALK.bake(root);
        this.attackAnimation = BearAnimations.ATTACK.bake(root);
        this.scratchAnimation = BearAnimations.SCRATCH.bake(root);
        this.fishAnimation = BearAnimations.FISH.bake(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body_roll = partdefinition.addOrReplaceChild("body_roll", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)10.0f));
        PartDefinition body_roll2 = body_roll.addOrReplaceChild("body_roll2", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-18.0f, (float)0.0f));
        PartDefinition body_scratch = body_roll2.addOrReplaceChild("body_scratch", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)-10.0f));
        PartDefinition body_attack = body_scratch.addOrReplaceChild("body_attack", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.5f, (float)6.5f));
        PartDefinition body = body_attack.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.5f, (float)-6.5f));
        PartDefinition body_fish = body.addOrReplaceChild("body_fish", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -11.0f, -12.0f, 12.0f, 11.0f, 24.0f, new CubeDeformation(0.0f)).texOffs(0, 35).addBox(-7.0f, -12.0f, -5.0f, 14.0f, 13.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head_attack = body_fish.addOrReplaceChild("head_attack", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-5.0f, (float)-12.0f));
        PartDefinition head = head_attack.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head_scratch = head.addOrReplaceChild("head_scratch", CubeListBuilder.create().texOffs(48, 35).addBox(-4.5f, -4.0f, -6.0f, 9.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(36, 58).addBox(-5.5f, -5.0f, -4.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(36, 58).mirror().addBox(3.5f, -5.0f, -4.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(20, 58).addBox(-2.5f, 0.0f, -9.0f, 5.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leg0 = body_attack.addOrReplaceChild("leg0", CubeListBuilder.create(), PartPose.offset((float)-3.5f, (float)4.5f, (float)-14.0f));
        PartDefinition leg0_scratch = leg0.addOrReplaceChild("leg0_scratch", CubeListBuilder.create().texOffs(0, 58).addBox(-2.0f, -2.0f, -3.0f, 4.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leg2 = body_attack.addOrReplaceChild("leg2", CubeListBuilder.create(), PartPose.offset((float)3.5f, (float)4.5f, (float)-14.0f));
        PartDefinition leg2_scratch = leg2.addOrReplaceChild("leg2_scratch", CubeListBuilder.create().texOffs(0, 58).mirror().addBox(-2.0f, -2.0f, -3.0f, 4.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leg1 = body_scratch.addOrReplaceChild("leg1", CubeListBuilder.create(), PartPose.offset((float)-3.5f, (float)10.0f, (float)6.5f));
        PartDefinition leg1_scratch = leg1.addOrReplaceChild("leg1_scratch", CubeListBuilder.create().texOffs(48, 49).addBox(-2.0f, -2.0f, -3.5f, 4.0f, 10.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leg3 = body_scratch.addOrReplaceChild("leg3", CubeListBuilder.create(), PartPose.offset((float)3.5f, (float)10.0f, (float)6.5f));
        PartDefinition leg3_scratch = leg3.addOrReplaceChild("leg3_scratch", CubeListBuilder.create().texOffs(48, 49).mirror().addBox(-2.0f, -2.0f, -3.5f, 4.0f, 10.0f, 7.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(BearRenderState state) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.head.xRot = state.xRot * ((float)Math.PI / 180);
        this.head.yRot = state.yRot * ((float)Math.PI / 180);
        this.walkAnimation.applyWalk(state.walkAnimationPos, state.walkAnimationSpeed, 2.0f, 2.5f);
        this.fishAnimation.apply(state.FISHING, state.ageInTicks);
        this.attackAnimation.apply(state.ATTACKING, state.ageInTicks);
        this.scratchAnimation.apply(state.SCRATCHING, state.ageInTicks);
    }
}

