/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.common.entity.cluckshroom;

import com.ambient_expanded.common.entity.cluckshroom.CluckshroomVariant;
import com.ambient_expanded.registry.EntityRegistry;
import com.ambient_expanded.registry.LootTableRegistry;
import com.ambient_expanded.registry.SoundRegistry;
import com.ambient_expanded.registry.VariantRegistry;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.variant.PriorityProvider;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class CluckshroomEntity
extends Animal
implements Shearable {
    private static final EntityDimensions BABY_DIMENSIONS = EntityType.CHICKEN.getDimensions().scale(0.5f).withEyeHeight(0.2975f);
    private static final EntityDataAccessor<Holder<CluckshroomVariant>> DATA_VARIANT_ID = SynchedEntityData.defineId(CluckshroomEntity.class, EntityRegistry.CLUCKSHROOM_VARIANT.get());
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    public float flapping = 1.0f;
    private float nextFlap = 1.0f;
    public int eggTime = this.random.nextInt(6000) + 6000;
    @Nullable
    private UUID lastLightningBoltUUID;

    public CluckshroomEntity(EntityType<? extends CluckshroomEntity> p_28236_, Level p_28237_) {
        super(p_28236_, p_28237_);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, p_335679_ -> p_335679_.is(ItemTags.CHICKEN_FOOD), false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void thunderHit(ServerLevel level, LightningBolt lightning) {
        UUID uuid = lightning.getUUID();
        if (!uuid.equals(this.lastLightningBoltUUID)) {
            this.setVariant((Holder<CluckshroomVariant>)(this.getVariant().is(ResourceKey.create(VariantRegistry.CLUCKSHROOM_VARIANT_REGISTRY_KEY, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ambient_expanded", (String)"red"))) ? this.level().registryAccess().getOrThrow(ResourceKey.create(VariantRegistry.CLUCKSHROOM_VARIANT_REGISTRY_KEY, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ambient_expanded", (String)"brown"))) : this.level().registryAccess().getOrThrow(ResourceKey.create(VariantRegistry.CLUCKSHROOM_VARIANT_REGISTRY_KEY, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ambient_expanded", (String)"red")))));
            this.lastLightningBoltUUID = uuid;
            this.playSound((SoundEvent)SoundEvents.TRIDENT_THROW.value(), 5.0f, -3.0f);
        }
    }

    public EntityDimensions getDefaultDimensions(Pose p_316516_) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(p_316516_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 4.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader level) {
        return level.getBlockState(pos.below()).is(Blocks.MYCELIUM) ? 10.0f : level.getPathfindingCostFromLightLevels(pos);
    }

    public static boolean checkMushroomSpawnRules(EntityType<CluckshroomEntity> entityType, LevelAccessor level, EntitySpawnReason spawnReason, BlockPos pos, RandomSource random) {
        return level.getBlockState(pos.below()).is(BlockTags.MOOSHROOMS_SPAWNABLE_ON) && CluckshroomEntity.isBrightEnoughToSpawn((BlockAndTintGetter)level, (BlockPos)pos);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (itemstack.is(Items.SHEARS) && this.readyForShearing()) {
            Level var10 = this.level();
            if (var10 instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)var10;
                this.shear(serverlevel, SoundSource.PLAYERS, itemstack);
                this.gameEvent((Holder)GameEvent.SHEAR, (Entity)player);
                itemstack.hurtAndBreak(1, (LivingEntity)player, hand.asEquipmentSlot());
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public void shear(ServerLevel p_376375_, SoundSource p_28924_, ItemStack p_373092_) {
        p_376375_.playSound((Entity)null, (Entity)this, SoundEvents.MOOSHROOM_SHEAR, p_28924_, 1.0f, 1.0f);
        if (EventHooks.canLivingConvert((LivingEntity)this, (EntityType)EntityType.CHICKEN, timer -> {})) {
            this.convertTo(EntityType.CHICKEN, ConversionParams.single((Mob)this, (boolean)false, (boolean)false), p_409325_ -> {
                EventHooks.onLivingConvert((LivingEntity)this, (LivingEntity)p_409325_);
                p_376375_.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, this.getX(), this.getY(0.5), this.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
                for (int i = 0; i < 5; ++i) {
                    ItemEntity item = this.spawnAtLocation(p_376375_, ((CluckshroomVariant)this.getVariant().value()).blockState().getBlock().asItem().getDefaultInstance(), this.getBbHeight());
                    if (item == null) continue;
                    item.setNoPickUpDelay();
                }
            });
        }
    }

    public boolean readyForShearing() {
        return this.isAlive() && !this.isBaby();
    }

    public void aiStep() {
        super.aiStep();
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed += (this.onGround() ? -1.0f : 4.0f) * 0.3f;
        this.flapSpeed = Mth.clamp((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.onGround() && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping *= 0.9f;
        Vec3 vec3 = this.getDeltaMovement();
        if (!this.onGround() && vec3.y < 0.0) {
            this.setDeltaMovement(vec3.multiply(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
        Level var3 = this.level();
        if (var3 instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)var3;
            if (this.isAlive() && !this.isBaby() && --this.eggTime <= 0) {
                if (this.dropFromGiftLootTable(serverlevel, LootTableRegistry.CLUCKSHROOM_LAY, (arg_0, arg_1) -> ((CluckshroomEntity)this).spawnAtLocation(arg_0, arg_1))) {
                    this.playSound((SoundEvent)SoundRegistry.CLUCKSHROOM_EGG.get(), 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                    this.gameEvent((Holder)GameEvent.ENTITY_PLACE);
                }
                this.eggTime = this.random.nextInt(6000) + 6000;
            }
        }
    }

    protected boolean isFlapping() {
        return this.flyDist > this.nextFlap;
    }

    protected void onFlap() {
        this.nextFlap = this.flyDist + this.flapSpeed / 2.0f;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.CLUCKSHROOM_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)SoundRegistry.CLUCKSHROOM_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.CLUCKSHROOM_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState block) {
        this.playSound((SoundEvent)SoundRegistry.CLUCKSHROOM_STEP.get(), 0.15f, 1.0f);
    }

    @Nullable
    public CluckshroomEntity getBreedOffspring(ServerLevel p_148884_, AgeableMob p_148885_) {
        CluckshroomEntity chicken = (CluckshroomEntity)EntityRegistry.CLUCKSHROOM.get().create((Level)p_148884_, EntitySpawnReason.BREEDING);
        if (chicken != null && p_148885_ instanceof CluckshroomEntity) {
            CluckshroomEntity chicken1 = (CluckshroomEntity)p_148885_;
            chicken.setVariant(this.random.nextBoolean() ? this.getVariant() : chicken1.getVariant());
        }
        return chicken;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_401793_, DifficultyInstance p_401843_, EntitySpawnReason p_401765_, @Nullable SpawnGroupData p_401920_) {
        CluckshroomEntity.selectVariantToSpawn(this.random, this.registryAccess(), SpawnContext.create((ServerLevelAccessor)p_401793_, (BlockPos)this.blockPosition())).ifPresent(this::setVariant);
        return super.finalizeSpawn(p_401793_, p_401843_, p_401765_, p_401920_);
    }

    public static Optional<Holder.Reference<CluckshroomVariant>> selectVariantToSpawn(RandomSource p_401914_, RegistryAccess p_401933_, SpawnContext p_401763_) {
        return PriorityProvider.pick((Stream)p_401933_.lookupOrThrow(VariantRegistry.CLUCKSHROOM_VARIANT_REGISTRY_KEY).listElements(), Holder::value, (RandomSource)p_401914_, (Object)p_401763_);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(ItemTags.CHICKEN_FOOD);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_401813_) {
        super.defineSynchedData(p_401813_);
        p_401813_.define(DATA_VARIANT_ID, (Object)VariantUtils.getDefaultOrAny((RegistryAccess)this.registryAccess(), (ResourceKey)ResourceKey.create(VariantRegistry.CLUCKSHROOM_VARIANT_REGISTRY_KEY, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ambient_expanded", (String)"red"))));
    }

    public void readAdditionalSaveData(ValueInput compound) {
        super.readAdditionalSaveData(compound);
        compound.getInt("EggLayTime").ifPresent(p_409318_ -> {
            this.eggTime = p_409318_;
        });
        VariantUtils.readVariant((ValueInput)compound, VariantRegistry.CLUCKSHROOM_VARIANT_REGISTRY_KEY).ifPresent(this::setVariant);
    }

    public void addAdditionalSaveData(ValueOutput compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("EggLayTime", this.eggTime);
        VariantUtils.writeVariant((ValueOutput)compound, this.getVariant());
    }

    public void setVariant(Holder<CluckshroomVariant> p_401877_) {
        this.entityData.set(DATA_VARIANT_ID, p_401877_);
    }

    public Holder<CluckshroomVariant> getVariant() {
        return (Holder)this.entityData.get(DATA_VARIANT_ID);
    }

    @Nullable
    public <T> T get(DataComponentType<? extends T> p_401949_) {
        return (T)(p_401949_ == VariantRegistry.CLUCKSHROOM_VARIANT.get() ? CluckshroomEntity.castComponentValue(p_401949_, (Object)new EitherHolder(this.getVariant())) : super.get(p_401949_));
    }

    protected void applyImplicitComponents(DataComponentGetter p_401816_) {
        this.applyImplicitComponentIfPresent(p_401816_, VariantRegistry.CLUCKSHROOM_VARIANT.get());
        super.applyImplicitComponents(p_401816_);
    }

    protected <T> boolean applyImplicitComponent(DataComponentType<T> p_401879_, T p_401856_) {
        if (p_401879_ == VariantRegistry.CLUCKSHROOM_VARIANT.get()) {
            Optional optional = ((EitherHolder)CluckshroomEntity.castComponentValue(VariantRegistry.CLUCKSHROOM_VARIANT.get(), p_401856_)).unwrap((HolderLookup.Provider)this.registryAccess());
            if (optional.isPresent()) {
                this.setVariant((Holder<CluckshroomVariant>)((Holder)optional.get()));
                return true;
            }
            return false;
        }
        return super.applyImplicitComponent(p_401879_, p_401856_);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return true;
    }

    protected void positionRider(Entity p_289537_, Entity.MoveFunction p_289541_) {
        super.positionRider(p_289537_, p_289541_);
        if (p_289537_ instanceof LivingEntity) {
            ((LivingEntity)p_289537_).yBodyRot = this.yBodyRot;
        }
    }
}

