/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.common.entity.cluckshroom;

import com.ambient_expanded.common.entity.cluckshroom.CluckshroomRenderState;
import java.util.Set;
import net.minecraft.client.model.BabyModelTransform;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class CluckshroomModel
extends EntityModel<CluckshroomRenderState> {
    public static final String RED_THING = "red_thing";
    public static final float Y_OFFSET = 16.0f;
    public static final MeshTransformer BABY_TRANSFORMER = new BabyModelTransform(false, 5.0f, 2.0f, 2.0f, 1.99f, 24.0f, Set.of("head", "beak", "red_thing"));
    private final ModelPart head;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart rightWing;
    private final ModelPart leftWing;

    public CluckshroomModel(ModelPart root) {
        super(root);
        this.head = root.getChild("head");
        this.rightLeg = root.getChild("right_leg");
        this.leftLeg = root.getChild("left_leg");
        this.rightWing = root.getChild("right_wing");
        this.leftWing = root.getChild("left_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = CluckshroomModel.createBaseChickenModel();
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    protected static MeshDefinition createBaseChickenModel() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -6.0f, -2.0f, 4.0f, 6.0f, 3.0f), PartPose.offset((float)0.0f, (float)15.0f, (float)-4.0f));
        partdefinition1.addOrReplaceChild("beak", CubeListBuilder.create().texOffs(14, 0).addBox(-2.0f, -4.0f, -4.0f, 4.0f, 2.0f, 2.0f), PartPose.ZERO);
        partdefinition1.addOrReplaceChild(RED_THING, CubeListBuilder.create().texOffs(14, 4).addBox(-1.0f, -2.0f, -3.0f, 2.0f, 2.0f, 2.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 9).addBox(-3.0f, -4.0f, -3.0f, 6.0f, 8.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)16.0f, (float)0.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        CubeListBuilder cubelistbuilder = CubeListBuilder.create().texOffs(26, 0).addBox(-1.0f, 0.0f, -3.0f, 3.0f, 5.0f, 3.0f);
        partdefinition.addOrReplaceChild("right_leg", cubelistbuilder, PartPose.offset((float)-2.0f, (float)19.0f, (float)1.0f));
        partdefinition.addOrReplaceChild("left_leg", cubelistbuilder, PartPose.offset((float)1.0f, (float)19.0f, (float)1.0f));
        partdefinition.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(24, 13).addBox(0.0f, 0.0f, -3.0f, 1.0f, 4.0f, 6.0f), PartPose.offset((float)-4.0f, (float)13.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(24, 13).addBox(-1.0f, 0.0f, -3.0f, 1.0f, 4.0f, 6.0f), PartPose.offset((float)4.0f, (float)13.0f, (float)0.0f));
        return meshdefinition;
    }

    public ModelPart getHead() {
        return this.head;
    }

    public void setupAnim(CluckshroomRenderState p_364616_) {
        super.setupAnim((Object)p_364616_);
        float f = (Mth.sin((float)p_364616_.flap) + 1.0f) * p_364616_.flapSpeed;
        this.head.xRot = p_364616_.xRot * ((float)Math.PI / 180);
        this.head.yRot = p_364616_.yRot * ((float)Math.PI / 180);
        float f1 = p_364616_.walkAnimationSpeed;
        float f2 = p_364616_.walkAnimationPos;
        this.rightLeg.xRot = Mth.cos((float)(f2 * 0.6662f)) * 1.4f * f1;
        this.leftLeg.xRot = Mth.cos((float)(f2 * 0.6662f + (float)Math.PI)) * 1.4f * f1;
        this.rightWing.zRot = f;
        this.leftWing.zRot = -f;
    }
}

