/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.common.entity.deer;

import com.ambient_expanded.registry.EntityRegistry;
import com.mojang.datafixers.DataFixUtils;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class DeerEntity
extends Animal {
    private static final EntityDataAccessor<Boolean> IS_SPRINTING = SynchedEntityData.defineId(DeerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_EATING = SynchedEntityData.defineId(DeerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int eatingCounter;
    @Nullable
    private DeerEntity leader;
    private int schoolSize = 1;
    private int jumpTicks;
    private int jumpDuration;
    public final AnimationState eating = new AnimationState();

    public DeerEntity(EntityType<? extends DeerEntity> type, Level level) {
        super(type, level);
        this.jumpControl = new DeerJumpControl(this);
        this.getNavigation().setRequiredPathLength(40.0f);
    }

    public void addAdditionalSaveData(ValueOutput tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("Sprinting", this.isSprinting());
        tag.putBoolean("Eating", this.isEating());
    }

    public void readAdditionalSaveData(ValueInput tag) {
        super.readAdditionalSaveData(tag);
        this.setIsSprinting(tag.getBooleanOr("Sprinting", false));
        this.setIsEating(tag.getBooleanOr("Eating", false));
    }

    public boolean isFood(ItemStack itemStack) {
        return false;
    }

    public boolean isSprinting() {
        return (Boolean)this.entityData.get(IS_SPRINTING);
    }

    public void setIsSprinting(boolean v) {
        this.entityData.set(IS_SPRINTING, (Object)v);
    }

    public boolean isEating() {
        return (Boolean)this.entityData.get(IS_EATING);
    }

    public void setIsEating(boolean v) {
        this.entityData.set(IS_EATING, (Object)v);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_SPRINTING, (Object)false);
        builder.define(IS_EATING, (Object)false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.JUMP_STRENGTH, 0.5);
    }

    public void aiStep() {
        super.aiStep();
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
            this.setJumping(false);
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (this.isAlive() && !this.isEating() && !this.isVehicle()) {
                if (this.random.nextInt(300) == 0 && server.getBlockState(this.blockPosition().below()).is(Blocks.GRASS_BLOCK)) {
                    this.setIsEating(true);
                    this.level().broadcastEntityEvent((Entity)this, (byte)66);
                }
                if (this.isEating() && ++this.eatingCounter > 200) {
                    server.playSound((Entity)this, this.blockPosition(), SoundEvents.HORSE_EAT, SoundSource.NEUTRAL);
                    this.eatingCounter = 0;
                    this.setIsEating(false);
                }
            }
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 66) {
            this.eating.startIfStopped(this.tickCount);
        } else {
            super.handleEntityEvent(id);
        }
    }

    protected float getJumpPower() {
        Path path;
        float f = 0.3f;
        if (this.moveControl.getSpeedModifier() <= 0.6) {
            f = 0.2f;
        }
        if ((path = this.navigation.getPath()) != null && !path.isDone()) {
            Vec3 vec3 = path.getNextEntityPos((Entity)this);
            if (vec3.y > this.getY() + 0.5) {
                f = 0.5f;
            }
        }
        if (this.horizontalCollision || this.jumping && this.moveControl.getWantedY() > this.getY() + 0.5) {
            f = 0.5f;
        }
        return super.getJumpPower(f / 0.42f);
    }

    public void startJumping() {
        this.setJumping(true);
        this.jumpDuration = 10;
        this.jumpTicks = 0;
    }

    public void jumpFromGround() {
        double dist;
        super.jumpFromGround();
        double speed = this.moveControl.getSpeedModifier();
        if (speed > 0.0 && (dist = this.getDeltaMovement().horizontalDistanceSqr()) < 0.01) {
            this.moveRelative(0.1f, new Vec3(0.0, 0.0, 1.0));
        }
        if (!this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)1);
        }
    }

    public boolean isFollower() {
        return this.leader != null && this.leader.isAlive();
    }

    public boolean canBeFollowed() {
        return this.hasFollowers() && this.schoolSize < this.getMaxSchoolSize();
    }

    public void startFollowing(DeerEntity l) {
        this.leader = l;
        l.addFollower();
    }

    public void stopFollowing() {
        if (this.leader != null) {
            this.leader.removeFollower();
        }
        this.leader = null;
    }

    public boolean hasFollowers() {
        return this.schoolSize > 1;
    }

    public int getMaxSchoolSize() {
        return 5;
    }

    private void addFollower() {
        ++this.schoolSize;
    }

    private void removeFollower() {
        if (this.schoolSize > 1) {
            --this.schoolSize;
        }
    }

    public boolean inRangeOfLeader() {
        return this.leader != null && this.distanceToSqr((Entity)this.leader) <= 121.0;
    }

    public void pathToLeader() {
        if (this.isFollower()) {
            this.getNavigation().moveTo((Entity)this.leader, 1.0);
        }
    }

    @Nullable
    public DeerEntity getBreedOffspring(ServerLevel level, AgeableMob mate) {
        return (DeerEntity)EntityRegistry.DEER.get().create((Level)level, EntitySpawnReason.BREEDING);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance diff, EntitySpawnReason reason, @Nullable SpawnGroupData data) {
        super.finalizeSpawn(level, diff, reason, data);
        if (data == null) {
            data = new SchoolSpawnGroupData(this);
        } else {
            this.startFollowing(((SchoolSpawnGroupData)((Object)data)).leader);
        }
        return data;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.goalSelector.addGoal(2, new DeerAvoidEntityGoal<Monster>(this, Monster.class, 16.0f, 2.0, 2.0));
        this.goalSelector.addGoal(3, (Goal)new FollowLeaderGoal(this));
        this.goalSelector.addGoal(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new TemptGoal((PathfinderMob)this, 1.25, stack -> stack.is(ItemTags.LLAMA_TEMPT_ITEMS), false));
        this.goalSelector.addGoal(6, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static class DeerJumpControl
    extends JumpControl {
        private final DeerEntity deer;
        private boolean canJump;

        public DeerJumpControl(DeerEntity deer) {
            super((Mob)deer);
            this.deer = deer;
        }

        public boolean wantJump() {
            return this.jump;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean v) {
            this.canJump = v;
        }

        public void tick() {
            if (this.jump) {
                this.deer.startJumping();
                this.jump = false;
            }
        }
    }

    public static class SchoolSpawnGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final DeerEntity leader;

        public SchoolSpawnGroupData(DeerEntity leader) {
            super(true);
            this.leader = leader;
        }
    }

    static class DeerAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final DeerEntity deer;

        public DeerAvoidEntityGoal(DeerEntity deer, Class<T> toAvoid, float maxDist, double walkSpeed, double sprintSpeed) {
            super((PathfinderMob)deer, toAvoid, maxDist, walkSpeed, sprintSpeed);
            this.deer = deer;
        }

        public boolean canUse() {
            return !this.deer.isEating() && super.canUse();
        }

        public boolean canContinueToUse() {
            return !this.deer.isEating() && super.canContinueToUse();
        }

        public void start() {
            this.deer.setIsSprinting(true);
            this.deer.setIsEating(false);
            super.start();
        }

        public void stop() {
            this.deer.setIsSprinting(false);
            super.stop();
        }
    }

    public static class FollowLeaderGoal
    extends Goal {
        private final DeerEntity mob;
        private int timeToRecalcPath;
        private int nextStartTick;

        public FollowLeaderGoal(DeerEntity deer) {
            this.mob = deer;
            this.nextStartTick = this.nextStartTick(deer);
        }

        protected int nextStartTick(DeerEntity taskOwner) {
            return FollowLeaderGoal.reducedTickDelay((int)(200 + taskOwner.getRandom().nextInt(200) % 20));
        }

        public boolean canUse() {
            if (this.mob.hasFollowers()) {
                return false;
            }
            if (this.mob.isFollower()) {
                return true;
            }
            if (this.nextStartTick > 0) {
                --this.nextStartTick;
                return false;
            }
            this.nextStartTick = this.nextStartTick(this.mob);
            Predicate<DeerEntity> predicate = d -> d.canBeFollowed() || !d.isFollower();
            List list = this.mob.level().getEntitiesOfClass(((Object)((Object)this.mob)).getClass(), this.mob.getBoundingBox().inflate(8.0), predicate);
            DeerEntity leader = (DeerEntity)((Object)DataFixUtils.orElse(list.stream().filter(DeerEntity::canBeFollowed).findAny(), (Object)((Object)this.mob)));
            leader.addFollower();
            return this.mob.isFollower();
        }

        public boolean canContinueToUse() {
            return this.mob.isFollower() && this.mob.inRangeOfLeader();
        }

        public void start() {
            this.timeToRecalcPath = 0;
        }

        public void stop() {
            this.mob.stopFollowing();
        }

        public void tick() {
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.adjustedTickDelay(10);
                this.mob.pathToLeader();
            }
        }
    }
}

