/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.common.entity.hummingbird;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.phys.Vec3;

public class SmoothFlyingControl
extends FlyingMoveControl {
    public SmoothFlyingControl(Mob mob) {
        super(mob, 20, true);
    }

    public void tick() {
        if (this.operation == MoveControl.Operation.MOVE_TO) {
            this.operation = MoveControl.Operation.WAIT;
            Vec3 target = new Vec3(this.wantedX, this.wantedY, this.wantedZ);
            Vec3 currentPos = this.mob.position();
            Vec3 direction = target.subtract(currentPos);
            double distance = direction.length();
            if (distance < 0.1) {
                this.mob.setDeltaMovement(Vec3.ZERO);
                return;
            }
            Vec3 motion = direction.normalize().scale(Mth.clamp((double)(this.speedModifier * 0.3), (double)0.1, (double)0.6));
            this.mob.setDeltaMovement(motion);
            float yaw = (float)(Mth.atan2((double)motion.z, (double)motion.x) * 57.29577951308232) - 90.0f;
            this.mob.setYRot(yaw);
            this.mob.yBodyRot = yaw;
        }
    }
}

