/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.common.particles;

import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleLimit;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class ButterflyParticle
extends SingleQuadParticle {
    private static final float PARTICLE_FADE_OUT_LIGHT_TIME = 0.3f;
    private static final float PARTICLE_FADE_IN_LIGHT_TIME = 0.1f;
    private static final float PARTICLE_FADE_OUT_ALPHA_TIME = 0.5f;
    private static final float PARTICLE_FADE_IN_ALPHA_TIME = 0.3f;
    private static final int PARTICLE_MIN_LIFETIME = 36;
    private static final int PARTICLE_MAX_LIFETIME = 180;

    public ButterflyParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, TextureAtlasSprite p_446415_) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, p_446415_);
        this.speedUpWhenYMotionIsBlocked = true;
        this.friction = 0.96f;
        this.quadSize *= 0.75f;
        this.yd *= (double)0.8f;
        this.xd *= (double)0.8f;
        this.zd *= (double)0.8f;
    }

    public SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.OPAQUE;
    }

    public int getLightColor(float p_401057_) {
        return 255;
    }

    public void tick() {
        super.tick();
        if (!this.level.getBlockState(BlockPos.containing((double)this.x, (double)this.y, (double)this.z)).isAir()) {
            this.remove();
        } else if (this.onGround || this.lifetime < 299 && (this.xd == 0.0 || this.zd == 0.0)) {
            this.remove();
        } else {
            this.setAlpha(ButterflyParticle.getFadeAmount(this.getLifetimeProgress(this.age), 0.1f, 1.0f));
            if (Math.random() > 0.95 || this.age == 1) {
                this.setParticleSpeed((double)-0.05f + (double)0.1f * Math.random(), (double)-0.05f + (double)0.1f * Math.random(), (double)-0.05f + (double)0.1f * Math.random());
            }
        }
    }

    private float getLifetimeProgress(float p_405074_) {
        return Mth.clamp((float)(p_405074_ / (float)this.lifetime), (float)0.9f, (float)1.0f);
    }

    private static float getFadeAmount(float p_405677_, float p_405084_, float p_405474_) {
        if (p_405677_ >= 1.0f - p_405084_) {
            return (1.0f - p_405677_) / p_405084_;
        }
        return p_405677_ <= p_405474_ ? p_405677_ / p_405474_ : 1.0f;
    }

    public static class FireflyProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public FireflyProvider(SpriteSet p_401168_) {
            this.sprite = p_401168_;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource p_447278_) {
            ButterflyParticle fireflyparticle = new ButterflyParticle(this, level, x, y, z, 0.5 - p_447278_.nextDouble(), p_447278_.nextBoolean() ? ySpeed : -ySpeed, 0.5 - p_447278_.nextDouble(), this.sprite.get(p_447278_)){

                public Optional<ParticleLimit> getParticleLimit() {
                    return Optional.of(new ParticleLimit(500));
                }
            };
            fireflyparticle.setLifetime(p_447278_.nextIntBetweenInclusive(200, 300));
            fireflyparticle.scale(1.5f);
            fireflyparticle.setAlpha(0.0f);
            return fireflyparticle;
        }
    }
}

