/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.common.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;

public class PollenAmbientParticle
extends SingleQuadParticle {
    private static final float ACCELERATION_SCALE = 0.0025f;
    private static final int INITIAL_LIFETIME = 300;
    private static final int CURVE_ENDPOINT_TIME = 300;
    private float rotSpeed;
    private final float spinAcceleration;
    private final float windBig;
    private boolean swirl;
    private boolean flowAway;
    private double xaFlowScale;
    private double zaFlowScale;
    private double swirlPeriod;

    public PollenAmbientParticle(ClientLevel p_383228_, double p_383201_, double p_382929_, double p_382848_, TextureAtlasSprite p_446062_, float p_383015_, float p_383012_, boolean p_383052_, boolean p_382926_, float p_383165_, float p_382942_) {
        super(p_383228_, p_383201_, p_382929_, p_382848_, p_446062_);
        float f;
        this.rotSpeed = (float)Math.toRadians(this.random.nextBoolean() ? -30.0 : 30.0);
        this.spinAcceleration = (float)Math.toRadians(this.random.nextBoolean() ? -5.0 : 5.0);
        this.windBig = p_383012_;
        this.swirl = p_383052_;
        this.flowAway = p_382926_;
        this.lifetime = 300;
        this.gravity = p_383015_ * 1.2f * 0.0025f;
        this.quadSize = f = p_383165_ * (this.random.nextBoolean() ? 0.05f : 0.075f);
        this.setSize(f, f);
        this.friction = 1.0f;
        this.yd = -p_382942_;
        float f1 = this.random.nextFloat();
        this.xaFlowScale = Math.cos(Math.toRadians(f1 * 60.0f)) * (double)this.windBig;
        this.zaFlowScale = Math.sin(Math.toRadians(f1 * 60.0f)) * (double)this.windBig;
        this.swirlPeriod = Math.toRadians(1000.0f + f1 * 3000.0f);
    }

    public SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.TRANSLUCENT;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.lifetime-- <= 0) {
            this.remove();
        }
        if (!this.removed) {
            float f = 300 - this.lifetime;
            float f1 = Math.min(f / 300.0f, 1.0f);
            double d0 = 0.0;
            double d1 = 0.0;
            if (this.flowAway) {
                d0 += this.xaFlowScale * Math.pow(f1, 1.25);
                d1 += this.zaFlowScale * Math.pow(f1, 1.25);
            }
            if (this.swirl) {
                d0 += (double)f1 * Math.cos((double)f1 * this.swirlPeriod) * (double)this.windBig;
                d1 += (double)f1 * Math.sin((double)f1 * this.swirlPeriod) * (double)this.windBig;
            }
            this.xd += d0 * (double)0.0025f;
            this.zd += d1 * (double)0.0025f;
            this.yd -= (double)this.gravity;
            this.rotSpeed += this.spinAcceleration / 20.0f;
            this.oRoll = this.roll;
            this.roll += this.rotSpeed / 20.0f;
            this.move(this.xd, this.yd, this.zd);
            if (this.onGround || this.lifetime < 299 && (this.xd == 0.0 || this.zd == 0.0)) {
                this.remove();
            }
            if (!this.removed) {
                this.xd *= (double)this.friction;
                this.yd *= (double)this.friction;
                this.zd *= (double)this.friction;
            }
        }
    }

    public static class PaleOakProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public PaleOakProvider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource p_447188_) {
            return new PollenAmbientParticle(level, x, y, z, this.sprites.get(p_447188_), 0.07f, 10.0f, true, false, 2.0f, 0.021f);
        }
    }
}

