/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.common.particles;

import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.ParticleLimit;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class WindBlowingParticles
extends SingleQuadParticle {
    protected boolean isGlowing;

    public WindBlowingParticles(ClientLevel p_172409_, double p_172411_, double p_172412_, double p_172413_, double p_172414_, double p_172415_, double p_172416_, TextureAtlasSprite p_446184_) {
        super(p_172409_, p_172411_, p_172412_ - 0.125, p_172413_, p_172414_, p_172415_, p_172416_, p_446184_);
        this.setSize(0.01f, 0.01f);
        this.quadSize *= this.random.nextFloat() * 0.6f + 0.6f;
        this.lifetime = (int)(16.0 / (Math.random() * 0.8 + 0.2));
        this.hasPhysics = false;
        this.friction = 1.0f;
        this.gravity = 0.0f;
    }

    public SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.OPAQUE;
    }

    public int getLightColor(float partialTick) {
        return this.isGlowing ? 240 : super.getLightColor(partialTick);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.preMoveUpdate();
        if (!this.removed) {
            this.yd -= (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            this.postMoveUpdate();
            if (!this.removed) {
                this.xd *= (double)0.98f;
                this.yd *= (double)0.98f;
                this.zd *= (double)0.98f;
            }
        }
    }

    protected void preMoveUpdate() {
        if (this.lifetime-- <= 0) {
            this.remove();
        }
    }

    protected void postMoveUpdate() {
    }

    public static class SporeBlossomAirProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public SporeBlossomAirProvider(SpriteSet sprites) {
            this.sprite = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel p_level, double p_x, double p_y, double p_z, double xSpeed, double ySpeed, double zSpeed, RandomSource p_446265_) {
            WindBlowingParticles suspendedparticle = new WindBlowingParticles(this, p_level, p_x, p_y, p_z, 0.0, -0.8f, 0.0, this.sprite.get(p_446265_)){

                public Optional<ParticleLimit> getParticleLimit() {
                    return Optional.of(new ParticleLimit(500));
                }
            };
            suspendedparticle.lifetime = Mth.randomBetweenInclusive((RandomSource)p_446265_, (int)500, (int)1000);
            suspendedparticle.gravity = 0.01f;
            suspendedparticle.setColor(0.32f, 0.5f, 0.22f);
            return suspendedparticle;
        }
    }
}

