/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.common.worldgen;

import com.ambient_expanded.common.blocks.FrostedFlowerBlock;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;

public class SnowyFlowerFeature
extends Feature<SimpleBlockConfiguration> {
    public SnowyFlowerFeature(Codec<SimpleBlockConfiguration> p_66808_) {
        super(p_66808_);
    }

    public boolean place(FeaturePlaceContext<SimpleBlockConfiguration> p_160341_) {
        SimpleBlockConfiguration simpleblockconfiguration = (SimpleBlockConfiguration)p_160341_.config();
        WorldGenLevel worldgenlevel = p_160341_.level();
        BlockPos blockpos = p_160341_.origin();
        BlockState blockstate = simpleblockconfiguration.toPlace().getState(p_160341_.random(), blockpos);
        if (blockstate.canSurvive((LevelReader)worldgenlevel, blockpos)) {
            if (blockstate.getBlock() instanceof FrostedFlowerBlock) {
                if (worldgenlevel.getBlockState(blockpos.below()).getBlock() instanceof GrassBlock) {
                    worldgenlevel.setBlock(blockpos.below(), (BlockState)Blocks.GRASS_BLOCK.defaultBlockState().setValue((Property)BlockStateProperties.SNOWY, (Comparable)Boolean.valueOf(true)), 2);
                    worldgenlevel.setBlock(blockpos, blockstate, 2);
                    return true;
                }
            } else {
                worldgenlevel.setBlock(blockpos, blockstate, 2);
            }
            if (simpleblockconfiguration.scheduleTick()) {
                worldgenlevel.scheduleTick(blockpos, worldgenlevel.getBlockState(blockpos).getBlock(), 1);
            }
            return true;
        }
        return false;
    }
}

