/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.common.blocks;

import com.ambient_expanded.registry.ParticleRegistry;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class TallDandelionBlock
extends DoublePlantBlock
implements BonemealableBlock {
    public static final MapCodec<TallDandelionBlock> CODEC = TallDandelionBlock.simpleCodec(TallDandelionBlock::new);

    public MapCodec<TallDandelionBlock> codec() {
        return CODEC;
    }

    public TallDandelionBlock(BlockBehaviour.Properties p_57296_) {
        super(p_57296_);
    }

    public void animateTick(BlockState p_222503_, Level p_222504_, BlockPos p_222505_, RandomSource p_222506_) {
        int i = p_222505_.getX();
        int j = p_222505_.getY();
        int k = p_222505_.getZ();
        double d0 = (double)i + p_222506_.nextDouble();
        double d1 = (double)j + 1.0;
        double d2 = (double)k + p_222506_.nextDouble();
        if (this.CanPlayRadiusParticle(p_222504_, p_222505_)) {
            if (p_222504_.random.nextFloat() < 0.25f) {
                p_222504_.addParticle((ParticleOptions)ParticleRegistry.FLOATING_POLLEN.get(), d0, d1, d2, 0.0, 0.0, 0.0);
            }
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int l = 0; l < 10; ++l) {
                blockpos$mutableblockpos.set(i + Mth.nextInt((RandomSource)p_222506_, (int)-10, (int)10), j - p_222506_.nextInt(10), k + Mth.nextInt((RandomSource)p_222506_, (int)-10, (int)10));
                BlockState blockstate = p_222504_.getBlockState((BlockPos)blockpos$mutableblockpos);
                if (blockstate.isCollisionShapeFullBlock((BlockGetter)p_222504_, (BlockPos)blockpos$mutableblockpos)) continue;
                p_222504_.addParticle((ParticleOptions)ParticleRegistry.POLLEN.get(), (double)blockpos$mutableblockpos.getX() + p_222506_.nextDouble(), (double)blockpos$mutableblockpos.getY() + p_222506_.nextDouble(), (double)blockpos$mutableblockpos.getZ() + p_222506_.nextDouble(), 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean CanPlayRadiusParticle(Level level, BlockPos pos) {
        return level.canSeeSky(pos.above()) && level.canSeeSky(pos);
    }

    public boolean isValidBonemealTarget(LevelReader p_256234_, BlockPos p_57304_, BlockState p_57305_) {
        return true;
    }

    public boolean isBonemealSuccess(Level p_222573_, RandomSource p_222574_, BlockPos p_222575_, BlockState p_222576_) {
        return true;
    }

    public void performBonemeal(ServerLevel p_222568_, RandomSource p_222569_, BlockPos p_222570_, BlockState p_222571_) {
        TallDandelionBlock.popResource((Level)p_222568_, (BlockPos)p_222570_, (ItemStack)new ItemStack((ItemLike)this));
    }
}

