/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.common.entity.bear;

import com.ambient_expanded.registry.SoundRegistry;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class BearEntity
extends Animal
implements NeutralMob {
    private static final EntityDataAccessor<Boolean> DATA_STANDING_ID = SynchedEntityData.defineId(BearEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private int remainingPersistentAngerTime;
    @javax.annotation.Nullable
    private UUID persistentAngerTarget;
    public final AnimationState FISH = new AnimationState();
    public final AnimationState SCRATCH = new AnimationState();
    private int scratchCooldownTicks = 0;
    private int fishCooldownTicks = 0;

    public BearEntity(EntityType<? extends BearEntity> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.STEP_HEIGHT, 1.0);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader level) {
        return this.fishCooldownTicks == 0 && level.getBlockState(pos.below()).is(Blocks.WATER) ? 10.0f : level.getPathfindingCostFromLightLevels(pos);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_STANDING_ID, (Object)false);
    }

    public boolean isStanding() {
        return (Boolean)this.entityData.get(DATA_STANDING_ID);
    }

    public void setStanding(boolean standing) {
        this.entityData.set(DATA_STANDING_ID, (Object)standing);
    }

    public void addAdditionalSaveData(ValueOutput tag) {
        super.addAdditionalSaveData(tag);
        this.addPersistentAngerSaveData(tag);
    }

    public void readAdditionalSaveData(ValueInput tag) {
        super.readAdditionalSaveData(tag);
        this.readPersistentAngerSaveData(this.level(), tag);
    }

    public boolean isFood(ItemStack itemStack) {
        return false;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    public void setRemainingPersistentAngerTime(int time) {
        this.remainingPersistentAngerTime = time;
    }

    public int getRemainingPersistentAngerTime() {
        return this.remainingPersistentAngerTime;
    }

    public void setPersistentAngerTarget(@javax.annotation.Nullable UUID target) {
        this.persistentAngerTarget = target;
    }

    @javax.annotation.Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void tick() {
        super.tick();
        if (this.scratchCooldownTicks > 0) {
            --this.scratchCooldownTicks;
        }
        if (this.fishCooldownTicks > 0) {
            --this.fishCooldownTicks;
        }
        if (!this.level().isClientSide) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
    }

    @javax.annotation.Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.BEAR_AMBIENT.get();
    }

    @javax.annotation.Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.BEAR_HURT.get();
    }

    @javax.annotation.Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.BEAR_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound((SoundEvent)SoundRegistry.BEAR_STEP.get(), 0.15f, 1.0f);
    }

    protected float getWaterSlowDown() {
        return 0.95f;
    }

    public void handleEntityEvent(byte id) {
        if (id == 66) {
            this.SCRATCH.startIfStopped(this.tickCount);
        } else if (id == 67) {
            this.SCRATCH.stop();
        } else if (id == 68) {
            this.FISH.startIfStopped(this.tickCount);
        } else if (id == 69) {
            this.FISH.stop();
        } else {
            super.handleEntityEvent(id);
        }
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PolarBearMeleeAttackGoal());
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new ScratchGoal(this, this));
        this.goalSelector.addGoal(3, (Goal)new FishingGoal(this));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    class PolarBearMeleeAttackGoal
    extends MeleeAttackGoal {
        PolarBearMeleeAttackGoal() {
            super((PathfinderMob)BearEntity.this, 1.25, true);
        }

        protected void checkAndPerformAttack(LivingEntity target) {
            if (this.canPerformAttack(target)) {
                this.resetAttackCooldown();
                this.mob.doHurtTarget((ServerLevel)this.mob.level(), (Entity)target);
                BearEntity.this.setStanding(false);
            } else if (this.mob.distanceToSqr((Entity)target) < 9.0) {
                if (this.isTimeToAttack()) {
                    BearEntity.this.setStanding(false);
                }
                if (this.getTicksUntilNextAttack() <= 10) {
                    BearEntity.this.setStanding(true);
                }
            } else {
                BearEntity.this.setStanding(false);
            }
        }

        public void stop() {
            BearEntity.this.setStanding(false);
            super.stop();
        }
    }

    class ScratchGoal
    extends Goal {
        private final BearEntity bear;
        private int scratchTicks;

        ScratchGoal(BearEntity this$0, BearEntity bear) {
            this.bear = bear;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return this.bear.scratchCooldownTicks == 0 && this.bear.getRandom().nextInt(1200) == 0;
        }

        public void start() {
            this.scratchTicks = 100;
            this.bear.level().broadcastEntityEvent((Entity)this.bear, (byte)66);
        }

        public boolean canContinueToUse() {
            return this.scratchTicks > 0;
        }

        public void tick() {
            --this.scratchTicks;
        }

        public void stop() {
            this.bear.level().broadcastEntityEvent((Entity)this.bear, (byte)67);
            this.bear.scratchCooldownTicks = 200 + this.bear.getRandom().nextInt(400);
        }
    }

    static class FishingGoal
    extends Goal {
        private final BearEntity bear;
        private int fishingTimer;

        public FishingGoal(BearEntity bear) {
            this.bear = bear;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return this.bear.fishCooldownTicks <= 0 && this.bear.getTarget() == null && this.bear.isInWater();
        }

        public boolean canContinueToUse() {
            return this.fishingTimer > 0 && this.bear.isInWater();
        }

        public void start() {
            this.fishingTimer = 60;
            this.bear.getNavigation().stop();
            this.bear.level().broadcastEntityEvent((Entity)this.bear, (byte)68);
        }

        public void tick() {
            --this.fishingTimer;
            this.bear.getLookControl().setLookAt(this.bear.getX(), this.bear.getY() - 0.5, this.bear.getZ());
            if (this.fishingTimer == 0) {
                this.catchFish();
                this.stop();
            }
        }

        private void catchFish() {
            Level level = this.bear.level();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel server = (ServerLevel)level;
            ItemStack fish = switch (this.bear.getRandom().nextInt(3)) {
                case 0 -> new ItemStack((ItemLike)Items.SALMON);
                case 1 -> new ItemStack((ItemLike)Items.COD);
                default -> new ItemStack((ItemLike)Items.TROPICAL_FISH);
            };
            ItemEntity drop = new ItemEntity((Level)server, this.bear.getX(), this.bear.getY() + 0.5, this.bear.getZ(), fish);
            server.addFreshEntity((Entity)drop);
            server.sendParticles((ParticleOptions)ParticleTypes.SPLASH, this.bear.getX(), this.bear.getY() + 0.5, this.bear.getZ(), 8, 0.3, 0.1, 0.3, 0.05);
            this.bear.playSound(SoundEvents.FISHING_BOBBER_SPLASH, 1.0f, 1.0f);
        }

        public void stop() {
            this.bear.level().broadcastEntityEvent((Entity)this.bear, (byte)69);
            this.fishingTimer = 0;
            this.bear.fishCooldownTicks = 200 + this.bear.getRandom().nextInt(200);
        }
    }
}

