/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.common.entity.redpanda;

import com.ambient_expanded.registry.EntityRegistry;
import com.ambient_expanded.registry.SoundRegistry;
import com.mojang.serialization.Codec;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.StrollThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.UUIDLookup;
import net.minecraft.world.level.entity.UniquelyIdentifyable;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.living.BabyEntitySpawnEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class RedPandaEntity
extends Animal {
    private static final EntityDataAccessor<Boolean> DATA_IS_SLEEPING;
    private static final EntityDataAccessor<Boolean> DATA_IS_DEFENDING;
    private static final EntityDataAccessor<Boolean> DATA_IS_INTRESTED;
    private static final EntityDataAccessor<Boolean> DATA_IS_SCARE;
    private static final EntityDataAccessor<Optional<EntityReference<LivingEntity>>> DATA_TRUSTED_ID_0;
    private static final EntityDataAccessor<Optional<EntityReference<LivingEntity>>> DATA_TRUSTED_ID_1;
    static final Predicate<ItemEntity> ALLOWED_ITEMS;
    private static final Predicate<Entity> TRUSTED_TARGET_SELECTOR;
    private static final Predicate<Entity> AVOID_PLAYERS;
    private static final EntityDimensions BABY_DIMENSIONS;
    private static final Codec<List<EntityReference<LivingEntity>>> TRUSTED_LIST_CODEC;
    private float interestedAngle;
    private float interestedAngleO;
    private int ticksSinceEaten;
    public AnimationState sleep = new AnimationState();
    public AnimationState scare_start = new AnimationState();
    public AnimationState scare = new AnimationState();
    public AnimationState scare_stop = new AnimationState();

    public RedPandaEntity(EntityType<? extends RedPandaEntity> p_28451_, Level p_28452_) {
        super(p_28451_, p_28452_);
        this.lookControl = new FoxLookControl();
        this.moveControl = new FoxMoveControl();
        this.setPathfindingMalus(PathType.DANGER_OTHER, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_OTHER, 0.0f);
        this.setCanPickUpLoot(true);
        this.getNavigation().setRequiredPathLength(32.0f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326335_) {
        super.defineSynchedData(p_326335_);
        p_326335_.define(DATA_TRUSTED_ID_0, Optional.empty());
        p_326335_.define(DATA_TRUSTED_ID_1, Optional.empty());
        p_326335_.define(DATA_IS_DEFENDING, (Object)false);
        p_326335_.define(DATA_IS_SLEEPING, (Object)false);
        p_326335_.define(DATA_IS_INTRESTED, (Object)false);
        p_326335_.define(DATA_IS_SCARE, (Object)false);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FoxFloatGoal());
        this.goalSelector.addGoal(1, (Goal)new ScareGoal(this));
        this.goalSelector.addGoal(0, (Goal)new ClimbOnTopOfPowderSnowGoal((Mob)this, this.level()));
        this.goalSelector.addGoal(2, (Goal)new FoxPanicGoal(2.2));
        this.goalSelector.addGoal(3, (Goal)new FoxBreedGoal(this, this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 16.0f, 1.6, 1.4, p_393133_ -> AVOID_PLAYERS.test((Entity)p_393133_) && !this.trusts((LivingEntity)p_393133_) && !this.isDefending()));
        this.goalSelector.addGoal(6, (Goal)new SeekShelterGoal(1.25));
        this.goalSelector.addGoal(7, (Goal)new SleepGoal());
        this.goalSelector.addGoal(8, (Goal)new FoxFollowParentGoal(this, 1.25));
        this.goalSelector.addGoal(9, (Goal)new FoxStrollThroughVillageGoal(32, 200));
        this.goalSelector.addGoal(10, (Goal)new FoxEatBerriesGoal(1.2f, 12, 1));
        this.goalSelector.addGoal(11, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(11, (Goal)new FoxSearchForItemsGoal());
        this.goalSelector.addGoal(12, (Goal)new FoxLookAtPlayerGoal((Mob)this, Player.class, 24.0f));
        this.targetSelector.addGoal(3, (Goal)new DefendTrustedTargetGoal(LivingEntity.class, false, false, (p_393134_, p_393135_) -> TRUSTED_TARGET_SELECTOR.test((Entity)p_393134_) && !this.trusts(p_393134_)));
    }

    public void aiStep() {
        if (!this.level().isClientSide && this.isAlive() && this.isEffectiveAi()) {
            LivingEntity livingentity;
            ++this.ticksSinceEaten;
            ItemStack itemstack = this.getItemBySlot(EquipmentSlot.MAINHAND);
            if (this.canEat(itemstack)) {
                if (this.ticksSinceEaten > 600) {
                    ItemStack itemstack1 = itemstack.finishUsingItem(this.level(), (LivingEntity)this);
                    if (!itemstack1.isEmpty()) {
                        this.setItemSlot(EquipmentSlot.MAINHAND, itemstack1);
                    }
                    this.ticksSinceEaten = 0;
                } else if (this.ticksSinceEaten > 560 && this.random.nextFloat() < 0.1f) {
                    this.playEatingSound();
                    this.level().broadcastEntityEvent((Entity)this, (byte)45);
                }
            }
            if ((livingentity = this.getTarget()) == null || !livingentity.isAlive()) {
                this.setIsInterested(false);
            }
        }
        if (this.isSleeping() || this.isImmobile()) {
            this.jumping = false;
            this.xxa = 0.0f;
            this.zza = 0.0f;
        }
        super.aiStep();
        if (this.isDefending() && this.random.nextFloat() < 0.05f) {
            this.playSound((SoundEvent)SoundRegistry.RED_PANDA_BITE.get(), 1.0f, 1.0f);
        }
    }

    protected boolean isImmobile() {
        return this.isDeadOrDying();
    }

    private boolean canEat(ItemStack stack) {
        return stack.has(DataComponents.FOOD) && this.getTarget() == null && this.onGround() && !this.isSleeping();
    }

    protected void populateDefaultEquipmentSlots(RandomSource p_218171_, DifficultyInstance p_218172_) {
        if (p_218171_.nextFloat() < 0.2f) {
            float f = p_218171_.nextFloat();
            ItemStack itemstack = f < 0.05f ? new ItemStack((ItemLike)Items.EMERALD) : (f < 0.2f ? new ItemStack((ItemLike)Items.EGG) : (f < 0.4f ? (p_218171_.nextBoolean() ? new ItemStack((ItemLike)Items.RABBIT_FOOT) : new ItemStack((ItemLike)Items.RABBIT_HIDE)) : (f < 0.6f ? new ItemStack((ItemLike)Items.WHEAT) : (f < 0.8f ? new ItemStack((ItemLike)Items.LEATHER) : new ItemStack((ItemLike)Items.FEATHER)))));
            this.setItemSlot(EquipmentSlot.MAINHAND, itemstack);
        }
    }

    public void handleEntityEvent(byte p_27562_) {
        if (p_27562_ == 66) {
            this.scare_start.start(this.tickCount);
        } else if (p_27562_ == 67) {
            this.scare.startIfStopped(this.tickCount);
            this.scare_start.stop();
        } else if (p_27562_ == 68) {
            this.scare.stop();
            this.scare_stop.start(this.tickCount);
        } else {
            super.handleEntityEvent(p_27562_);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MOVEMENT_SPEED, 0.20000001192092895).add(Attributes.MAX_HEALTH, 10.0).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.SAFE_FALL_DISTANCE, 5.0).add(Attributes.FOLLOW_RANGE, 32.0);
    }

    @Nullable
    public RedPandaEntity getBreedOffspring(ServerLevel p_148912_, AgeableMob p_148913_) {
        RedPandaEntity fox = (RedPandaEntity)EntityRegistry.RED_PANDA.get().create((Level)p_148912_, EntitySpawnReason.BREEDING);
        return fox;
    }

    public static boolean checkFoxSpawnRules(EntityType<RedPandaEntity> entityType, LevelAccessor level, EntitySpawnReason spawnReason, BlockPos pos, RandomSource random) {
        return level.getBlockState(pos.below()).is(BlockTags.FOXES_SPAWNABLE_ON) && RedPandaEntity.isBrightEnoughToSpawn((BlockAndTintGetter)level, (BlockPos)pos);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_28487_, DifficultyInstance p_28488_, EntitySpawnReason p_363726_, @Nullable SpawnGroupData p_28490_) {
        this.populateDefaultEquipmentSlots(p_28487_.getRandom(), p_28488_);
        return super.finalizeSpawn(p_28487_, p_28488_, p_363726_, p_28490_);
    }

    protected void playEatingSound() {
        this.playSound(SoundEvents.FOX_EAT, 1.0f, 1.0f);
    }

    public EntityDimensions getDefaultDimensions(Pose p_316477_) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(p_316477_);
    }

    Stream<EntityReference<LivingEntity>> getTrustedEntities() {
        return Stream.concat(((Optional)this.entityData.get(DATA_TRUSTED_ID_0)).stream(), ((Optional)this.entityData.get(DATA_TRUSTED_ID_1)).stream());
    }

    void addTrustedEntity(LivingEntity p_393835_) {
        this.addTrustedEntity((EntityReference<LivingEntity>)new EntityReference((UniquelyIdentifyable)p_393835_));
    }

    private void addTrustedEntity(EntityReference<LivingEntity> p_393599_) {
        if (((Optional)this.entityData.get(DATA_TRUSTED_ID_0)).isPresent()) {
            this.entityData.set(DATA_TRUSTED_ID_1, Optional.of(p_393599_));
        } else {
            this.entityData.set(DATA_TRUSTED_ID_0, Optional.of(p_393599_));
        }
    }

    public float getVoicePitch() {
        return 2.2f;
    }

    public void addAdditionalSaveData(ValueOutput compound) {
        super.addAdditionalSaveData(compound);
        compound.store("Trusted", TRUSTED_LIST_CODEC, this.getTrustedEntities().toList());
        compound.putBoolean("Sleeping", this.isSleeping());
    }

    public void readAdditionalSaveData(ValueInput compound) {
        super.readAdditionalSaveData(compound);
        this.clearTrusted();
        compound.read("Trusted", TRUSTED_LIST_CODEC).orElse(List.of()).forEach(this::addTrustedEntity);
        this.setSleeping(compound.getBooleanOr("Sleeping", false));
    }

    private void clearTrusted() {
        this.entityData.set(DATA_TRUSTED_ID_0, Optional.empty());
        this.entityData.set(DATA_TRUSTED_ID_1, Optional.empty());
    }

    boolean isDefending() {
        return (Boolean)this.entityData.get(DATA_IS_DEFENDING);
    }

    void setDefending(boolean defending) {
        this.entityData.set(DATA_IS_DEFENDING, (Object)defending);
    }

    public boolean isScaring() {
        return (Boolean)this.entityData.get(DATA_IS_SCARE);
    }

    void setScaring(boolean defending) {
        this.entityData.set(DATA_IS_SCARE, (Object)defending);
    }

    public boolean isSleeping() {
        return (Boolean)this.entityData.get(DATA_IS_SLEEPING);
    }

    void setSleeping(boolean sleeping) {
        this.entityData.set(DATA_IS_SLEEPING, (Object)sleeping);
    }

    protected boolean canDispenserEquipIntoSlot(EquipmentSlot p_371942_) {
        return p_371942_ == EquipmentSlot.MAINHAND && this.canPickUpLoot();
    }

    public boolean canHoldItem(ItemStack stack) {
        ItemStack itemstack = this.getItemBySlot(EquipmentSlot.MAINHAND);
        return itemstack.isEmpty() || this.ticksSinceEaten > 0 && stack.has(DataComponents.FOOD) && !itemstack.has(DataComponents.FOOD);
    }

    private void spitOutItem(ItemStack stack) {
        if (!stack.isEmpty() && !this.level().isClientSide) {
            ItemEntity itementity = new ItemEntity(this.level(), this.getX() + this.getLookAngle().x, this.getY() + 1.0, this.getZ() + this.getLookAngle().z, stack);
            itementity.setPickUpDelay(40);
            itementity.setThrower((Entity)this);
            this.playSound(SoundEvents.FOX_SPIT, 1.0f, 1.0f);
            this.level().addFreshEntity((Entity)itementity);
        }
    }

    private void dropItemStack(ItemStack stack) {
        ItemEntity itementity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), stack);
        this.level().addFreshEntity((Entity)itementity);
    }

    protected void pickUpItem(ServerLevel p_376527_, ItemEntity p_28514_) {
        ItemStack itemstack = p_28514_.getItem();
        if (this.canHoldItem(itemstack)) {
            int i = itemstack.getCount();
            if (i > 1) {
                this.dropItemStack(itemstack.split(i - 1));
            }
            this.spitOutItem(this.getItemBySlot(EquipmentSlot.MAINHAND));
            this.onItemPickup(p_28514_);
            this.setItemSlot(EquipmentSlot.MAINHAND, itemstack.split(1));
            this.setGuaranteedDrop(EquipmentSlot.MAINHAND);
            this.take((Entity)p_28514_, itemstack.getCount());
            p_28514_.discard();
            this.ticksSinceEaten = 0;
        }
    }

    public void tick() {
        boolean flag;
        super.tick();
        if (this.isEffectiveAi() && ((flag = this.isInWater()) || this.getTarget() != null || this.level().isThundering())) {
            this.wakeUp();
        }
        this.sleep.animateWhen(this.isSleeping(), this.tickCount);
        this.interestedAngleO = this.interestedAngle;
        this.interestedAngle = this.isInterested() ? (this.interestedAngle += (1.0f - this.interestedAngle) * 0.4f) : (this.interestedAngle += (0.0f - this.interestedAngle) * 0.4f);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(Items.BAMBOO);
    }

    protected void onOffspringSpawnedFromEgg(Player player, Mob child) {
        ((RedPandaEntity)child).addTrustedEntity((LivingEntity)player);
    }

    public boolean isJumping() {
        return this.jumping;
    }

    public void setIsInterested(boolean isInterested) {
        this.entityData.set(DATA_IS_INTRESTED, (Object)isInterested);
    }

    public boolean isInterested() {
        return (Boolean)this.entityData.get(DATA_IS_INTRESTED);
    }

    public float getHeadRollAngle(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.interestedAngleO, (float)this.interestedAngle) * 0.11f * (float)Math.PI;
    }

    public void setTarget(@Nullable LivingEntity livingEntity) {
        if (this.isDefending() && livingEntity == null) {
            this.setDefending(false);
        }
        super.setTarget(livingEntity);
    }

    void wakeUp() {
        this.setSleeping(false);
    }

    void clearStates() {
        this.setIsInterested(false);
        this.setSleeping(false);
        this.setDefending(false);
    }

    boolean canMove() {
        return !this.isSleeping();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        if (this.isSleeping()) {
            return (SoundEvent)SoundRegistry.RED_PANDA_SLEEP.get();
        }
        return (SoundEvent)SoundRegistry.RED_PANDA_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)SoundRegistry.RED_PANDA_HURT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.RED_PANDA_DEATH.get();
    }

    boolean trusts(LivingEntity p_394151_) {
        return this.getTrustedEntities().anyMatch(p_393132_ -> p_393132_.matches((UniquelyIdentifyable)p_394151_));
    }

    protected void dropAllDeathLoot(ServerLevel p_348640_, DamageSource p_28536_) {
        super.dropAllDeathLoot(p_348640_, p_28536_);
    }

    protected void dropEquipment(ServerLevel p_348640_) {
        super.dropEquipment(p_348640_);
        ItemStack itemstack = this.getItemBySlot(EquipmentSlot.MAINHAND);
        if (!itemstack.isEmpty()) {
            this.spawnAtLocation(p_348640_, itemstack);
            this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        }
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(0.55f * this.getEyeHeight()), (double)(this.getBbWidth() * 0.4f));
    }

    static {
        TRUSTED_LIST_CODEC = EntityReference.codec().listOf();
        DATA_IS_SLEEPING = SynchedEntityData.defineId(RedPandaEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        DATA_IS_INTRESTED = SynchedEntityData.defineId(RedPandaEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        DATA_IS_DEFENDING = SynchedEntityData.defineId(RedPandaEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        DATA_IS_SCARE = SynchedEntityData.defineId(RedPandaEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        DATA_TRUSTED_ID_0 = SynchedEntityData.defineId(RedPandaEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_LIVING_ENTITY_REFERENCE);
        DATA_TRUSTED_ID_1 = SynchedEntityData.defineId(RedPandaEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_LIVING_ENTITY_REFERENCE);
        ALLOWED_ITEMS = p_409320_ -> !p_409320_.hasPickUpDelay() && p_409320_.isAlive();
        TRUSTED_TARGET_SELECTOR = p_287481_ -> {
            LivingEntity livingentity;
            boolean var10000 = p_287481_ instanceof LivingEntity ? (livingentity = (LivingEntity)p_287481_).getLastHurtMob() != null && livingentity.getLastHurtMobTimestamp() < livingentity.tickCount + 600 : false;
            return var10000;
        };
        AVOID_PLAYERS = p_28463_ -> !p_28463_.isDiscrete() && EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(p_28463_);
        BABY_DIMENSIONS = EntityType.FOX.getDimensions().scale(0.5f).withEyeHeight(0.2975f);
    }

    public class FoxLookControl
    extends LookControl {
        public FoxLookControl() {
            super((Mob)RedPandaEntity.this);
        }

        public void tick() {
            if (!RedPandaEntity.this.isSleeping()) {
                super.tick();
            }
        }

        protected boolean resetXRotOnTick() {
            return !RedPandaEntity.this.isCrouching() && !RedPandaEntity.this.isInterested();
        }
    }

    class FoxMoveControl
    extends MoveControl {
        public FoxMoveControl() {
            super((Mob)RedPandaEntity.this);
        }

        public void tick() {
            if (RedPandaEntity.this.canMove()) {
                super.tick();
            }
        }
    }

    class FoxFloatGoal
    extends FloatGoal {
        public FoxFloatGoal() {
            super((Mob)RedPandaEntity.this);
        }

        public void start() {
            super.start();
            RedPandaEntity.this.clearStates();
        }

        public boolean canUse() {
            return RedPandaEntity.this.isInWater() && RedPandaEntity.this.getFluidHeight(FluidTags.WATER) > 0.25 || RedPandaEntity.this.isInLava() || RedPandaEntity.this.isInFluidType((fluidType, height) -> RedPandaEntity.this.canSwimInFluidType((FluidType)fluidType) && height > 0.25);
        }
    }

    class ScareGoal
    extends Goal {
        private final RedPandaEntity cat;
        private int scratchTicks;
        private static final TargetingConditions BAT_RESTING_TARGETING = TargetingConditions.forCombat();

        public ScareGoal(RedPandaEntity cat) {
            this.cat = cat;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean canUse() {
            ServerLevel serverLevel = (ServerLevel)RedPandaEntity.this.level();
            return !serverLevel.getNearbyEntities(Zombie.class, BAT_RESTING_TARGETING, (LivingEntity)RedPandaEntity.this, this.cat.getBoundingBox().inflate(12.0)).isEmpty() && !this.cat.isSleeping() && !this.cat.isInterested();
        }

        public void start() {
            this.cat.level().broadcastEntityEvent((Entity)this.cat, (byte)66);
            RedPandaEntity.this.setScaring(true);
        }

        public boolean canContinueToUse() {
            ServerLevel serverLevel = (ServerLevel)RedPandaEntity.this.level();
            return !serverLevel.getNearbyEntities(Zombie.class, BAT_RESTING_TARGETING, (LivingEntity)RedPandaEntity.this, this.cat.getBoundingBox().inflate(12.0)).isEmpty() && !this.cat.isSleeping() && !this.cat.isInterested();
        }

        public void tick() {
            this.cat.level().broadcastEntityEvent((Entity)this.cat, (byte)67);
            this.cat.getNavigation().stop();
            ServerLevel serverLevel = (ServerLevel)RedPandaEntity.this.level();
            List monster = serverLevel.getNearbyEntities(Zombie.class, BAT_RESTING_TARGETING, (LivingEntity)RedPandaEntity.this, this.cat.getBoundingBox().inflate(12.0));
            if (!monster.isEmpty()) {
                this.cat.getLookControl().setLookAt(((Zombie)monster.getFirst()).getX(), ((Zombie)monster.getFirst()).getEyeY(), ((Zombie)monster.getFirst()).getZ());
            }
        }

        public void stop() {
            this.cat.setScaring(false);
            this.cat.level().broadcastEntityEvent((Entity)this.cat, (byte)68);
        }
    }

    class FoxPanicGoal
    extends PanicGoal {
        public FoxPanicGoal(double speedModifier) {
            super((PathfinderMob)RedPandaEntity.this, speedModifier);
        }

        public boolean shouldPanic() {
            return !RedPandaEntity.this.isDefending() && super.shouldPanic();
        }
    }

    class FoxBreedGoal
    extends BreedGoal {
        public FoxBreedGoal(RedPandaEntity this$0, RedPandaEntity this$02, double speedModifier) {
            super((Animal)this$02, speedModifier);
        }

        public void start() {
            ((RedPandaEntity)this.animal).clearStates();
            ((RedPandaEntity)this.partner).clearStates();
            super.start();
        }

        protected void breed() {
            ServerLevel serverlevel = this.level;
            RedPandaEntity fox = (RedPandaEntity)this.animal.getBreedOffspring(serverlevel, (AgeableMob)this.partner);
            BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((Mob)this.animal, (Mob)this.partner, (AgeableMob)fox);
            boolean cancelled = ((BabyEntitySpawnEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled();
            fox = (RedPandaEntity)event.getChild();
            if (cancelled) {
                this.animal.setAge(6000);
                this.partner.setAge(6000);
                this.animal.resetLove();
                this.partner.resetLove();
            } else if (fox != null) {
                ServerPlayer serverplayer = this.animal.getLoveCause();
                ServerPlayer serverplayer1 = this.partner.getLoveCause();
                ServerPlayer serverplayer2 = serverplayer;
                if (serverplayer != null) {
                    fox.addTrustedEntity((LivingEntity)serverplayer);
                } else {
                    serverplayer2 = serverplayer1;
                }
                if (serverplayer1 != null && serverplayer != serverplayer1) {
                    fox.addTrustedEntity((LivingEntity)serverplayer1);
                }
                if (serverplayer2 != null) {
                    serverplayer2.awardStat(Stats.ANIMALS_BRED);
                    CriteriaTriggers.BRED_ANIMALS.trigger(serverplayer2, this.animal, this.partner, (AgeableMob)fox);
                }
                this.animal.setAge(6000);
                this.partner.setAge(6000);
                this.animal.resetLove();
                this.partner.resetLove();
                fox.setAge(-24000);
                fox.snapTo(this.animal.getX(), this.animal.getY(), this.animal.getZ(), 0.0f, 0.0f);
                serverlevel.addFreshEntityWithPassengers((Entity)fox);
                this.level.broadcastEntityEvent((Entity)this.animal, (byte)18);
                if (serverlevel.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
                    this.level.addFreshEntity((Entity)new ExperienceOrb((Level)this.level, this.animal.getX(), this.animal.getY(), this.animal.getZ(), this.animal.getRandom().nextInt(7) + 1));
                }
            }
        }
    }

    class SeekShelterGoal
    extends FleeSunGoal {
        private int interval;

        public SeekShelterGoal(double speedModifier) {
            super((PathfinderMob)RedPandaEntity.this, speedModifier);
            this.interval = SeekShelterGoal.reducedTickDelay((int)100);
        }

        public boolean canUse() {
            if (!RedPandaEntity.this.isSleeping() && this.mob.getTarget() == null) {
                if (RedPandaEntity.this.level().isThundering() && RedPandaEntity.this.level().canSeeSky(this.mob.blockPosition())) {
                    return this.setWantedPos();
                }
                if (this.interval > 0) {
                    --this.interval;
                    return false;
                }
                this.interval = 100;
                BlockPos blockpos = this.mob.blockPosition();
                return RedPandaEntity.this.level().isBrightOutside() && RedPandaEntity.this.level().canSeeSky(blockpos) && !((ServerLevel)RedPandaEntity.this.level()).isVillage(blockpos) && this.setWantedPos();
            }
            return false;
        }

        public void start() {
            RedPandaEntity.this.clearStates();
            super.start();
        }
    }

    class SleepGoal
    extends FoxBehaviorGoal {
        private static final int WAIT_TIME_BEFORE_SLEEP = SleepGoal.reducedTickDelay((int)140);
        private int countdown;

        public SleepGoal() {
            this.countdown = RedPandaEntity.this.random.nextInt(WAIT_TIME_BEFORE_SLEEP);
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean canUse() {
            return RedPandaEntity.this.xxa == 0.0f && RedPandaEntity.this.yya == 0.0f && RedPandaEntity.this.zza == 0.0f ? this.canSleep() || RedPandaEntity.this.isSleeping() : false;
        }

        public boolean canContinueToUse() {
            return this.canSleep();
        }

        private boolean canSleep() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            return RedPandaEntity.this.level().isBrightOutside() && this.hasShelter() && !this.alertable() && !RedPandaEntity.this.isInPowderSnow;
        }

        public void stop() {
            this.countdown = RedPandaEntity.this.random.nextInt(WAIT_TIME_BEFORE_SLEEP);
            RedPandaEntity.this.clearStates();
        }

        public void start() {
            RedPandaEntity.this.setSleeping(true);
            RedPandaEntity.this.getNavigation().stop();
            RedPandaEntity.this.getMoveControl().setWantedPosition(RedPandaEntity.this.getX(), RedPandaEntity.this.getY(), RedPandaEntity.this.getZ(), 0.0);
        }
    }

    static class FoxFollowParentGoal
    extends FollowParentGoal {
        private final RedPandaEntity fox;

        public FoxFollowParentGoal(RedPandaEntity fox, double speedModifier) {
            super((Animal)fox, speedModifier);
            this.fox = fox;
        }

        public boolean canUse() {
            return !this.fox.isDefending() && super.canUse();
        }

        public boolean canContinueToUse() {
            return !this.fox.isDefending() && super.canContinueToUse();
        }

        public void start() {
            this.fox.clearStates();
            super.start();
        }
    }

    class FoxStrollThroughVillageGoal
    extends StrollThroughVillageGoal {
        public FoxStrollThroughVillageGoal(int unused32, int interval) {
            super((PathfinderMob)RedPandaEntity.this, interval);
        }

        public void start() {
            RedPandaEntity.this.clearStates();
            super.start();
        }

        public boolean canUse() {
            return super.canUse() && this.canFoxMove();
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse() && this.canFoxMove();
        }

        private boolean canFoxMove() {
            return !RedPandaEntity.this.isSleeping() && !RedPandaEntity.this.isDefending() && RedPandaEntity.this.getTarget() == null;
        }
    }

    public class FoxEatBerriesGoal
    extends MoveToBlockGoal {
        private static final int WAIT_TICKS = 40;
        protected int ticksWaited;

        public FoxEatBerriesGoal(double speedModifier, int searchRange, int verticalSearchRange) {
            super((PathfinderMob)RedPandaEntity.this, speedModifier, searchRange, verticalSearchRange);
        }

        public double acceptedDistance() {
            return 2.0;
        }

        public boolean shouldRecalculatePath() {
            return this.tryTicks % 100 == 0;
        }

        protected boolean isValidTarget(LevelReader level, BlockPos pos) {
            BlockState blockstate = level.getBlockState(pos);
            return blockstate.is(Blocks.SWEET_BERRY_BUSH) && (Integer)blockstate.getValue((Property)SweetBerryBushBlock.AGE) >= 2 || CaveVines.hasGlowBerries((BlockState)blockstate);
        }

        public void tick() {
            if (this.isReachedTarget()) {
                if (this.ticksWaited >= 40) {
                    this.onReachedTarget();
                } else {
                    ++this.ticksWaited;
                }
            } else if (!this.isReachedTarget() && RedPandaEntity.this.random.nextFloat() < 0.05f) {
                RedPandaEntity.this.playSound(SoundEvents.FOX_SNIFF, 1.0f, 1.0f);
            }
            super.tick();
        }

        protected void onReachedTarget() {
            if (EventHooks.canEntityGrief((ServerLevel)FoxEatBerriesGoal.getServerLevel((Level)RedPandaEntity.this.level()), (Entity)RedPandaEntity.this)) {
                BlockState blockstate = RedPandaEntity.this.level().getBlockState(this.blockPos);
                if (blockstate.is(Blocks.SWEET_BERRY_BUSH)) {
                    this.pickSweetBerries(blockstate);
                } else if (CaveVines.hasGlowBerries((BlockState)blockstate)) {
                    this.pickGlowBerry(blockstate);
                }
            }
        }

        private void pickGlowBerry(BlockState state) {
            CaveVines.use((Entity)RedPandaEntity.this, (BlockState)state, (Level)RedPandaEntity.this.level(), (BlockPos)this.blockPos);
        }

        private void pickSweetBerries(BlockState state) {
            int i = (Integer)state.getValue((Property)SweetBerryBushBlock.AGE);
            state.setValue((Property)SweetBerryBushBlock.AGE, (Comparable)Integer.valueOf(1));
            int j = 1 + RedPandaEntity.this.level().random.nextInt(2) + (i == 3 ? 1 : 0);
            ItemStack itemstack = RedPandaEntity.this.getItemBySlot(EquipmentSlot.MAINHAND);
            if (itemstack.isEmpty()) {
                RedPandaEntity.this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.SWEET_BERRIES));
                --j;
            }
            if (j > 0) {
                Block.popResource((Level)RedPandaEntity.this.level(), (BlockPos)this.blockPos, (ItemStack)new ItemStack((ItemLike)Items.SWEET_BERRIES, j));
            }
            RedPandaEntity.this.playSound(SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, 1.0f, 1.0f);
            RedPandaEntity.this.level().setBlock(this.blockPos, (BlockState)state.setValue((Property)SweetBerryBushBlock.AGE, (Comparable)Integer.valueOf(1)), 2);
            RedPandaEntity.this.level().gameEvent((Holder)GameEvent.BLOCK_CHANGE, this.blockPos, GameEvent.Context.of((Entity)RedPandaEntity.this));
        }

        public boolean canUse() {
            return !RedPandaEntity.this.isSleeping() && super.canUse();
        }

        public void start() {
            this.ticksWaited = 0;
            super.start();
        }
    }

    class FoxSearchForItemsGoal
    extends Goal {
        public FoxSearchForItemsGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (!RedPandaEntity.this.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty()) {
                return false;
            }
            if (RedPandaEntity.this.getTarget() == null && RedPandaEntity.this.getLastHurtByMob() == null) {
                if (!RedPandaEntity.this.canMove()) {
                    return false;
                }
                if (RedPandaEntity.this.getRandom().nextInt(FoxSearchForItemsGoal.reducedTickDelay((int)10)) != 0) {
                    return false;
                }
                List list = RedPandaEntity.this.level().getEntitiesOfClass(ItemEntity.class, RedPandaEntity.this.getBoundingBox().inflate(8.0, 8.0, 8.0), ALLOWED_ITEMS);
                return !list.isEmpty() && RedPandaEntity.this.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty();
            }
            return false;
        }

        public void tick() {
            List list = RedPandaEntity.this.level().getEntitiesOfClass(ItemEntity.class, RedPandaEntity.this.getBoundingBox().inflate(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            ItemStack itemstack = RedPandaEntity.this.getItemBySlot(EquipmentSlot.MAINHAND);
            if (itemstack.isEmpty() && !list.isEmpty()) {
                RedPandaEntity.this.getNavigation().moveTo((Entity)list.get(0), (double)1.2f);
            }
        }

        public void start() {
            List list = RedPandaEntity.this.level().getEntitiesOfClass(ItemEntity.class, RedPandaEntity.this.getBoundingBox().inflate(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            if (!list.isEmpty()) {
                RedPandaEntity.this.getNavigation().moveTo((Entity)list.get(0), (double)1.2f);
            }
        }
    }

    class FoxLookAtPlayerGoal
    extends LookAtPlayerGoal {
        public FoxLookAtPlayerGoal(Mob mob, Class<? extends LivingEntity> lookAtType, float lookDistance) {
            super(mob, lookAtType, lookDistance);
        }

        public boolean canUse() {
            return super.canUse() && !RedPandaEntity.this.isInterested();
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse() && !RedPandaEntity.this.isInterested();
        }
    }

    class DefendTrustedTargetGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        @Nullable
        private LivingEntity trustedLastHurtBy;
        @Nullable
        private LivingEntity trustedLastHurt;
        private int timestamp;

        public DefendTrustedTargetGoal(Class<LivingEntity> targetType, boolean mustSee, @Nullable boolean mustReach, TargetingConditions.Selector selector) {
            super((Mob)RedPandaEntity.this, targetType, 10, mustSee, mustReach, selector);
        }

        public boolean canUse() {
            EntityReference<LivingEntity> entityreference;
            LivingEntity livingentity;
            if (this.randomInterval > 0 && this.mob.getRandom().nextInt(this.randomInterval) != 0) {
                return false;
            }
            ServerLevel serverlevel = DefendTrustedTargetGoal.getServerLevel((Level)RedPandaEntity.this.level());
            Iterator<EntityReference<LivingEntity>> var2 = RedPandaEntity.this.getTrustedEntities().toList().iterator();
            do {
                if (var2.hasNext()) continue;
                return false;
            } while ((livingentity = (LivingEntity)(entityreference = var2.next()).getEntity((UUIDLookup)serverlevel, LivingEntity.class)) == null);
            this.trustedLastHurt = livingentity;
            this.trustedLastHurtBy = livingentity.getLastHurtByMob();
            int i = livingentity.getLastHurtByMobTimestamp();
            return i != this.timestamp && this.canAttack(this.trustedLastHurtBy, this.targetConditions);
        }

        public void start() {
            this.setTarget(this.trustedLastHurtBy);
            this.target = this.trustedLastHurtBy;
            if (this.trustedLastHurt != null) {
                this.timestamp = this.trustedLastHurt.getLastHurtByMobTimestamp();
            }
            RedPandaEntity.this.playSound((SoundEvent)SoundRegistry.RED_PANDA_BITE.get(), 1.0f, 1.0f);
            RedPandaEntity.this.setDefending(true);
            RedPandaEntity.this.wakeUp();
            super.start();
        }
    }

    public class FoxAlertableEntitiesSelector
    implements TargetingConditions.Selector {
        public boolean test(LivingEntity p_28653_, ServerLevel p_376835_) {
            if (p_28653_ instanceof RedPandaEntity) {
                return false;
            }
            if (!(p_28653_ instanceof Chicken || p_28653_ instanceof Rabbit || p_28653_ instanceof Monster)) {
                Player player;
                if (p_28653_ instanceof TamableAnimal) {
                    return !((TamableAnimal)p_28653_).isTame();
                }
                if (p_28653_ instanceof Player && ((player = (Player)p_28653_).isSpectator() || player.isCreative())) {
                    return false;
                }
                return RedPandaEntity.this.trusts(p_28653_) ? false : !p_28653_.isSleeping() && !p_28653_.isDiscrete();
            }
            return true;
        }
    }

    abstract class FoxBehaviorGoal
    extends Goal {
        private final TargetingConditions alertableTargeting;

        FoxBehaviorGoal() {
            TargetingConditions var10001 = TargetingConditions.forCombat().range(12.0).ignoreLineOfSight();
            RedPandaEntity var10004 = RedPandaEntity.this;
            Objects.requireNonNull(var10004);
            this.alertableTargeting = var10001.selector((TargetingConditions.Selector)var10004.new FoxAlertableEntitiesSelector());
        }

        protected boolean hasShelter() {
            BlockPos blockpos = BlockPos.containing((double)RedPandaEntity.this.getX(), (double)RedPandaEntity.this.getBoundingBox().maxY, (double)RedPandaEntity.this.getZ());
            return !RedPandaEntity.this.level().canSeeSky(blockpos) && RedPandaEntity.this.getWalkTargetValue(blockpos) >= 0.0f;
        }

        protected boolean alertable() {
            return !FoxBehaviorGoal.getServerLevel((Level)RedPandaEntity.this.level()).getNearbyEntities(LivingEntity.class, this.alertableTargeting, (LivingEntity)RedPandaEntity.this, RedPandaEntity.this.getBoundingBox().inflate(12.0, 6.0, 12.0)).isEmpty();
        }
    }
}

