/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.registry;

import com.ambient_expanded.common.entity.bear.BearEntity;
import com.ambient_expanded.common.entity.bear.BearVariant;
import com.ambient_expanded.common.entity.cluckshroom.CluckshroomEntity;
import com.ambient_expanded.common.entity.cluckshroom.CluckshroomVariant;
import com.ambient_expanded.common.entity.deer.DeerEntity;
import com.ambient_expanded.common.entity.egg.CluckshroomThrownEgg;
import com.ambient_expanded.common.entity.hummingbird.HummingBirdEntity;
import com.ambient_expanded.common.entity.hummingbird.HummingBirdVariant;
import com.ambient_expanded.common.entity.redpanda.RedPandaEntity;
import com.ambient_expanded.common.entity.vulture.VultureEntity;
import com.ambient_expanded.registry.BlockRegistry;
import com.ambient_expanded.registry.ItemRegistry;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.vehicle.ChestRaft;
import net.minecraft.world.entity.vehicle.Raft;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class EntityRegistry {
    public static final DeferredRegister<EntityType<?>> ENTITY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"ambient_expanded");
    public static final DeferredRegister<EntityDataSerializer<?>> SERIALIZER_DEFERRED_REGISTER = DeferredRegister.create((Registry)NeoForgeRegistries.ENTITY_DATA_SERIALIZERS, (String)"ambient_expanded");
    public static final Supplier<EntityType<HummingBirdEntity>> HUMMING_BIRD = ENTITY.register("hummingbird", () -> EntityType.Builder.of(HummingBirdEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.4f, 0.4f).eyeHeight(0.3f).clientTrackingRange(8).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ambient_expanded", (String)"hummingbird"))));
    public static final Supplier<EntityType<BearEntity>> BEAR = ENTITY.register("bear", () -> EntityType.Builder.of(BearEntity::new, (MobCategory)MobCategory.CREATURE).sized(1.4f, 1.4f).clientTrackingRange(10).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ambient_expanded", (String)"bear"))));
    public static final Supplier<EntityType<CluckshroomEntity>> CLUCKSHROOM = ENTITY.register("cluckshroom", () -> EntityType.Builder.of(CluckshroomEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.4f, 0.7f).eyeHeight(0.644f).passengerAttachments(new Vec3[]{new Vec3(0.0, 0.7, -0.1)}).clientTrackingRange(10).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ambient_expanded", (String)"cluckshroom"))));
    public static final Supplier<EntityType<CluckshroomThrownEgg>> CLUCKSHROOM_EGG = ENTITY.register("cluckshroom_egg", () -> EntityType.Builder.of(CluckshroomThrownEgg::new, (MobCategory)MobCategory.MISC).noLootTable().sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(10).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ambient_expanded", (String)"cluckshroom_egg"))));
    public static final Supplier<EntityType<RedPandaEntity>> RED_PANDA = ENTITY.register("red_panda", () -> EntityType.Builder.of(RedPandaEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 0.7f).eyeHeight(0.4f).passengerAttachments(new Vec3[]{new Vec3(0.0, 0.6375, -0.25)}).clientTrackingRange(8).immuneTo(new Block[]{Blocks.SWEET_BERRY_BUSH}).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ambient_expanded", (String)"red_panda"))));
    public static final Supplier<EntityType<Raft>> GREEN_BAMBOO_RAFT = ENTITY.register("green_bamboo_raft", () -> EntityType.Builder.of(EntityRegistry.raftFactory(() -> ItemRegistry.GREEN_BAMBOO_RAFT.get()), (MobCategory)MobCategory.MISC).noLootTable().sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ambient_expanded", (String)"green_bamboo_raft"))));
    public static final Supplier<EntityType<ChestRaft>> GREEN_BAMBOO_CHEST_RAFT = ENTITY.register("green_bamboo_chest_raft", () -> EntityType.Builder.of(EntityRegistry.chestRaftFactory(() -> ItemRegistry.GREEN_BAMBOO_CHEST_RAFT.get()), (MobCategory)MobCategory.MISC).noLootTable().sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ambient_expanded", (String)"green_bamboo_chest_raft"))));
    public static final Supplier<EntityType<DeerEntity>> DEER = ENTITY.register("deer", () -> EntityType.Builder.of(DeerEntity::new, (MobCategory)MobCategory.CREATURE).sized(1.2f, 1.6f).eyeHeight(1.4f).clientTrackingRange(10).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ambient_expanded", (String)"deer"))));
    public static final Supplier<EntityType<VultureEntity>> VULTURE = ENTITY.register("vulture", () -> EntityType.Builder.of(VultureEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.9f, 0.8f).immuneTo(new Block[]{Blocks.CACTUS, (Block)BlockRegistry.SHORT_CACTUS.get()}).eyeHeight(0.8f).passengerAttachments(new Vec3[]{new Vec3(0.0, -1.6375, 0.0)}).clientTrackingRange(8).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ambient_expanded", (String)"vulture"))));
    public static final Supplier<EntityDataSerializer<Holder<HummingBirdVariant>>> HUMMINGBIRD_VARIANT = SERIALIZER_DEFERRED_REGISTER.register("hummingbird_variant", () -> EntityDataSerializer.forValueType(HummingBirdVariant.STREAM_CODEC));
    public static final Supplier<EntityDataSerializer<Holder<BearVariant>>> BEAR_VARIANT = SERIALIZER_DEFERRED_REGISTER.register("bear_variant", () -> EntityDataSerializer.forValueType(BearVariant.STREAM_CODEC));
    public static final Supplier<EntityDataSerializer<Holder<CluckshroomVariant>>> CLUCKSHROOM_VARIANT = SERIALIZER_DEFERRED_REGISTER.register("cluckshroom_variant", () -> EntityDataSerializer.forValueType(CluckshroomVariant.STREAM_CODEC));

    private static EntityType.EntityFactory<Raft> raftFactory(Supplier<Item> raftItemGetter) {
        return (p_375564_, p_375565_) -> new Raft(p_375564_, p_375565_, raftItemGetter);
    }

    private static EntityType.EntityFactory<ChestRaft> chestRaftFactory(Supplier<Item> raftItemGetter) {
        return (p_375561_, p_375562_) -> new ChestRaft(p_375561_, p_375562_, raftItemGetter);
    }

    @EventBusSubscriber(modid="ambient_expanded")
    public static class EntityPlacements {
        @SubscribeEvent
        public static void Attributes(RegisterSpawnPlacementsEvent e) {
            e.register(HUMMING_BIRD.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
            e.register(BEAR.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
            e.register(CLUCKSHROOM.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CluckshroomEntity::checkMushroomSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
            e.register(RED_PANDA.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, RedPandaEntity::checkFoxSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
            e.register(DEER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
            e.register(VULTURE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, VultureEntity::checkVultureSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        }
    }
}

