/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.common.blocks;

import com.ambient_expanded.registry.BlockRegistry;
import com.ambient_expanded.registry.TagRegistry;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FrostedFlowerBlock
extends VegetationBlock
implements BonemealableBlock {
    public static final MapCodec<FrostedFlowerBlock> CODEC = FrostedFlowerBlock.simpleCodec(FrostedFlowerBlock::new);
    public static BooleanProperty SNOWY = BlockStateProperties.SNOWY;
    private static final VoxelShape SHAPE = Block.column((double)14.0, (double)0.0, (double)12.0);

    public MapCodec<? extends FrostedFlowerBlock> codec() {
        return CODEC;
    }

    public FrostedFlowerBlock(BlockBehaviour.Properties p_401939_) {
        super(p_401939_);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)SNOWY, (Comparable)Boolean.valueOf(false)));
    }

    protected VoxelShape getShape(BlockState p_401923_, BlockGetter p_401936_, BlockPos p_401926_, CollisionContext p_401860_) {
        return SHAPE;
    }

    public void animateTick(BlockState p_401358_, Level p_401092_, BlockPos p_401110_, RandomSource p_401309_) {
        if (p_401358_.is(BlockRegistry.FROSTED_FLOWER) && p_401092_.dimensionType().hasSkyLight() && p_401309_.nextDouble() <= 0.7) {
            double d0 = (double)p_401110_.getX() + p_401309_.nextDouble() * 10.0 - 5.0;
            double d1 = (double)p_401110_.getY() + p_401309_.nextDouble() * 5.0;
            double d2 = (double)p_401110_.getZ() + p_401309_.nextDouble() * 10.0 - 5.0;
            p_401092_.addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SNOWY});
    }

    protected boolean mayPlaceOn(BlockState p_401274_, BlockGetter p_401010_, BlockPos p_401365_) {
        return p_401274_.is(BlockTags.DIRT) || p_401274_.getBlock() instanceof FarmBlock;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos;
        Level level = context.getLevel();
        BlockState stateBelow = level.getBlockState((pos = context.getClickedPos()).below());
        boolean snowlogged = stateBelow.hasProperty((Property)BlockStateProperties.SNOWY) && (Boolean)stateBelow.getValue((Property)BlockStateProperties.SNOWY) != false;
        return (BlockState)this.defaultBlockState().setValue((Property)SNOWY, (Comparable)Boolean.valueOf(snowlogged));
    }

    public boolean isValidBonemealTarget(LevelReader p_401250_, BlockPos p_401361_, BlockState p_401191_) {
        return p_401191_.is(TagRegistry.BONEMEAL_FROST_FLOWERS) && BonemealableBlock.hasSpreadableNeighbourPos((LevelReader)p_401250_, (BlockPos)p_401361_, (BlockState)p_401191_);
    }

    public boolean isBonemealSuccess(Level p_401200_, RandomSource p_401387_, BlockPos p_401374_, BlockState p_401380_) {
        return true;
    }

    public void performBonemeal(ServerLevel p_401091_, RandomSource p_401012_, BlockPos p_401218_, BlockState p_401130_) {
        if (p_401130_.is(BlockRegistry.FROSTED_FLOWER) || p_401130_.is(BlockRegistry.FROSTED_BUSH)) {
            BonemealableBlock.findSpreadableNeighbourPos((Level)p_401091_, (BlockPos)p_401218_, (BlockState)p_401130_).ifPresent(p_401015_ -> p_401091_.setBlockAndUpdate(p_401015_, this.defaultBlockState()));
        }
    }
}

