/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.common.blocks;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TriState;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WallShroomBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<WallShroomBlock> CODEC = WallShroomBlock.simpleCodec(WallShroomBlock::new);
    public static final int MAX_AGE = 2;
    protected static final VoxelShape EAST_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_AABB = Block.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);

    public MapCodec<WallShroomBlock> codec() {
        return CODEC;
    }

    public WallShroomBlock(BlockBehaviour.Properties p_51743_) {
        super(p_51743_);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState blockstate = level.getBlockState(pos.relative((Direction)state.getValue((Property)FACING)));
        TriState soilDecision = blockstate.canSustainPlant((BlockGetter)level, pos.relative((Direction)state.getValue((Property)FACING)), ((Direction)state.getValue((Property)FACING)).getOpposite(), state);
        return !soilDecision.isDefault() ? soilDecision.isTrue() : blockstate.isSolidRender();
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: {
                return SOUTH_AABB;
            }
            case SOUTH: {
                return NORTH_AABB;
            }
            case WEST: {
                return EAST_AABB;
            }
        }
        return WEST_AABB;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = this.defaultBlockState();
        Level levelreader = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        for (Direction direction : context.getNearestLookingDirections()) {
            if (!direction.getAxis().isHorizontal() || !(blockstate = (BlockState)blockstate.setValue((Property)FACING, (Comparable)direction)).canSurvive((LevelReader)levelreader, blockpos)) continue;
            return blockstate;
        }
        return null;
    }

    protected BlockState updateShape(BlockState p_51771_, LevelReader p_374569_, ScheduledTickAccess p_374118_, BlockPos p_51775_, Direction p_51772_, BlockPos p_51776_, BlockState p_51773_, RandomSource p_374448_) {
        return p_51772_ == p_51771_.getValue((Property)FACING) && !p_51771_.canSurvive(p_374569_, p_51775_) ? Blocks.AIR.defaultBlockState() : super.updateShape(p_51771_, p_374569_, p_374118_, p_51775_, p_51772_, p_51776_, p_51773_, p_374448_);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    protected boolean isPathfindable(BlockState p_51762_, PathComputationType p_51765_) {
        return false;
    }
}

