/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.common.entity.hummingbird;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class HummingBirdFollowPlayerGoal
extends Goal {
    private int timeToRecalcPath;
    private final PathfinderMob mob;
    @Nullable
    private Player following;

    public HummingBirdFollowPlayerGoal(PathfinderMob mob) {
        this.mob = mob;
    }

    public boolean canUse() {
        List list = this.mob.level().getEntitiesOfClass(Player.class, this.mob.getBoundingBox().inflate(5.0));
        boolean flag = false;
        for (Player abstractboat : list) {
            LivingEntity entity = abstractboat.getControllingPassenger();
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            if (!(Mth.abs((float)player.xxa) > 0.0f) && !(Mth.abs((float)player.zza) > 0.0f)) continue;
            flag = true;
            break;
        }
        return this.following != null && (Mth.abs((float)this.following.xxa) > 0.0f || Mth.abs((float)this.following.zza) > 0.0f) || flag;
    }

    public boolean isInterruptable() {
        return true;
    }

    public boolean canContinueToUse() {
        return this.following != null && this.following.isPassenger() && (Mth.abs((float)this.following.xxa) > 0.0f || Mth.abs((float)this.following.zza) > 0.0f);
    }

    public void start() {
        for (Player abstractboat : this.mob.level().getEntitiesOfClass(Player.class, this.mob.getBoundingBox().inflate(5.0))) {
            Player player;
            LivingEntity var4 = abstractboat.getControllingPassenger();
            if (!(var4 instanceof Player)) continue;
            this.following = player = (Player)var4;
            break;
        }
        this.timeToRecalcPath = 0;
    }

    public void stop() {
        this.following = null;
    }

    public void tick() {
        float f = 0.015f;
        this.mob.moveRelative(f, new Vec3((double)this.mob.xxa, (double)this.mob.yya, (double)this.mob.zza));
        this.mob.move(MoverType.SELF, this.mob.getDeltaMovement());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.adjustedTickDelay(10);
            assert (this.following != null);
            if (this.mob.distanceTo((Entity)this.following) > 6.0f) {
                BlockPos blockpos = this.following.blockPosition().relative(this.following.getDirection().getOpposite());
                blockpos = blockpos.offset(0, -1, 0);
                this.mob.getNavigation().moveTo((double)blockpos.getX(), (double)blockpos.getY(), (double)blockpos.getZ(), 1.0);
                if (this.mob.distanceTo((Entity)this.following) < 4.0f) {
                    this.timeToRecalcPath = 0;
                }
            }
        }
    }
}

