/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.common.entity.redpanda;

import com.ambient_expanded.AmbientExpanded;
import com.ambient_expanded.common.entity.redpanda.RedPandaEntity;
import com.ambient_expanded.common.entity.redpanda.RedPandaModel;
import com.ambient_expanded.common.entity.redpanda.RedPandaRenderState;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.AgeableMobRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.HoldingEntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Quaternionfc;

public class RedPandaRenderer
extends AgeableMobRenderer<RedPandaEntity, RedPandaRenderState, RedPandaModel> {
    private static final ResourceLocation RED_PANDA_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"ambient_expanded", (String)"textures/entity/red_panda/red_panda.png");
    private static final ResourceLocation RED_PANDA_TEXTURE_SLEEPING = ResourceLocation.fromNamespaceAndPath((String)"ambient_expanded", (String)"textures/entity/red_panda/red_panda_sleeping.png");

    public RedPandaRenderer(EntityRendererProvider.Context p_174127_) {
        super(p_174127_, (EntityModel)new RedPandaModel(p_174127_.bakeLayer(AmbientExpanded.EntityBits.RED_PANDA)), (EntityModel)new RedPandaModel(p_174127_.bakeLayer(AmbientExpanded.EntityBits.RED_PANDA_BABY)), 0.4f);
    }

    protected void setupRotations(RedPandaRenderState p_363483_, PoseStack p_114731_, float p_114732_, float p_114733_) {
        super.setupRotations((LivingEntityRenderState)p_363483_, p_114731_, p_114732_, p_114733_);
        if (p_363483_.isPouncing || p_363483_.isFaceplanted) {
            p_114731_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-p_363483_.xRot));
        }
    }

    protected void scale(RedPandaRenderState renderState, PoseStack poseStack) {
        if (renderState.isBaby) {
            poseStack.scale(0.6f, 0.6f, 0.6f);
        }
        super.scale((LivingEntityRenderState)renderState, poseStack);
    }

    public ResourceLocation getTextureLocation(RedPandaRenderState p_365240_) {
        return p_365240_.isSleeping ? RED_PANDA_TEXTURE_SLEEPING : RED_PANDA_TEXTURE;
    }

    public RedPandaRenderState createRenderState() {
        return new RedPandaRenderState();
    }

    public void extractRenderState(RedPandaEntity p_364137_, RedPandaRenderState p_365146_, float p_361192_) {
        super.extractRenderState((LivingEntity)p_364137_, (LivingEntityRenderState)p_365146_, p_361192_);
        HoldingEntityRenderState.extractHoldingEntityRenderState((LivingEntity)p_364137_, (HoldingEntityRenderState)p_365146_, (ItemModelResolver)this.itemModelResolver);
        p_365146_.headRollAngle = p_364137_.getHeadRollAngle(p_361192_);
        p_365146_.isCrouching = p_364137_.isCrouching();
        p_365146_.isSleeping = p_364137_.isSleeping();
        p_365146_.sleep.copyFrom(p_364137_.sleep);
        p_365146_.scare.copyFrom(p_364137_.scare);
        p_365146_.scare_start.copyFrom(p_364137_.scare_start);
        p_365146_.scare_stop.copyFrom(p_364137_.scare_stop);
    }
}

