/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.common.entity.vulture;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.FlyNodeEvaluator;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class VultureEntity
extends Animal
implements Enemy,
FlyingAnimal {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.defineId(VultureEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private int underWaterTicks;
    private int attackCooldown = 0;
    private int diveCooldown = 0;
    @javax.annotation.Nullable
    private BlockPos savedHomePos;
    public AnimationState FLY = new AnimationState();
    public AnimationState GROUND = new AnimationState();
    public AnimationState GROUND_WALK = new AnimationState();

    public VultureEntity(EntityType<? extends VultureEntity> type, Level world) {
        super(type, world);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
        this.lookControl = new VultureLookControl((Mob)this);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.WATER, -2.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 0.0f);
        this.setPathfindingMalus(PathType.COCOA, -1.0f);
        this.setPathfindingMalus(PathType.FENCE, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_OTHER, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 18.0).add(Attributes.FLYING_SPEED, 0.6).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.FOLLOW_RANGE, 24.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326308_) {
        super.defineSynchedData(p_326308_);
        p_326308_.define(DATA_FLAGS_ID, (Object)0);
    }

    public static boolean checkVultureSpawnRules(EntityType<? extends Animal> entityType, LevelAccessor level, EntitySpawnReason spawnReason, BlockPos pos, RandomSource rand) {
        boolean flag = Mob.checkMobSpawnRules(entityType, (LevelAccessor)level, (EntitySpawnReason)spawnReason, (BlockPos)pos, (RandomSource)rand);
        return level.getBlockState(pos.below()).is(BlockTags.DRY_VEGETATION_MAY_PLACE_ON) && flag;
    }

    public void addAdditionalSaveData(ValueOutput compound) {
        super.addAdditionalSaveData(compound);
        if (this.savedHomePos != null) {
            compound.store("home_pos", BlockPos.CODEC, (Object)this.savedHomePos);
        }
    }

    public void readAdditionalSaveData(ValueInput compound) {
        super.readAdditionalSaveData(compound);
        this.setSavedHomePos(compound.read("home_pos", BlockPos.CODEC).orElse(this.blockPosition()));
    }

    @javax.annotation.Nullable
    public BlockPos getSavedHomePos() {
        return this.savedHomePos;
    }

    public void setSavedHomePos(@javax.annotation.Nullable BlockPos pos) {
        this.savedHomePos = pos;
    }

    public boolean hasSavedHomePos() {
        return this.savedHomePos != null;
    }

    protected PathNavigation createNavigation(Level world) {
        CreakingPathNavigation nav = new CreakingPathNavigation((Mob)this, world);
        nav.setCanFloat(true);
        nav.setCanOpenDoors(false);
        nav.setRequiredPathLength(48.0f);
        return nav;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.goalSelector.addGoal(1, (Goal)new PerchGoal(this, 20, 5));
        this.goalSelector.addGoal(3, (Goal)new VultureWanderGoalImpl(this));
        this.goalSelector.addGoal(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new TemptGoal((PathfinderMob)this, 1.25, item -> item.is(Items.APPLE), false));
        this.goalSelector.addGoal(6, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.goalSelector.addGoal(7, (Goal)new FloatGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, 10, true, true, (m, P) -> !(m instanceof Creeper)));
    }

    public void tick() {
        super.tick();
        this.FLY.animateWhen(!this.onGround(), this.tickCount);
        this.GROUND.animateWhen(this.onGround() && !this.walkAnimation.isMoving(), this.tickCount);
        this.GROUND_WALK.animateWhen(!this.onGround() && this.walkAnimation.isMoving(), this.tickCount);
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.diveCooldown > 0) {
            --this.diveCooldown;
        }
        if (this.isInWater()) {
            ++this.underWaterTicks;
            if (this.underWaterTicks > 60) {
                this.hurt(this.damageSources().drown(), 1.0f);
            } else {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.005, 0.0));
            }
        } else {
            this.underWaterTicks = 0;
        }
        if (!this.level().isClientSide && this.random.nextInt(600) == 0) {
            this.playSound(SoundEvents.PARROT_AMBIENT, 0.6f, 0.9f + this.random.nextFloat() * 0.2f);
        }
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide && this.isAlive() && this.tickCount % 10 == 0) {
            this.heal(1.0f);
        }
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(this.getEyeHeight() * 0.6f), (double)(this.getBbWidth() * 0.2f));
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(Items.APPLE);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.isFood(stack)) {
            if (!this.level().isClientSide) {
                if (this.getSavedHomePos() != this.blockPosition()) {
                    this.setSavedHomePos(this.blockPosition());
                }
                this.usePlayerItem(player, hand, stack);
                if (this.getHealth() < this.getMaxHealth()) {
                    this.heal(4.0f);
                }
                this.playSound(SoundEvents.PARROT_EAT, 0.8f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.PARROT_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource cause) {
        return SoundEvents.PARROT_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.PARROT_DEATH;
    }

    protected float getSoundVolume() {
        return 0.6f;
    }

    public float getVoicePitch() {
        return 1.0f;
    }

    @javax.annotation.Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, EntitySpawnReason reason, @javax.annotation.Nullable SpawnGroupData data) {
        this.setSavedHomePos(this.blockPosition());
        return super.finalizeSpawn(world, difficulty, reason, data);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    static class VultureLookControl
    extends LookControl {
        VultureLookControl(Mob mob) {
            super(mob);
        }

        public void tick() {
            if (((VultureEntity)this.mob).getTarget() != null) {
                super.tick();
            }
        }
    }

    class CreakingPathNavigation
    extends FlyingPathNavigation {
        CreakingPathNavigation(Mob mob, Level level) {
            super(mob, level);
        }

        protected PathFinder createPathFinder(int maxNodes) {
            HomeNodeEvaluator evaluator = new HomeNodeEvaluator();
            evaluator.setCanPassDoors(true);
            this.nodeEvaluator = evaluator;
            return new PathFinder(this.nodeEvaluator, maxNodes);
        }
    }

    static class PerchGoal
    extends Goal {
        private final VultureEntity vulture;
        private int perchTicks;
        private final int minPerch;
        private final int maxPerch;

        public PerchGoal(VultureEntity vulture, int minTicks, int maxTicks) {
            this.vulture = vulture;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.minPerch = minTicks;
            this.maxPerch = maxTicks;
        }

        public boolean canUse() {
            if (!this.vulture.navigation.isDone()) {
                return false;
            }
            if (this.vulture.getTarget() != null) {
                return false;
            }
            return this.vulture.random.nextInt(200) == 0;
        }

        public void start() {
            BlockPos pos = this.vulture.blockPosition();
            BlockPos best = null;
            int range = 6;
            for (int dx = -range; dx <= range; ++dx) {
                for (int dz = -range; dz <= range; ++dz) {
                    for (int dy = 1; dy <= 4; ++dy) {
                        BlockPos tryPos = pos.offset(dx, dy, dz);
                        BlockState bs = this.vulture.level().getBlockState(tryPos.below());
                        if (!this.vulture.level().getBlockState(tryPos).isAir() || !bs.isFaceSturdy((BlockGetter)this.vulture.level(), tryPos.below(), Direction.UP)) continue;
                        best = tryPos;
                        break;
                    }
                    if (best != null) break;
                }
                if (best != null) break;
            }
            if (best == null) {
                Vec3 hover = HoverRandomPos.getPos((PathfinderMob)this.vulture, (int)8, (int)7, (double)this.vulture.getViewVector((float)0.0f).x, (double)this.vulture.getViewVector((float)0.0f).z, (float)0.5235988f, (int)3, (int)1);
                if (hover != null) {
                    this.vulture.getNavigation().moveTo(this.vulture.getNavigation().createPath(BlockPos.containing((Position)hover), 1), 1.0);
                }
            } else {
                this.vulture.getNavigation().moveTo(this.vulture.getNavigation().createPath(best, 1), 1.0);
            }
            int min = this.minPerch;
            int max = this.maxPerch;
            if (max < min) {
                int tmp = min;
                min = max;
                max = tmp;
            }
            this.perchTicks = max == min ? min : min + this.vulture.getRandom().nextInt(max - min + 1);
        }

        public boolean canContinueToUse() {
            return this.perchTicks > 0 && this.vulture.navigation.isInProgress();
        }

        public void tick() {
            if (this.perchTicks > 0) {
                --this.perchTicks;
            }
            if (this.vulture.onGround()) {
                this.vulture.lookControl.setLookAt(this.vulture.getX(), this.vulture.getY(), this.vulture.getZ());
            }
        }
    }

    static class VultureWanderGoalImpl
    extends Goal {
        private final VultureEntity mob;

        VultureWanderGoalImpl(VultureEntity mob) {
            this.mob = mob;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return this.mob.navigation.isDone() && this.mob.random.nextInt(10) == 0 && this.mob.getTarget() == null;
        }

        public void start() {
            Vec3 preferred = this.mob.hasSavedHomePos() ? Vec3.atCenterOf((Vec3i)this.mob.getSavedHomePos()) : this.mob.position();
            Vec3 dir = this.mob.getViewVector(0.0f);
            Vec3 goal = HoverRandomPos.getPos((PathfinderMob)this.mob, (int)8, (int)7, (double)dir.x, (double)dir.z, (float)1.0471976f, (int)3, (int)1);
            if (goal == null) {
                goal = AirAndWaterRandomPos.getPos((PathfinderMob)this.mob, (int)8, (int)4, (int)-2, (double)dir.x, (double)dir.z, (double)1.0471975803375244);
            }
            if (goal != null) {
                this.mob.getNavigation().moveTo(this.mob.getNavigation().createPath(BlockPos.containing((Position)goal), 1), 1.0);
            }
        }
    }

    class HomeNodeEvaluator
    extends FlyNodeEvaluator {
        private static final int MAX_DISTANCE_TO_HOME_SQ = 512;

        HomeNodeEvaluator() {
        }

        public PathType getPathType(PathfindingContext context, int x, int y, int z) {
            BlockPos home = VultureEntity.this.getSavedHomePos();
            if (home == null) {
                return super.getPathType(context, x, y, z);
            }
            double dist = home.distSqr(new Vec3i(x, y, z));
            if (dist > 512.0 && dist >= home.distSqr((Vec3i)context.mobPosition())) {
                return PathType.BLOCKED;
            }
            return super.getPathType(context, x, y, z);
        }
    }
}

