/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.common.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class WindBlowingParticles
extends TextureSheetParticle {
    private final Fluid type;
    protected boolean isGlowing;

    public WindBlowingParticles(ClientLevel level, double x, double y, double z, Fluid type) {
        super(level, x, y, z);
        this.setSize(0.01f, 0.01f);
        this.gravity = 0.06f;
        this.type = type;
    }

    protected Fluid getType() {
        return this.type;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public int getLightColor(float partialTick) {
        return this.isGlowing ? 240 : super.getLightColor(partialTick);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.preMoveUpdate();
        if (!this.removed) {
            this.yd -= (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            this.postMoveUpdate();
            if (!this.removed) {
                BlockPos blockpos;
                FluidState fluidstate;
                this.xd *= (double)0.98f;
                this.yd *= (double)0.98f;
                this.zd *= (double)0.98f;
                if (this.type != Fluids.EMPTY && (fluidstate = this.level.getFluidState(blockpos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z))).getType() == this.type && this.y < (double)((float)blockpos.getY() + fluidstate.getHeight((BlockGetter)this.level, blockpos))) {
                    this.remove();
                }
            }
        }
    }

    protected void preMoveUpdate() {
        if (this.lifetime-- <= 0) {
            this.remove();
        }
    }

    protected void postMoveUpdate() {
    }

    public static TextureSheetParticle createSporeBlossomFallParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        int i = (int)(64.0f / Mth.randomBetween((RandomSource)level.getRandom(), (float)0.1f, (float)0.9f));
        FallingParticle dripparticle = new FallingParticle(level, x, y, z, Fluids.EMPTY, i);
        dripparticle.gravity = -0.005f;
        return dripparticle;
    }

    static class FallingParticle
    extends WindBlowingParticles {
        public FallingParticle(ClientLevel p_106132_, double p_106133_, double p_106134_, double p_106135_, Fluid p_106136_) {
            this(p_106132_, p_106133_, p_106134_, p_106135_, p_106136_, (int)(64.0 / (Math.random() * 0.8 + 0.2)));
        }

        public FallingParticle(ClientLevel level, double x, double y, double z, Fluid type, int lifetime) {
            super(level, x, y, z, type);
            this.lifetime = lifetime;
        }

        @Override
        protected void postMoveUpdate() {
            if (this.onGround) {
                this.remove();
            }
        }
    }
}

