/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.common.worldgen;

import com.ambient_expanded.common.blocks.WallShroomBlock;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class TreeMushroomDecorator
extends TreeDecorator {
    public static final MapCodec<TreeMushroomDecorator> CODEC = RecordCodecBuilder.mapCodec(p_382778_ -> p_382778_.group((App)BlockStateProvider.CODEC.fieldOf("to_place").forGetter(p_161168_ -> p_161168_.toPlace), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(p_382777_ -> Float.valueOf(p_382777_.probability))).apply((Applicative)p_382778_, TreeMushroomDecorator::new));
    private final float probability;
    private final BlockStateProvider toPlace;

    public TreeMushroomDecorator(BlockStateProvider toPlace, float probability) {
        this.probability = probability;
        this.toPlace = toPlace;
    }

    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.COCOA;
    }

    public void place(TreeDecorator.Context p_226028_) {
        ObjectArrayList list;
        RandomSource randomsource = p_226028_.random();
        if (!(randomsource.nextFloat() >= this.probability) && !(list = p_226028_.logs()).isEmpty()) {
            int i = ((BlockPos)list.getFirst()).getY();
            list.stream().filter(p_69980_ -> p_69980_.getY() - i <= 2).forEach(p_226026_ -> {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    Direction direction1;
                    BlockPos blockpos;
                    if (!(randomsource.nextFloat() <= 0.25f) || !p_226028_.isAir(blockpos = p_226026_.offset((direction1 = direction.getOpposite()).getStepX(), 0, direction1.getStepZ()))) continue;
                    p_226028_.setBlock(blockpos, (BlockState)this.toPlace.getState(randomsource, blockpos).setValue((Property)WallShroomBlock.FACING, (Comparable)direction));
                }
            });
        }
    }
}

