/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.registry;

import com.ambient_expanded.common.blocks.ButterflyBushBlock;
import com.ambient_expanded.common.blocks.DeadLeavesBlock;
import com.ambient_expanded.common.blocks.DryFlowerBlock;
import com.ambient_expanded.common.blocks.FrostedFlowerBlock;
import com.ambient_expanded.common.blocks.HollowedLogBlock;
import com.ambient_expanded.common.blocks.MossCoveringBlock;
import com.ambient_expanded.common.blocks.MyceliumBushBlock;
import com.ambient_expanded.common.blocks.RafflesiaBlock;
import com.ambient_expanded.common.blocks.SegmentedMushroomsBlock;
import com.ambient_expanded.common.blocks.ShortCactusBlock;
import com.ambient_expanded.common.blocks.TallDandelionBlock;
import com.ambient_expanded.common.blocks.WallShroomBlock;
import com.ambient_expanded.registry.ItemRegistry;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerBedBlock;
import net.minecraft.world.level.block.LeafLitterBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class BlockRegistry {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"ambient_expanded");
    public static final WoodType GREEN_BAMBOO = WoodType.register((WoodType)new WoodType("green_bamboo", BlockSetType.BAMBOO, SoundType.BAMBOO_WOOD, SoundType.BAMBOO_WOOD_HANGING_SIGN, SoundEvents.BAMBOO_WOOD_FENCE_GATE_CLOSE, SoundEvents.BAMBOO_WOOD_FENCE_GATE_OPEN));
    public static final DeferredBlock<Block> BUTTERFLY_BUSH = BlockRegistry.register("butterfly_bush", () -> new ButterflyBushBlock(BlockBehaviour.Properties.of().setId(BlockRegistry.ID("butterfly_bush")).mapColor(MapColor.PLANT).noCollission().sound(SoundType.PINK_PETALS).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> FALLEN_LEAVES = BlockRegistry.register("fallen_leaves", () -> new LeafLitterBlock(BlockBehaviour.Properties.of().replaceable().setId(BlockRegistry.ID("fallen_leaves")).mapColor(MapColor.PLANT).noCollission().sound(SoundType.PINK_PETALS).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> TALL_DANDELION = BlockRegistry.register("tall_dandelion", () -> new TallDandelionBlock(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).setId(BlockRegistry.ID("tall_dandelion")).noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).ignitedByLava().pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> HOLLOWED_OAK_LOG = BlockRegistry.register("hollowed_oak_log", () -> new HollowedLogBlock(BlockRegistry.logProperties(MapColor.WOOD, MapColor.PODZOL, SoundType.WOOD).noOcclusion().setId(BlockRegistry.ID("hollowed_oak_log"))));
    public static final DeferredBlock<Block> HOLLOWED_BIRCH_LOG = BlockRegistry.register("hollowed_birch_log", () -> new HollowedLogBlock(BlockRegistry.logProperties(MapColor.WOOD, MapColor.PODZOL, SoundType.WOOD).setId(BlockRegistry.ID("hollowed_birch_log"))));
    public static final DeferredBlock<Block> HOLLOWED_SPRUCE_LOG = BlockRegistry.register("hollowed_spruce_log", () -> new HollowedLogBlock(BlockRegistry.logProperties(MapColor.WOOD, MapColor.PODZOL, SoundType.WOOD).noOcclusion().setId(BlockRegistry.ID("hollowed_spruce_log"))));
    public static final DeferredBlock<Block> HOLLOWED_JUNGLE_LOG = BlockRegistry.register("hollowed_jungle_log", () -> new HollowedLogBlock(BlockRegistry.logProperties(MapColor.WOOD, MapColor.PODZOL, SoundType.WOOD).noOcclusion().setId(BlockRegistry.ID("hollowed_jungle_log"))));
    public static final DeferredBlock<Block> HOLLOWED_ACACIA_LOG = BlockRegistry.register("hollowed_acacia_log", () -> new HollowedLogBlock(BlockRegistry.logProperties(MapColor.WOOD, MapColor.PODZOL, SoundType.WOOD).noOcclusion().setId(BlockRegistry.ID("hollowed_acacia_log"))));
    public static final DeferredBlock<Block> HOLLOWED_DARK_OAK_LOG = BlockRegistry.register("hollowed_dark_oak_log", () -> new HollowedLogBlock(BlockRegistry.logProperties(MapColor.WOOD, MapColor.PODZOL, SoundType.WOOD).noOcclusion().setId(BlockRegistry.ID("hollowed_dark_oak_log"))));
    public static final DeferredBlock<Block> HOLLOWED_PALE_OAK_LOG = BlockRegistry.register("hollowed_pale_oak_log", () -> new HollowedLogBlock(BlockRegistry.logProperties(MapColor.WOOD, MapColor.PODZOL, SoundType.WOOD).noOcclusion().setId(BlockRegistry.ID("hollowed_pale_oak_log"))));
    public static final DeferredBlock<Block> HOLLOWED_MANGROVE_LOG = BlockRegistry.register("hollowed_mangrove_log", () -> new HollowedLogBlock(BlockRegistry.logProperties(MapColor.WOOD, MapColor.PODZOL, SoundType.WOOD).noOcclusion().setId(BlockRegistry.ID("hollowed_mangrove_log"))));
    public static final DeferredBlock<Block> HOLLOWED_CHERRY_LOG = BlockRegistry.register("hollowed_cherry_log", () -> new HollowedLogBlock(BlockRegistry.logProperties(MapColor.WOOD, MapColor.PODZOL, SoundType.WOOD).noOcclusion().setId(BlockRegistry.ID("hollowed_cherry_log"))));
    public static final DeferredBlock<Block> STRIPPED_HOLLOWED_OAK_LOG = BlockRegistry.register("stripped_hollowed_oak_log", () -> new HollowedLogBlock(BlockRegistry.logProperties(MapColor.WOOD, MapColor.PODZOL, SoundType.WOOD).noOcclusion().setId(BlockRegistry.ID("stripped_hollowed_oak_log"))));
    public static final DeferredBlock<Block> STRIPPED_HOLLOWED_BIRCH_LOG = BlockRegistry.register("stripped_hollowed_birch_log", () -> new HollowedLogBlock(BlockRegistry.logProperties(MapColor.WOOD, MapColor.PODZOL, SoundType.WOOD).setId(BlockRegistry.ID("stripped_hollowed_birch_log"))));
    public static final DeferredBlock<Block> STRIPPED_HOLLOWED_SPRUCE_LOG = BlockRegistry.register("stripped_hollowed_spruce_log", () -> new HollowedLogBlock(BlockRegistry.logProperties(MapColor.WOOD, MapColor.PODZOL, SoundType.WOOD).noOcclusion().setId(BlockRegistry.ID("stripped_hollowed_spruce_log"))));
    public static final DeferredBlock<Block> STRIPPED_HOLLOWED_JUNGLE_LOG = BlockRegistry.register("stripped_hollowed_jungle_log", () -> new HollowedLogBlock(BlockRegistry.logProperties(MapColor.WOOD, MapColor.PODZOL, SoundType.WOOD).noOcclusion().setId(BlockRegistry.ID("stripped_hollowed_jungle_log"))));
    public static final DeferredBlock<Block> STRIPPED_HOLLOWED_ACACIA_LOG = BlockRegistry.register("stripped_hollowed_acacia_log", () -> new HollowedLogBlock(BlockRegistry.logProperties(MapColor.WOOD, MapColor.PODZOL, SoundType.WOOD).noOcclusion().setId(BlockRegistry.ID("stripped_hollowed_acacia_log"))));
    public static final DeferredBlock<Block> STRIPPED_HOLLOWED_DARK_OAK_LOG = BlockRegistry.register("stripped_hollowed_dark_oak_log", () -> new HollowedLogBlock(BlockRegistry.logProperties(MapColor.WOOD, MapColor.PODZOL, SoundType.WOOD).noOcclusion().setId(BlockRegistry.ID("stripped_hollowed_dark_oak_log"))));
    public static final DeferredBlock<Block> STRIPPED_HOLLOWED_PALE_OAK_LOG = BlockRegistry.register("stripped_hollowed_pale_oak_log", () -> new HollowedLogBlock(BlockRegistry.logProperties(MapColor.WOOD, MapColor.PODZOL, SoundType.WOOD).noOcclusion().setId(BlockRegistry.ID("stripped_hollowed_pale_oak_log"))));
    public static final DeferredBlock<Block> STRIPPED_HOLLOWED_MANGROVE_LOG = BlockRegistry.register("stripped_hollowed_mangrove_log", () -> new HollowedLogBlock(BlockRegistry.logProperties(MapColor.WOOD, MapColor.PODZOL, SoundType.WOOD).noOcclusion().setId(BlockRegistry.ID("stripped_hollowed_mangrove_log"))));
    public static final DeferredBlock<Block> STRIPPED_HOLLOWED_CHERRY_LOG = BlockRegistry.register("stripped_hollowed_cherry_log", () -> new HollowedLogBlock(BlockRegistry.logProperties(MapColor.WOOD, MapColor.PODZOL, SoundType.WOOD).noOcclusion().setId(BlockRegistry.ID("stripped_hollowed_cherry_log"))));
    public static final DeferredBlock<Block> MOSS_COVERING = BlockRegistry.register("moss_covering", () -> new MossCoveringBlock(BlockBehaviour.Properties.of().setId(BlockRegistry.ID("moss_covering")).mapColor(MapColor.PLANT).noCollission().sound(SoundType.PINK_PETALS).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> BROWN_MUSHROOMS = BlockRegistry.register("brown_mushroom_shelves", () -> new WallShroomBlock(BlockBehaviour.Properties.of().setId(BlockRegistry.ID("brown_mushroom_shelves")).forceSolidOff().strength(0.4f).sound(SoundType.WOOD).noOcclusion().pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> RED_MUSHROOMS = BlockRegistry.register("red_mushroom_shelves", () -> new WallShroomBlock(BlockBehaviour.Properties.of().setId(BlockRegistry.ID("red_mushroom_shelves")).forceSolidOff().strength(0.4f).sound(SoundType.WOOD).noOcclusion().pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> CLOVERS = BlockRegistry.register("clover", () -> new FlowerBedBlock(BlockBehaviour.Properties.of().setId(BlockRegistry.ID("clover")).replaceable().mapColor(MapColor.PLANT).noCollission().sound(SoundType.PINK_PETALS).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> DEAD_LEAVES = BlockRegistry.register("dead_leaves", () -> new DeadLeavesBlock(BlockRegistry.leavesProperties(SoundType.GRASS).setId(BlockRegistry.ID("dead_leaves"))));
    public static final DeferredBlock<Block> MUSHROOMS = BlockRegistry.register("mushrooms", () -> new SegmentedMushroomsBlock(BlockBehaviour.Properties.of().setId(BlockRegistry.ID("mushrooms")).replaceable().mapColor(MapColor.PLANT).noCollission().sound(SoundType.PINK_PETALS).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> TALL_MYCELIUM_GRASS = BlockRegistry.register("tall_mycelium_grass", () -> new BushBlock(BlockBehaviour.Properties.of().setId(BlockRegistry.ID("tall_mycelium_grass")).replaceable().mapColor(MapColor.PLANT).noCollission().sound(SoundType.GRASS).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> SHORT_MYCELIUM_GRASS = BlockRegistry.register("short_mycelium_grass", () -> new BushBlock(BlockBehaviour.Properties.of().setId(BlockRegistry.ID("short_mycelium_grass")).replaceable().mapColor(MapColor.PLANT).noCollission().sound(SoundType.GRASS).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> MYCELIUM_BUSH = BlockRegistry.register("mycelium_bush", () -> new MyceliumBushBlock(BlockBehaviour.Properties.of().setId(BlockRegistry.ID("mycelium_bush")).mapColor(MapColor.PLANT).replaceable().noCollission().sound(SoundType.GRASS).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> TALL_RED_MUSHROOMS = BlockRegistry.register("tall_red_mushrooms", () -> new TallFlowerBlock(BlockBehaviour.Properties.of().setId(BlockRegistry.ID("tall_red_mushrooms")).mapColor(MapColor.PLANT).noCollission().sound(SoundType.GRASS).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> TALL_BROWN_MUSHROOMS = BlockRegistry.register("tall_brown_mushrooms", () -> new TallFlowerBlock(BlockBehaviour.Properties.of().setId(BlockRegistry.ID("tall_brown_mushrooms")).mapColor(MapColor.PLANT).noCollission().sound(SoundType.GRASS).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> RASSLESIA = BlockRegistry.register("rafflesia", () -> new RafflesiaBlock(BlockBehaviour.Properties.of().setId(BlockRegistry.ID("rafflesia")).mapColor(MapColor.PLANT).noCollission().sound(SoundType.SPORE_BLOSSOM).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> FROSTED_FLOWER = BlockRegistry.register("frosted_flower", () -> new FrostedFlowerBlock(BlockBehaviour.Properties.of().setId(BlockRegistry.ID("frosted_flower")).mapColor(MapColor.PLANT).noCollission().sound(SoundType.GRASS).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> FROSTED_BUSH = BlockRegistry.register("frosted_bush", () -> new FrostedFlowerBlock(BlockBehaviour.Properties.of().setId(BlockRegistry.ID("frosted_bush")).mapColor(MapColor.PLANT).replaceable().noCollission().sound(SoundType.GRASS).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> FROSTED_GRASS = BlockRegistry.register("frosted_grass", () -> new FrostedFlowerBlock(BlockBehaviour.Properties.of().setId(BlockRegistry.ID("frosted_grass")).replaceable().mapColor(MapColor.PLANT).noCollission().sound(SoundType.GRASS).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> CROCUS = BlockRegistry.register("crocus", () -> new FrostedFlowerBlock(BlockBehaviour.Properties.of().setId(BlockRegistry.ID("crocus")).mapColor(MapColor.PLANT).noCollission().sound(SoundType.GRASS).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> SARCODES = BlockRegistry.register("sarcodes", () -> new FrostedFlowerBlock(BlockBehaviour.Properties.of().setId(BlockRegistry.ID("sarcodes")).mapColor(MapColor.PLANT).noCollission().sound(SoundType.GRASS).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> DRY_FLOWER = BlockRegistry.register("dry_flower", () -> new DryFlowerBlock(BlockBehaviour.Properties.of().setId(BlockRegistry.ID("dry_flower")).mapColor(MapColor.PLANT).noCollission().sound(SoundType.GRASS).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> SHORT_CACTUS = BlockRegistry.register("short_cactus", () -> new ShortCactusBlock(BlockBehaviour.Properties.of().setId(BlockRegistry.ID("short_cactus")).offsetType(BlockBehaviour.OffsetType.XYZ).mapColor(MapColor.PLANT).noCollission().sound(SoundType.CACTUS_FLOWER).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> ICE_BRICKS = BlockRegistry.register("ice_bricks", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.ICE).instrument(NoteBlockInstrument.CHIME).friction(0.98f).strength(0.5f).sound(SoundType.GLASS).setId(BlockRegistry.ID("ice_bricks"))));
    public static final DeferredBlock<Block> ICE_BRICK_STAIRS = BlockRegistry.register("ice_brick_stairs", () -> new StairBlock(((Block)ICE_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)((BlockBehaviour)ICE_BRICKS.get())).setId(BlockRegistry.ID("ice_brick_stairs"))));
    public static final DeferredBlock<Block> ICE_BRICK_SLAB = BlockRegistry.register("ice_brick_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)((BlockBehaviour)ICE_BRICKS.get())).setId(BlockRegistry.ID("ice_brick_slab"))));
    public static final DeferredBlock<Block> ICE_BRICK_WALL = BlockRegistry.register("ice_brick_wall", () -> new WallBlock(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)((BlockBehaviour)ICE_BRICKS.get())).forceSolidOn().setId(BlockRegistry.ID("ice_brick_wall"))));
    public static final DeferredBlock<Block> SNOW_BRICKS = BlockRegistry.register("snow_bricks", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.SNOW).requiresCorrectToolForDrops().strength(0.2f).sound(SoundType.SNOW).setId(BlockRegistry.ID("snow_bricks"))));
    public static final DeferredBlock<Block> SNOW_BRICK_STAIRS = BlockRegistry.register("snow_brick_stairs", () -> new StairBlock(((Block)SNOW_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)((BlockBehaviour)SNOW_BRICKS.get())).setId(BlockRegistry.ID("snow_brick_stairs"))));
    public static final DeferredBlock<Block> SNOW_BRICK_SLAB = BlockRegistry.register("snow_brick_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)((BlockBehaviour)SNOW_BRICKS.get())).setId(BlockRegistry.ID("snow_brick_slab"))));
    public static final DeferredBlock<Block> SNOW_BRICK_WALL = BlockRegistry.register("snow_brick_wall", () -> new WallBlock(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)((BlockBehaviour)SNOW_BRICKS.get())).forceSolidOn().setId(BlockRegistry.ID("snow_brick_wall"))));
    public static final DeferredBlock<Block> SANDSTONE_BRICKS = BlockRegistry.register("sandstone_bricks", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.SAND).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.8f).setId(BlockRegistry.ID("sandstone_bricks"))));
    public static final DeferredBlock<Block> SANDSTONE_BRICK_STAIRS = BlockRegistry.register("sandstone_brick_stairs", () -> new StairBlock(((Block)SANDSTONE_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)((BlockBehaviour)SANDSTONE_BRICKS.get())).setId(BlockRegistry.ID("sandstone_brick_stairs"))));
    public static final DeferredBlock<Block> SANDSTONE_BRICK_SLAB = BlockRegistry.register("sandstone_brick_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)((BlockBehaviour)SANDSTONE_BRICKS.get())).setId(BlockRegistry.ID("sandstone_brick_slab"))));
    public static final DeferredBlock<Block> SANDSTONE_BRICK_WALL = BlockRegistry.register("sandstone_brick_wall", () -> new WallBlock(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)((BlockBehaviour)SANDSTONE_BRICKS.get())).forceSolidOn().setId(BlockRegistry.ID("sandstone_brick_wall"))));
    public static final DeferredBlock<Block> CRACKED_SANDSTONE_BRICKS = BlockRegistry.register("cracked_sandstone_bricks", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.SAND).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.8f).setId(BlockRegistry.ID("cracked_sandstone_bricks"))));
    public static final DeferredBlock<Block> SANDSTONE_TILES = BlockRegistry.register("sandstone_tiles", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.SAND).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.8f).setId(BlockRegistry.ID("sandstone_tiles"))));
    public static final DeferredBlock<Block> SANDSTONE_TILES_STAIRS = BlockRegistry.register("sandstone_tile_stairs", () -> new StairBlock(((Block)SANDSTONE_TILES.get()).defaultBlockState(), BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)((BlockBehaviour)SANDSTONE_TILES.get())).setId(BlockRegistry.ID("sandstone_tile_stairs"))));
    public static final DeferredBlock<Block> SANDSTONE_TILES_SLAB = BlockRegistry.register("sandstone_tile_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)((BlockBehaviour)SANDSTONE_TILES.get())).setId(BlockRegistry.ID("sandstone_tile_slab"))));
    public static final DeferredBlock<Block> SANDSTONE_TILES_WALL = BlockRegistry.register("sandstone_tile_wall", () -> new WallBlock(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)((BlockBehaviour)SANDSTONE_TILES.get())).forceSolidOn().setId(BlockRegistry.ID("sandstone_tile_wall"))));
    public static final DeferredBlock<Block> RED_SANDSTONE_BRICKS = BlockRegistry.register("red_sandstone_bricks", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.8f).setId(BlockRegistry.ID("red_sandstone_bricks"))));
    public static final DeferredBlock<Block> RED_SANDSTONE_BRICK_STAIRS = BlockRegistry.register("red_sandstone_brick_stairs", () -> new StairBlock(((Block)RED_SANDSTONE_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)((BlockBehaviour)RED_SANDSTONE_BRICKS.get())).setId(BlockRegistry.ID("red_sandstone_brick_stairs"))));
    public static final DeferredBlock<Block> RED_SANDSTONE_BRICK_SLAB = BlockRegistry.register("red_sandstone_brick_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)((BlockBehaviour)RED_SANDSTONE_BRICKS.get())).setId(BlockRegistry.ID("red_sandstone_brick_slab"))));
    public static final DeferredBlock<Block> RED_SANDSTONE_BRICK_WALL = BlockRegistry.register("red_sandstone_brick_wall", () -> new WallBlock(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)((BlockBehaviour)RED_SANDSTONE_BRICKS.get())).forceSolidOn().setId(BlockRegistry.ID("red_sandstone_brick_wall"))));
    public static final DeferredBlock<Block> CRACKED_RED_SANDSTONE_BRICKS = BlockRegistry.register("cracked_red_sandstone_bricks", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.SAND).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.8f).setId(BlockRegistry.ID("cracked_red_sandstone_bricks"))));
    public static final DeferredBlock<Block> RED_SANDSTONE_TILES = BlockRegistry.register("red_sandstone_tiles", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.8f).setId(BlockRegistry.ID("red_sandstone_tiles"))));
    public static final DeferredBlock<Block> RED_SANDSTONE_TILES_STAIRS = BlockRegistry.register("red_sandstone_tile_stairs", () -> new StairBlock(((Block)RED_SANDSTONE_TILES.get()).defaultBlockState(), BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)((BlockBehaviour)RED_SANDSTONE_TILES.get())).setId(BlockRegistry.ID("red_sandstone_tile_stairs"))));
    public static final DeferredBlock<Block> RED_SANDSTONE_TILES_SLAB = BlockRegistry.register("red_sandstone_tile_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)((BlockBehaviour)RED_SANDSTONE_TILES.get())).setId(BlockRegistry.ID("red_sandstone_tile_slab"))));
    public static final DeferredBlock<Block> RED_SANDSTONE_TILES_WALL = BlockRegistry.register("red_sandstone_tile_wall", () -> new WallBlock(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)((BlockBehaviour)RED_SANDSTONE_TILES.get())).forceSolidOn().setId(BlockRegistry.ID("red_sandstone_tile_wall"))));
    public static final DeferredBlock<Block> GREEN_BAMBOO_PLANKS = BlockRegistry.register("green_bamboo_planks", () -> new Block(BlockBehaviour.Properties.of().setId(BlockRegistry.ID("green_bamboo_planks")).mapColor(MapColor.COLOR_GREEN).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.BAMBOO_WOOD).ignitedByLava()));
    public static final DeferredBlock<Block> GREEN_BAMBOO_MOSAIC = BlockRegistry.register("green_bamboo_mosaic", () -> new Block(BlockBehaviour.Properties.of().setId(BlockRegistry.ID("green_bamboo_mosaic")).mapColor(MapColor.COLOR_GREEN).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.BAMBOO_WOOD).ignitedByLava()));
    public static final DeferredBlock<Block> GREEN_BAMBOO_SIGN = BlockRegistry.registerWithoutItem("green_bamboo_sign", () -> new StandingSignBlock(GREEN_BAMBOO, BlockBehaviour.Properties.of().setId(BlockRegistry.ID("green_bamboo_sign")).mapColor(((Block)GREEN_BAMBOO_PLANKS.get()).defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f).ignitedByLava()));
    public static final DeferredBlock<Block> GREEN_BAMBOO_WALL_SIGN = BlockRegistry.registerWithoutItem("green_bamboo_wall_sign", () -> new WallSignBlock(GREEN_BAMBOO, BlockRegistry.wallVariant((Block)GREEN_BAMBOO_SIGN.get(), true).setId(BlockRegistry.ID("green_bamboo_wall_sign")).mapColor(((Block)GREEN_BAMBOO_PLANKS.get()).defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f).ignitedByLava()));
    public static final DeferredBlock<Block> GREEN_BAMBOO_HANGING_SIGN = BlockRegistry.registerWithoutItem("green_bamboo_hanging_sign", () -> new CeilingHangingSignBlock(GREEN_BAMBOO, BlockBehaviour.Properties.of().setId(BlockRegistry.ID("green_bamboo_hanging_sign")).mapColor(MapColor.COLOR_GREEN).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f).ignitedByLava()));
    public static final DeferredBlock<Block> GREEN_BAMBOO_WALL_HANGING_SIGN = BlockRegistry.registerWithoutItem("green_bamboo_wall_hanging_sign", () -> new WallHangingSignBlock(GREEN_BAMBOO, BlockRegistry.wallVariant((Block)GREEN_BAMBOO_HANGING_SIGN.get(), true).setId(BlockRegistry.ID("green_bamboo_mosaic")).mapColor(MapColor.COLOR_GREEN).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f).ignitedByLava()));
    public static final DeferredBlock<Block> GREEN_BAMBOO_PRESSURE_PLATE = BlockRegistry.register("green_bamboo_pressure_plate", () -> new PressurePlateBlock(BlockSetType.BAMBOO, BlockBehaviour.Properties.of().mapColor(((Block)GREEN_BAMBOO_PLANKS.get()).defaultMapColor()).setId(BlockRegistry.ID("green_bamboo_pressure_plate")).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(0.5f).ignitedByLava().pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> GREEN_BAMBOO_TRAPDOOR = BlockRegistry.register("green_bamboo_trapdoor", () -> new TrapDoorBlock(BlockSetType.BAMBOO, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GREEN).setId(BlockRegistry.ID("green_bamboo_trapdoor")).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn(Blocks::never).ignitedByLava()));
    public static final DeferredBlock<Block> GREEN_BAMBOO_BUTTON = BlockRegistry.register("green_bamboo_button", () -> new ButtonBlock(BlockSetType.BAMBOO, 30, BlockBehaviour.Properties.of().noCollission().setId(BlockRegistry.ID("green_bamboo_button")).strength(0.5f).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> GREEN_BAMBOO_STAIRS = BlockRegistry.register("green_bamboo_stairs", () -> new StairBlock(((Block)GREEN_BAMBOO_PLANKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)((BlockBehaviour)GREEN_BAMBOO_PLANKS.get())).setId(BlockRegistry.ID("green_bamboo_stairs"))));
    public static final DeferredBlock<Block> GREEN_BAMBOO_MOSAIC_STAIRS = BlockRegistry.register("green_bamboo_mosaic_stairs", () -> new StairBlock(((Block)GREEN_BAMBOO_MOSAIC.get()).defaultBlockState(), BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)((BlockBehaviour)GREEN_BAMBOO_PLANKS.get())).setId(BlockRegistry.ID("green_bamboo_mosaic_stairs"))));
    public static final DeferredBlock<Block> GREEN_BAMBOO_SLAB = BlockRegistry.register("green_bamboo_slab", () -> new SlabBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GREEN).instrument(NoteBlockInstrument.BASS).setId(BlockRegistry.ID("green_bamboo_slab")).strength(2.0f, 3.0f).sound(SoundType.BAMBOO_WOOD).ignitedByLava()));
    public static final DeferredBlock<Block> GREEN_BAMBOO_MOSAIC_SLAB = BlockRegistry.register("green_bamboo_mosaic_slab", () -> new SlabBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GREEN).setId(BlockRegistry.ID("green_bamboo_mosaic_slab")).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.BAMBOO_WOOD).ignitedByLava()));
    public static final DeferredBlock<Block> GREEN_BAMBOO_FENCE_GATE = BlockRegistry.register("green_bamboo_fence_gate", () -> new FenceGateBlock(WoodType.BAMBOO, BlockBehaviour.Properties.of().mapColor(((Block)GREEN_BAMBOO_PLANKS.get()).defaultMapColor()).setId(BlockRegistry.ID("green_bamboo_fence_gate")).forceSolidOn().instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava()));
    public static final DeferredBlock<Block> GREEN_BAMBOO_FENCE = BlockRegistry.register("green_bamboo_fence", () -> new FenceBlock(BlockBehaviour.Properties.of().mapColor(((Block)GREEN_BAMBOO_PLANKS.get()).defaultMapColor()).setId(BlockRegistry.ID("green_bamboo_fence")).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.BAMBOO_WOOD).ignitedByLava()));
    public static final DeferredBlock<Block> GREEN_BAMBOO_DOOR = BlockRegistry.register("green_bamboo_door", () -> new DoorBlock(BlockSetType.BAMBOO, BlockBehaviour.Properties.of().mapColor(((Block)GREEN_BAMBOO_PLANKS.get()).defaultMapColor()).setId(BlockRegistry.ID("green_bamboo_door")).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().ignitedByLava().pushReaction(PushReaction.DESTROY)));

    public static DeferredBlock<Block> register(String s, Supplier<? extends Block> block) {
        DeferredBlock P = BLOCKS.register(s, block);
        ItemRegistry.ITEMS.register(s, () -> new BlockItem((Block)P.get(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ambient_expanded", (String)s)))));
        return P;
    }

    public static DeferredBlock<Block> registerWithoutItem(String s, Supplier<? extends Block> block) {
        DeferredBlock P = BLOCKS.register(s, block);
        return P;
    }

    public static ResourceKey<Block> ID(String s) {
        return ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ambient_expanded", (String)s));
    }

    private static BlockBehaviour.Properties leavesProperties(SoundType sound) {
        return BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).strength(0.2f).randomTicks().sound(sound).noOcclusion().isValidSpawn(Blocks::ocelotOrParrot).isSuffocating(BlockRegistry::never).isViewBlocking(BlockRegistry::never).ignitedByLava().pushReaction(PushReaction.DESTROY).isRedstoneConductor(BlockRegistry::never);
    }

    private static BlockBehaviour.Properties logProperties(MapColor sideColor, MapColor topColor, SoundType sound) {
        return BlockBehaviour.Properties.of().mapColor(p_152624_ -> p_152624_.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y ? sideColor : topColor).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(sound).ignitedByLava();
    }

    private static BlockBehaviour.Properties wallVariant(Block baseBlock, boolean overrideDescription) {
        BlockBehaviour.Properties blockbehaviour$properties = baseBlock.properties();
        BlockBehaviour.Properties blockbehaviour$properties1 = BlockBehaviour.Properties.of().overrideLootTable(baseBlock.getLootTable());
        if (overrideDescription) {
            blockbehaviour$properties1 = blockbehaviour$properties1.overrideDescription(baseBlock.getDescriptionId());
        }
        return blockbehaviour$properties1;
    }

    public static Boolean never(BlockState state, BlockGetter level, BlockPos pos, EntityType<?> entity) {
        return false;
    }

    private static boolean never(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return false;
    }
}

