/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.common.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public class DryFlowerBlock
extends BushBlock
implements BonemealableBlock {
    public DryFlowerBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public void animateTick(BlockState state, Level p_401092_, BlockPos p_401110_, RandomSource p_401309_) {
        if (p_401092_.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, p_401110_) <= p_401110_.getY()) {
            double d0 = (double)p_401110_.getX() + p_401309_.nextDouble() * 10.0 - 5.0;
            double d1 = (double)p_401110_.getY() + p_401309_.nextDouble() * 5.0;
            double d2 = (double)p_401110_.getZ() + p_401309_.nextDouble() * 10.0 - 5.0;
            p_401092_.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, p_401092_.getBlockState(p_401110_.below())), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    protected boolean mayPlaceOn(BlockState p_401820_, BlockGetter p_401945_, BlockPos p_401852_) {
        return p_401820_.is(BlockTags.DRY_VEGETATION_MAY_PLACE_ON);
    }

    public boolean isValidBonemealTarget(LevelReader p_401250_, BlockPos p_401361_, BlockState p_401191_) {
        return BonemealableBlock.hasSpreadableNeighbourPos((LevelReader)p_401250_, (BlockPos)p_401361_, (BlockState)p_401191_);
    }

    public boolean isBonemealSuccess(Level p_401200_, RandomSource p_401387_, BlockPos p_401374_, BlockState p_401380_) {
        return true;
    }

    public void performBonemeal(ServerLevel p_401091_, RandomSource p_401012_, BlockPos p_401218_, BlockState p_401130_) {
        BonemealableBlock.findSpreadableNeighbourPos((Level)p_401091_, (BlockPos)p_401218_, (BlockState)p_401130_).ifPresent(p_401015_ -> p_401091_.setBlockAndUpdate(p_401015_, this.defaultBlockState()));
    }
}

