/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.common.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TriState;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class TallMushroomsBlock
extends DoublePlantBlock
implements BonemealableBlock {
    public static final MapCodec<TallMushroomsBlock> CODEC = TallMushroomsBlock.simpleCodec(TallMushroomsBlock::new);

    public MapCodec<TallMushroomsBlock> codec() {
        return CODEC;
    }

    public TallMushroomsBlock(BlockBehaviour.Properties p_57296_) {
        super(p_57296_);
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.isSolidRender();
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState blockstate1 = level.getBlockState(blockpos);
        TriState soilDecision = blockstate1.canSustainPlant((BlockGetter)level, blockpos, Direction.UP, state);
        if (state.getValue((Property)HALF) != DoubleBlockHalf.UPPER) {
            return blockstate1.is(BlockTags.MUSHROOM_GROW_BLOCK) ? true : (soilDecision.isDefault() ? level.getRawBrightness(pos, 0) < 13 && this.mayPlaceOn(blockstate1, (BlockGetter)level, blockpos) : soilDecision.isTrue());
        }
        BlockState blockstate = level.getBlockState(pos.below());
        if (state.getBlock() != this) {
            return blockstate.is(BlockTags.MUSHROOM_GROW_BLOCK) ? true : (soilDecision.isDefault() ? level.getRawBrightness(pos, 0) < 13 && this.mayPlaceOn(blockstate, (BlockGetter)level, blockpos) : soilDecision.isTrue()) && super.canSurvive(state, level, pos);
        }
        return blockstate.is(BlockTags.MUSHROOM_GROW_BLOCK) ? true : (soilDecision.isDefault() ? level.getRawBrightness(pos, 0) < 13 && this.mayPlaceOn(blockstate, (BlockGetter)level, blockpos) : soilDecision.isTrue()) && blockstate.is((Block)this) && blockstate.getValue((Property)HALF) == DoubleBlockHalf.LOWER;
    }

    public boolean isValidBonemealTarget(LevelReader p_256234_, BlockPos p_57304_, BlockState p_57305_) {
        return true;
    }

    public boolean isBonemealSuccess(Level p_222573_, RandomSource p_222574_, BlockPos p_222575_, BlockState p_222576_) {
        return true;
    }

    public void performBonemeal(ServerLevel p_222568_, RandomSource p_222569_, BlockPos p_222570_, BlockState p_222571_) {
        TallMushroomsBlock.popResource((Level)p_222568_, (BlockPos)p_222570_, (ItemStack)new ItemStack((ItemLike)this));
    }
}

