/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.common.blocks;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SegmentableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TintedLeafLitterBlock
extends BushBlock
implements SegmentableBlock {
    public static final int MIN_FLOWERS = 1;
    public static final int MAX_FLOWERS = 4;
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final IntegerProperty AMOUNT = BlockStateProperties.FLOWER_AMOUNT;
    private final Function<BlockState, VoxelShape> shapes;

    public TintedLeafLitterBlock(BlockBehaviour.Properties p_273335_) {
        super(p_273335_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)AMOUNT, (Comparable)Integer.valueOf(1)));
        this.shapes = this.makeShapes();
    }

    private Function<BlockState, VoxelShape> makeShapes() {
        return this.getShapeForEachState(this.getShapeCalculator(FACING, this.getSegmentAmountProperty()));
    }

    public BlockState rotate(BlockState p_273485_, Rotation p_273021_) {
        return (BlockState)p_273485_.setValue(FACING, (Comparable)p_273021_.rotate((Direction)p_273485_.getValue(FACING)));
    }

    public BlockState mirror(BlockState p_272961_, Mirror p_273278_) {
        return p_272961_.rotate(p_273278_.getRotation((Direction)p_272961_.getValue(FACING)));
    }

    public boolean canBeReplaced(BlockState p_272922_, BlockPlaceContext p_273534_) {
        return !p_273534_.isSecondaryUseActive() && p_273534_.getItemInHand().is(this.asItem()) && (Integer)p_272922_.getValue((Property)AMOUNT) < 4 ? true : super.canBeReplaced(p_272922_, p_273534_);
    }

    public boolean isValidBonemealTarget(LevelReader p_401250_, BlockPos p_401361_, BlockState p_401191_) {
        return false;
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_273158_) {
        BlockState blockstate = p_273158_.getLevel().getBlockState(p_273158_.getClickedPos());
        return blockstate.is((Block)this) ? (BlockState)blockstate.setValue((Property)AMOUNT, (Comparable)Integer.valueOf(Math.min(4, (Integer)blockstate.getValue((Property)AMOUNT) + 1))) : (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)p_273158_.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_272634_) {
        p_272634_.add(new Property[]{FACING, AMOUNT});
    }
}

