/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.common.entity.deer;

import com.ambient_expanded.common.entity.deer.DeerAnimations;
import com.ambient_expanded.common.entity.deer.DeerRenderState;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class DeerModel
extends EntityModel<DeerRenderState> {
    private final ModelPart body;
    private final ModelPart body2;
    private final ModelPart head;
    private final ModelPart head_neck;
    private final ModelPart head_neck2;
    private final ModelPart head_no_neck;
    private final ModelPart leg0;
    private final ModelPart leg0_2;
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final ModelPart leg2_2;
    private final ModelPart leg3;
    private final KeyframeAnimation walkAnimation;
    private final KeyframeAnimation eatAnimation;
    private final KeyframeAnimation sprintAnimation;

    public DeerModel(ModelPart root) {
        super(root);
        this.body = root.getChild("body");
        this.body2 = this.body.getChild("body2");
        this.head = this.body2.getChild("head");
        this.head_neck = this.head.getChild("head_neck");
        this.head_neck2 = this.head_neck.getChild("head_neck2");
        this.head_no_neck = this.head_neck2.getChild("head_no_neck");
        this.leg0 = root.getChild("leg0");
        this.leg0_2 = this.leg0.getChild("leg0_2");
        this.leg1 = root.getChild("leg1");
        this.leg2 = root.getChild("leg2");
        this.leg2_2 = this.leg2.getChild("leg2_2");
        this.leg3 = root.getChild("leg3");
        this.walkAnimation = DeerAnimations.WALK.bake(root);
        this.eatAnimation = DeerAnimations.EAT.bake(root);
        this.sprintAnimation = DeerAnimations.SPRINT.bake(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)14.0f, (float)-1.0f));
        PartDefinition body2 = body.addOrReplaceChild("body2", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -7.0f, -9.0f, 8.0f, 8.0f, 18.0f, new CubeDeformation(0.005f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body2.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-5.5f, (float)-5.5f));
        PartDefinition head_neck = head.addOrReplaceChild("head_neck", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition head_neck2 = head_neck.addOrReplaceChild("head_neck2", CubeListBuilder.create().texOffs(28, 26).addBox(-3.0f, -7.5f, -2.5f, 6.0f, 9.0f, 5.0f, new CubeDeformation(-0.01f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head_no_neck = head_neck2.addOrReplaceChild("head_no_neck", CubeListBuilder.create().texOffs(0, 26).addBox(-3.0f, -5.0f, -7.0f, 6.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(48, 40).addBox(-1.5f, -2.0f, -11.0f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(48, 47).addBox(3.0f, -6.5f, -2.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(48, 47).mirror().addBox(-4.0f, -6.5f, -2.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)2.5f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition left_antler_r1 = head_no_neck.addOrReplaceChild("left_antler_r1", CubeListBuilder.create().texOffs(2, 2).addBox(-4.5f, -10.0f, 0.0f, 8.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)-4.5f, (float)-1.0f, (float)0.3927f, (float)-0.3927f, (float)-0.3927f));
        PartDefinition right_antler_r1 = head_no_neck.addOrReplaceChild("right_antler_r1", CubeListBuilder.create().texOffs(2, 2).mirror().addBox(-3.5f, -10.0f, 0.0f, 8.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)2.0f, (float)-4.5f, (float)-1.0f, (float)0.3927f, (float)0.3927f, (float)0.3927f));
        PartDefinition leg0 = partdefinition.addOrReplaceChild("leg0", CubeListBuilder.create(), PartPose.offset((float)-2.5f, (float)16.0f, (float)-8.5f));
        PartDefinition leg0_2 = leg0.addOrReplaceChild("leg0_2", CubeListBuilder.create().texOffs(24, 40).addBox(-1.5f, -8.0f, -1.5f, 3.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)7.0f, (float)0.0f));
        PartDefinition leg1 = partdefinition.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(24, 40).mirror().addBox(-1.5f, -1.0f, -1.5f, 3.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)2.5f, (float)16.0f, (float)6.5f));
        PartDefinition leg2 = partdefinition.addOrReplaceChild("leg2", CubeListBuilder.create(), PartPose.offset((float)2.5f, (float)16.0f, (float)-8.5f));
        PartDefinition leg2_2 = leg2.addOrReplaceChild("leg2_2", CubeListBuilder.create().texOffs(24, 40).mirror().addBox(-1.5f, -8.0f, -1.5f, 3.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)7.0f, (float)0.0f));
        PartDefinition leg3 = partdefinition.addOrReplaceChild("leg3", CubeListBuilder.create().texOffs(24, 40).mirror().addBox(-1.5f, -1.0f, -1.5f, 3.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-2.5f, (float)16.0f, (float)6.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(DeerRenderState entity) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.head.xRot = entity.xRot * ((float)Math.PI / 180);
        this.head.yRot = entity.yRot * ((float)Math.PI / 180);
        if (entity.Sprinting) {
            this.sprintAnimation.applyWalk(entity.walkAnimationPos, entity.walkAnimationSpeed, entity.isBaby ? 4.0f : 6.0f, entity.isBaby ? 20.0f : 25.0f);
        } else {
            this.walkAnimation.applyWalk(entity.walkAnimationPos, entity.walkAnimationSpeed, entity.isBaby ? 4.0f : 6.0f, entity.isBaby ? 20.0f : 25.0f);
        }
        this.eatAnimation.apply(entity.eat, entity.ageInTicks);
    }
}

