/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.common.entity.hummingbird;

import com.ambient_expanded.AmbientExpanded;
import com.ambient_expanded.common.entity.hummingbird.HummingBirdFollowPlayerGoal;
import com.ambient_expanded.common.entity.hummingbird.HummingBirdVariant;
import com.ambient_expanded.registry.EntityRegistry;
import com.ambient_expanded.registry.SoundRegistry;
import com.ambient_expanded.registry.VariantRegistry;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.variant.PriorityProvider;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HummingBirdEntity
extends Animal
implements FlyingAnimal {
    private int flowerHoverTicks = 0;
    private BlockState flowerHovered = null;
    public AnimationState FLY = new AnimationState();
    private int cooldownTicks = 0;
    private static final EntityDataAccessor<Holder<HummingBirdVariant>> DATA_VARIANT_ID = SynchedEntityData.defineId(HummingBirdEntity.class, EntityRegistry.HUMMINGBIRD_VARIANT.get());

    public HummingBirdEntity(EntityType<? extends HummingBirdEntity> type, Level level) {
        super(type, level);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
    }

    public void tick() {
        this.FLY.animateWhen(this.isAlive(), this.tickCount);
        if (this.cooldownTicks != 0) {
            --this.cooldownTicks;
        }
        super.tick();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, p_401437_ -> p_401437_.is(ItemTags.BEE_FOOD), false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new HoverOverFlowerGoal());
        this.goalSelector.addGoal(5, (Goal)new HummingBirdFollowPlayerGoal((PathfinderMob)this));
        this.goalSelector.addGoal(8, (Goal)new FollowNearbyPlayerGoal(this, (Mob)this, 1.0, 2.0, 16.0, 300));
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    public boolean isFlying() {
        return this.onGround();
    }

    protected PathNavigation createNavigation(Level level) {
        FlyingPathNavigation nav = new FlyingPathNavigation((Mob)this, level);
        nav.setCanOpenDoors(false);
        nav.setCanFloat(true);
        return nav;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.FLYING_SPEED, (double)0.6f).add(Attributes.MOVEMENT_SPEED, (double)0.3f);
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader level) {
        return level.getBlockState(pos).is(BlockTags.FLOWERS) ? 10.0f : 0.0f;
    }

    public ResourceLocation getTexture() {
        HummingBirdVariant variant = (HummingBirdVariant)this.getVariant().value();
        return variant.assetInfo().texture().texturePath();
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326248_) {
        super.defineSynchedData(p_326248_);
        RegistryAccess registryaccess = this.registryAccess();
        Registry registry = registryaccess.lookupOrThrow(VariantRegistry.HUMMINGBIRD_VARIANT_REGISTRY_KEY);
        EntityDataAccessor<Holder<HummingBirdVariant>> var10001 = DATA_VARIANT_ID;
        Optional var10002 = registry.get(ResourceKey.create(VariantRegistry.HUMMINGBIRD_VARIANT_REGISTRY_KEY, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ambient_expanded", (String)"green")));
        Objects.requireNonNull(registry);
        p_326248_.define(var10001, (Object)((Holder)var10002.or(() -> ((Registry)registry).getAny()).orElseThrow()));
    }

    public Holder<HummingBirdVariant> getVariant() {
        return (Holder)this.entityData.get(DATA_VARIANT_ID);
    }

    public void setVariant(Holder<HummingBirdVariant> p_332777_) {
        this.entityData.set(DATA_VARIANT_ID, p_332777_);
    }

    public void addAdditionalSaveData(ValueOutput compound) {
        super.addAdditionalSaveData(compound);
        this.getVariant().unwrapKey().ifPresent(p_344339_ -> compound.putString("variant", p_344339_.location().toString()));
    }

    public void readAdditionalSaveData(ValueInput compound) {
        super.readAdditionalSaveData(compound);
        VariantUtils.readVariant((ValueInput)compound, VariantRegistry.HUMMINGBIRD_VARIANT_REGISTRY_KEY).ifPresent(this::setVariant);
    }

    @javax.annotation.Nullable
    public <T> T get(DataComponentType<? extends T> p_401949_) {
        return (T)(p_401949_ == VariantRegistry.HUMMINGBIRD_VARIANT.get() ? HummingBirdEntity.castComponentValue(p_401949_, (Object)new EitherHolder(this.getVariant())) : super.get(p_401949_));
    }

    protected void applyImplicitComponents(DataComponentGetter p_401816_) {
        this.applyImplicitComponentIfPresent(p_401816_, VariantRegistry.HUMMINGBIRD_VARIANT.get());
        super.applyImplicitComponents(p_401816_);
    }

    protected <T> boolean applyImplicitComponent(DataComponentType<T> p_401879_, T p_401856_) {
        if (p_401879_ == VariantRegistry.HUMMINGBIRD_VARIANT.get()) {
            Optional optional = ((EitherHolder)HummingBirdEntity.castComponentValue(VariantRegistry.HUMMINGBIRD_VARIANT.get(), p_401856_)).unwrap((HolderLookup.Provider)this.registryAccess());
            if (optional.isPresent()) {
                this.setVariant((Holder<HummingBirdVariant>)((Holder)optional.get()));
                return true;
            }
            return false;
        }
        return super.applyImplicitComponent(p_401879_, p_401856_);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(ItemTags.BEE_FOOD);
    }

    protected void playStepSound(BlockPos pos, BlockState block) {
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.HUMMINGBIRD_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)SoundRegistry.HUMMINGBIRD_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.HUMMINGBIRD_DEATH.get();
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    public float getVoicePitch() {
        return -2.3f;
    }

    protected void onFlap() {
        this.playSound((SoundEvent)SoundRegistry.HUMMINGBIRD_FLY.get(), 0.15f, 1.0f);
    }

    @javax.annotation.Nullable
    public HummingBirdEntity getBreedOffspring(ServerLevel p_148760_, AgeableMob p_148761_) {
        return (HummingBirdEntity)EntityRegistry.HUMMING_BIRD.get().create((Level)p_148760_, EntitySpawnReason.BREEDING);
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(0.5f * this.getEyeHeight()), (double)(this.getBbWidth() * 0.2f));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_146746_, DifficultyInstance p_146747_, EntitySpawnReason p_363316_, @Nullable SpawnGroupData p_146749_) {
        HummingBirdEntity.selectVariantToSpawn(this.random, this.registryAccess(), SpawnContext.create((ServerLevelAccessor)p_146746_, (BlockPos)this.blockPosition())).ifPresent(this::setVariant);
        return super.finalizeSpawn(p_146746_, p_146747_, p_363316_, p_146749_);
    }

    public static Optional<Holder.Reference<HummingBirdVariant>> selectVariantToSpawn(RandomSource p_401128_, RegistryAccess p_401407_, SpawnContext p_401187_) {
        return PriorityProvider.pick((Stream)p_401407_.lookupOrThrow(VariantRegistry.HUMMINGBIRD_VARIANT_REGISTRY_KEY).listElements(), Holder::value, (RandomSource)p_401128_, (Object)p_401187_);
    }

    class HoverOverFlowerGoal
    extends Goal {
        private BlockPos targetFlower;

        public HoverOverFlowerGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            Optional<BlockPos> flowerPos = BlockPos.betweenClosedStream((BlockPos)HummingBirdEntity.this.blockPosition().offset(-5, -3, -5), (BlockPos)HummingBirdEntity.this.blockPosition().offset(5, 3, 5)).map(BlockPos::immutable).filter(pos -> HummingBirdEntity.this.level().getBlockState(pos).is(BlockTags.FLOWERS)).findAny();
            HummingBirdEntity.this.flowerHovered = flowerPos.map(pos -> HummingBirdEntity.this.level().getBlockState(pos)).orElse(null);
            this.targetFlower = flowerPos.orElse(null);
            return this.targetFlower != null && HummingBirdEntity.this.cooldownTicks == 0;
        }

        public boolean canContinueToUse() {
            return this.targetFlower != null && HummingBirdEntity.this.flowerHovered != null;
        }

        public void tick() {
            AmbientExpanded.LOGGER.info(String.valueOf(HummingBirdEntity.this.flowerHoverTicks));
            Vec3 hoverPos = Vec3.atBottomCenterOf((Vec3i)this.targetFlower).add(0.0, 0.2, 0.0);
            HummingBirdEntity.this.getMoveControl().setWantedPosition(hoverPos.x, hoverPos.y, hoverPos.z, (double)0.35f);
            HummingBirdEntity.this.getLookControl().setLookAt(hoverPos.x, hoverPos.y, hoverPos.z);
            if (HummingBirdEntity.this.blockPosition().closerThan((Vec3i)this.targetFlower, 0.5)) {
                ++HummingBirdEntity.this.flowerHoverTicks;
                if (HummingBirdEntity.this.flowerHoverTicks >= 50) {
                    this.tryPlantNearby();
                    this.stop();
                }
            } else {
                HummingBirdEntity.this.flowerHoverTicks = 0;
            }
        }

        private void tryPlantNearby() {
            Level level = HummingBirdEntity.this.level();
            BlockPos pos = this.targetFlower;
            BlockState state = level.getBlockState(pos);
            for (int i = 0; i < 1; ++i) {
                BonemealableBlock.findSpreadableNeighbourPos((Level)level, (BlockPos)pos, (BlockState)state).ifPresent(p_405685_ -> level.setBlockAndUpdate(p_405685_, state));
            }
        }

        public void stop() {
            this.targetFlower = null;
            HummingBirdEntity.this.flowerHovered = null;
            HummingBirdEntity.this.flowerHoverTicks = 0;
            HummingBirdEntity.this.cooldownTicks = 100 + HummingBirdEntity.this.getRandom().nextInt(400);
        }
    }

    class FollowNearbyPlayerGoal
    extends Goal {
        private final Mob mob;
        private Player targetPlayer;
        private int followTime;
        private final double speed;
        private final double minDistance;
        private final double maxDistance;
        private final int chance;

        public FollowNearbyPlayerGoal(HummingBirdEntity this$0, Mob mob, double speed, double minDistance, double maxDistance, int chance) {
            this.mob = mob;
            this.speed = speed;
            this.minDistance = minDistance;
            this.maxDistance = maxDistance;
            this.chance = chance;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (this.mob.getRandom().nextInt(this.chance) != 0) {
                return false;
            }
            List players = this.mob.level().getEntitiesOfClass(Player.class, this.mob.getBoundingBox().inflate(this.maxDistance));
            this.targetPlayer = players.stream().findAny().orElse(null);
            return this.targetPlayer != null;
        }

        public boolean canContinueToUse() {
            return this.targetPlayer != null && this.targetPlayer.isAlive() && this.mob.distanceToSqr((Entity)this.targetPlayer) < this.maxDistance * this.maxDistance && this.followTime > 0;
        }

        public void start() {
            this.followTime = 100 + this.mob.getRandom().nextInt(100);
        }

        public void tick() {
            if (this.targetPlayer == null) {
                return;
            }
            this.mob.getLookControl().setLookAt((Entity)this.targetPlayer, 10.0f, (float)this.mob.getMaxHeadXRot());
            double distance = this.mob.distanceToSqr((Entity)this.targetPlayer);
            if (distance > this.minDistance * this.minDistance) {
                this.mob.getNavigation().moveTo((Entity)this.targetPlayer, this.speed);
            } else {
                this.mob.getNavigation().stop();
            }
            --this.followTime;
        }

        public void stop() {
            this.targetPlayer = null;
            this.mob.getNavigation().stop();
        }
    }
}

