/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.common.entity.hummingbird;

import com.ambient_expanded.common.entity.hummingbird.HummingBirdAnimations;
import com.ambient_expanded.common.entity.hummingbird.HummingBirdRenderState;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HummingBirdModel
extends EntityModel<HummingBirdRenderState> {
    private final ModelPart HummingBird;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart tail_feather;
    private final ModelPart left_wing;
    private final ModelPart right_wing;
    private final ModelPart feet;
    private final KeyframeAnimation flyAnimation;

    public HummingBirdModel(ModelPart root) {
        super(root);
        this.HummingBird = root.getChild("HummingBird");
        this.head = this.HummingBird.getChild("head");
        this.body = this.HummingBird.getChild("body");
        this.tail_feather = this.body.getChild("tail_feather");
        this.left_wing = this.body.getChild("left_wing");
        this.right_wing = this.body.getChild("right_wing");
        this.feet = this.body.getChild("feet");
        this.flyAnimation = HummingBirdAnimations.FLYFORWARD.bake(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition HummingBird = partdefinition.addOrReplaceChild("HummingBird", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = HummingBird.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -3.0f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(-0.01f)).texOffs(0, 22).addBox(-0.5f, -2.0f, -4.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(-0.01f)), PartPose.offset((float)-0.5f, (float)-5.0f, (float)0.5f));
        PartDefinition body = HummingBird.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 6).addBox(-2.5f, 0.0f, -1.25f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)-5.0f, (float)0.25f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition tail_feather = body.addOrReplaceChild("tail_feather", CubeListBuilder.create().texOffs(-4, 17).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)4.0f, (float)1.75f, (float)-0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition left_wing = body.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(0, 9).mirror().addBox(0.0f, -1.0f, -5.0f, 0.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.5f, (float)1.0f, (float)1.5f, (float)0.0f, (float)-2.0944f, (float)0.0f));
        PartDefinition right_wing = body.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(0, 9).addBox(0.0f, -1.0f, -5.0f, 0.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.5f, (float)1.0f, (float)1.5f, (float)0.0f, (float)2.0944f, (float)0.0f));
        PartDefinition feet = body.addOrReplaceChild("feet", CubeListBuilder.create().texOffs(3, 22).addBox(-2.0f, -2.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(2, 24).addBox(-2.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(3, 22).addBox(0.0f, -2.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(2, 24).addBox(0.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)5.0f, (float)-0.25f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(HummingBirdRenderState p_361630_) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.head.xRot = p_361630_.xRot * ((float)Math.PI / 180);
        this.head.yRot = p_361630_.yRot * ((float)Math.PI / 180);
        this.flyAnimation.apply(p_361630_.FLYING, p_361630_.ageInTicks, 200.0f);
    }
}

