/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.common.entity.vulture;

import com.ambient_expanded.common.entity.vulture.VultureAnimations;
import com.ambient_expanded.common.entity.vulture.VultureRenderState;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class VultureModel
extends EntityModel<VultureRenderState> {
    private final ModelPart root;
    private final ModelPart body_default;
    private final ModelPart body;
    private final ModelPart collar_default;
    private final ModelPart neck_default;
    private final ModelPart neck;
    private final ModelPart head_default;
    private final ModelPart head;
    private final ModelPart left_wing_fly;
    private final ModelPart left_wing;
    private final ModelPart right_wing_fly;
    private final ModelPart right_wing;
    private final ModelPart left_leg_fly;
    private final ModelPart left_leg;
    private final ModelPart right_leg_fly;
    private final ModelPart right_leg;
    private final KeyframeAnimation flyAnimation;
    private final KeyframeAnimation groundAnimation;

    public VultureModel(ModelPart root) {
        super(root);
        this.root = root.getChild("root");
        this.body_default = this.root.getChild("body_default");
        this.body = this.body_default.getChild("body");
        this.collar_default = this.body.getChild("collar_default");
        this.neck_default = this.collar_default.getChild("neck_default");
        this.neck = this.neck_default.getChild("neck");
        this.head_default = this.neck.getChild("head_default");
        this.head = this.head_default.getChild("head");
        this.left_wing_fly = this.body.getChild("left_wing_fly");
        this.left_wing = this.left_wing_fly.getChild("left_wing");
        this.right_wing_fly = this.body.getChild("right_wing_fly");
        this.right_wing = this.right_wing_fly.getChild("right_wing");
        this.left_leg_fly = this.root.getChild("left_leg_fly");
        this.left_leg = this.left_leg_fly.getChild("left_leg");
        this.right_leg_fly = this.root.getChild("right_leg_fly");
        this.right_leg = this.right_leg_fly.getChild("right_leg");
        this.flyAnimation = VultureAnimations.FLY.bake(root);
        this.groundAnimation = VultureAnimations.DEFAULT.bake(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)16.5f, (float)2.0f));
        PartDefinition body_default = root.addOrReplaceChild("body_default", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)4.5f));
        PartDefinition body = body_default.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 20).addBox(-3.0f, -2.5f, -7.5f, 6.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(32, 32).addBox(-2.0f, -0.5f, 2.5f, 4.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition collar_default = body.addOrReplaceChild("collar_default", CubeListBuilder.create().texOffs(30, 0).addBox(-4.0f, -4.0f, -2.0f, 8.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-8.5f));
        PartDefinition neck_default = collar_default.addOrReplaceChild("neck_default", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.5f, (float)-2.0f));
        PartDefinition neck = neck_default.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(32, 23).addBox(-1.5f, -1.5f, -5.0f, 3.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(28, 38).addBox(-1.5f, -4.5f, -5.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head_default = neck.addOrReplaceChild("head_default", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-2.5f, (float)-3.5f));
        PartDefinition head = head_default.addOrReplaceChild("head", CubeListBuilder.create().texOffs(32, 12).addBox(-3.0f, -5.0f, -3.0f, 6.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 35).addBox(-2.0f, -4.0f, -7.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_wing_fly = body.addOrReplaceChild("left_wing_fly", CubeListBuilder.create(), PartPose.offset((float)4.5f, (float)-1.5f, (float)-7.0f));
        PartDefinition left_wing = left_wing_fly.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -3.0f, 0.0f, 1.0f, 6.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-1.5f));
        PartDefinition right_wing_fly = body.addOrReplaceChild("right_wing_fly", CubeListBuilder.create(), PartPose.offset((float)-4.5f, (float)-1.5f, (float)-7.0f));
        PartDefinition right_wing = right_wing_fly.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-0.5f, -3.0f, 0.0f, 1.0f, 6.0f, 14.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)-1.5f));
        PartDefinition left_leg_fly = root.addOrReplaceChild("left_leg_fly", CubeListBuilder.create(), PartPose.offset((float)2.5f, (float)3.5f, (float)4.5f));
        PartDefinition left_leg = left_leg_fly.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(16, 35).addBox(-1.5f, -1.0f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(40, 38).addBox(-1.5f, 2.0f, -2.5f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg_fly = root.addOrReplaceChild("right_leg_fly", CubeListBuilder.create(), PartPose.offset((float)-2.5f, (float)3.5f, (float)4.5f));
        PartDefinition right_leg = right_leg_fly.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(16, 35).mirror().addBox(-1.5f, -1.0f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(40, 38).mirror().addBox(-1.5f, 2.0f, -2.5f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(VultureRenderState entity) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animateHeadLookTarget(entity.yRot, entity.xRot);
        this.flyAnimation.apply(entity.FLY, entity.ageInTicks);
        this.groundAnimation.apply(entity.GROUND, entity.ageInTicks);
        this.groundAnimation.apply(entity.GROUND_WALK, entity.ageInTicks);
    }

    private void animateHeadLookTarget(float yaw, float pitch) {
        this.neck.xRot = pitch * ((float)Math.PI / 180);
        this.neck.yRot = yaw * ((float)Math.PI / 180);
    }
}

