/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.common.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MossCoveringBlock
extends Block
implements BonemealableBlock {
    public static final MapCodec<MossCoveringBlock> CODEC = MossCoveringBlock.simpleCodec(MossCoveringBlock::new);
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0);
    public static IntegerProperty AGE = BlockStateProperties.AGE_2;

    public MapCodec<? extends MossCoveringBlock> codec() {
        return CODEC;
    }

    public MossCoveringBlock(BlockBehaviour.Properties p_152915_) {
        super(p_152915_);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    protected VoxelShape getShape(BlockState p_152917_, BlockGetter p_152918_, BlockPos p_152919_, CollisionContext p_152920_) {
        return SHAPE;
    }

    protected BlockState updateShape(BlockState p_152926_, LevelReader p_374550_, ScheduledTickAccess p_374188_, BlockPos p_152930_, Direction p_152927_, BlockPos p_152931_, BlockState p_152928_, RandomSource p_374375_) {
        return !p_152926_.canSurvive(p_374550_, p_152930_) ? Blocks.AIR.defaultBlockState() : super.updateShape(p_152926_, p_374550_, p_374188_, p_152930_, p_152927_, p_152931_, p_152928_, p_374375_);
    }

    protected boolean canSurvive(BlockState p_152922_, LevelReader p_152923_, BlockPos p_152924_) {
        return p_152923_.getBlockState(p_152924_.below()).isFaceSturdy((BlockGetter)p_152923_, p_152924_, Direction.UP);
    }

    public boolean isValidBonemealTarget(LevelReader p_272968_, BlockPos p_273762_, BlockState p_273662_) {
        return (Integer)p_273662_.getValue((Property)AGE) < 2;
    }

    public boolean isBonemealSuccess(Level p_272604_, RandomSource p_273609_, BlockPos p_272988_, BlockState p_273231_) {
        return true;
    }

    public void performBonemeal(ServerLevel p_273476_, RandomSource p_273093_, BlockPos p_272601_, BlockState p_272683_) {
        int i = (Integer)p_272683_.getValue((Property)AGE);
        if (i <= 2) {
            p_273476_.setBlock(p_272601_, (BlockState)p_272683_.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
        }
    }
}

