/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.common.blocks;

import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TriState;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SegmentableBlock;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SegmentedMushroomsBlock
extends VegetationBlock
implements BonemealableBlock,
SegmentableBlock {
    public static final MapCodec<SegmentedMushroomsBlock> CODEC = SegmentedMushroomsBlock.simpleCodec(SegmentedMushroomsBlock::new);
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final IntegerProperty AMOUNT = BlockStateProperties.FLOWER_AMOUNT;
    private final Function<BlockState, VoxelShape> shapes;

    public MapCodec<SegmentedMushroomsBlock> codec() {
        return CODEC;
    }

    public SegmentedMushroomsBlock(BlockBehaviour.Properties p_394040_) {
        super(p_394040_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)AMOUNT, (Comparable)Integer.valueOf(1)));
        this.shapes = this.makeShapes();
    }

    private Function<BlockState, VoxelShape> makeShapes() {
        return this.getShapeForEachState(this.getShapeCalculator(FACING, AMOUNT));
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.isSolidRender();
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState blockstate = level.getBlockState(blockpos);
        TriState soilDecision = blockstate.canSustainPlant((BlockGetter)level, blockpos, Direction.UP, state);
        return blockstate.is(BlockTags.MUSHROOM_GROW_BLOCK) ? true : (soilDecision.isDefault() ? level.getRawBrightness(pos, 0) < 13 && this.mayPlaceOn(blockstate, (BlockGetter)level, blockpos) : soilDecision.isTrue());
    }

    public BlockState rotate(BlockState p_393932_, Rotation p_394491_) {
        return (BlockState)p_393932_.setValue(FACING, (Comparable)p_394491_.rotate((Direction)p_393932_.getValue(FACING)));
    }

    public BlockState mirror(BlockState p_393796_, Mirror p_393802_) {
        return p_393796_.rotate(p_393802_.getRotation((Direction)p_393796_.getValue(FACING)));
    }

    public boolean canBeReplaced(BlockState p_393549_, BlockPlaceContext p_393927_) {
        return this.canBeReplaced(p_393549_, p_393927_, AMOUNT) ? true : super.canBeReplaced(p_393549_, p_393927_);
    }

    public VoxelShape getShape(BlockState p_393803_, BlockGetter p_394026_, BlockPos p_394322_, CollisionContext p_394474_) {
        return this.shapes.apply(p_393803_);
    }

    public double getShapeHeight() {
        return 3.0;
    }

    public IntegerProperty getSegmentAmountProperty() {
        return AMOUNT;
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_393645_) {
        return this.getStateForPlacement(p_393645_, (Block)this, AMOUNT, FACING);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_393753_) {
        p_393753_.add(new Property[]{FACING, AMOUNT});
    }

    public boolean isValidBonemealTarget(LevelReader p_393585_, BlockPos p_393679_, BlockState p_394653_) {
        return true;
    }

    public boolean isBonemealSuccess(Level p_393489_, RandomSource p_394493_, BlockPos p_394603_, BlockState p_393700_) {
        return true;
    }

    public void performBonemeal(ServerLevel p_394140_, RandomSource p_394672_, BlockPos p_393771_, BlockState p_394008_) {
        int i = (Integer)p_394008_.getValue((Property)AMOUNT);
        if (i < 4) {
            p_394140_.setBlock(p_393771_, (BlockState)p_394008_.setValue((Property)AMOUNT, (Comparable)Integer.valueOf(i + 1)), 2);
        } else {
            SegmentedMushroomsBlock.popResource((Level)p_394140_, (BlockPos)p_393771_, (ItemStack)new ItemStack((ItemLike)this));
        }
    }
}

