/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.common.entity.cluckshroom;

import com.ambient_expanded.common.entity.cluckshroom.CluckshroomEntity;
import com.ambient_expanded.common.entity.cluckshroom.CluckshroomModel;
import com.ambient_expanded.common.entity.cluckshroom.CluckshroomMushroomLayer;
import com.ambient_expanded.common.entity.cluckshroom.CluckshroomRenderState;
import com.ambient_expanded.common.entity.cluckshroom.CluckshroomVariant;
import com.ambient_expanded.common.entity.cluckshroom.ColdCluckshroomModel;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.client.model.AdultAndBabyModelPair;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CluckshroomRenderer
extends MobRenderer<CluckshroomEntity, CluckshroomRenderState, CluckshroomModel> {
    private final Map<CluckshroomVariant.ModelType, AdultAndBabyModelPair<CluckshroomModel>> models;

    public CluckshroomRenderer(EntityRendererProvider.Context p_173952_) {
        super(p_173952_, (EntityModel)new CluckshroomModel(p_173952_.bakeLayer(ModelLayers.CHICKEN)), 0.3f);
        this.models = CluckshroomRenderer.bakeModels(p_173952_);
        this.addLayer(new CluckshroomMushroomLayer((RenderLayerParent<CluckshroomRenderState, CluckshroomModel>)this, p_173952_.getBlockRenderDispatcher()));
    }

    private static Map<CluckshroomVariant.ModelType, AdultAndBabyModelPair<CluckshroomModel>> bakeModels(EntityRendererProvider.Context p_401798_) {
        return Maps.newEnumMap(Map.of(CluckshroomVariant.ModelType.NORMAL, new AdultAndBabyModelPair((Model)new CluckshroomModel(p_401798_.bakeLayer(ModelLayers.CHICKEN)), (Model)new CluckshroomModel(p_401798_.bakeLayer(ModelLayers.CHICKEN_BABY))), CluckshroomVariant.ModelType.COLD, new AdultAndBabyModelPair((Model)new ColdCluckshroomModel(p_401798_.bakeLayer(ModelLayers.COLD_CHICKEN)), (Model)new ColdCluckshroomModel(p_401798_.bakeLayer(ModelLayers.COLD_CHICKEN_BABY)))));
    }

    public void render(CluckshroomRenderState p_401826_, PoseStack p_401883_, MultiBufferSource p_401836_, int p_401766_) {
        if (p_401826_.variant != null) {
            this.model = (CluckshroomModel)this.models.get(p_401826_.variant.modelAndTexture().model()).getModel(p_401826_.isBaby);
            super.render((LivingEntityRenderState)p_401826_, p_401883_, p_401836_, p_401766_);
        }
    }

    public ResourceLocation getTextureLocation(CluckshroomRenderState p_364952_) {
        return p_364952_.variant == null ? MissingTextureAtlasSprite.getLocation() : p_364952_.variant.modelAndTexture().asset().texturePath();
    }

    public CluckshroomRenderState createRenderState() {
        return new CluckshroomRenderState();
    }

    public void extractRenderState(CluckshroomEntity p_361981_, CluckshroomRenderState p_365088_, float p_364120_) {
        super.extractRenderState((LivingEntity)p_361981_, (LivingEntityRenderState)p_365088_, p_364120_);
        p_365088_.flap = Mth.lerp((float)p_364120_, (float)p_361981_.oFlap, (float)p_361981_.flap);
        p_365088_.flapSpeed = Mth.lerp((float)p_364120_, (float)p_361981_.oFlapSpeed, (float)p_361981_.flapSpeed);
        p_365088_.variant = (CluckshroomVariant)p_361981_.getVariant().value();
    }
}

