/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.common.entity.egg;

import com.ambient_expanded.common.entity.cluckshroom.CluckshroomEntity;
import com.ambient_expanded.registry.EntityRegistry;
import com.ambient_expanded.registry.ItemRegistry;
import com.ambient_expanded.registry.VariantRegistry;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class CluckshroomThrownEgg
extends ThrowableItemProjectile {
    private static final EntityDimensions ZERO_SIZED_DIMENSIONS = EntityDimensions.fixed((float)0.0f, (float)0.0f);

    public CluckshroomThrownEgg(EntityType<? extends CluckshroomThrownEgg> p_37473_, Level p_37474_) {
        super(p_37473_, p_37474_);
    }

    public CluckshroomThrownEgg(Level level, LivingEntity owner, ItemStack item) {
        super(EntityRegistry.CLUCKSHROOM_EGG.get(), owner, level, item);
    }

    public CluckshroomThrownEgg(Level level, double x, double y, double z, ItemStack item) {
        super(EntityRegistry.CLUCKSHROOM_EGG.get(), x, y, z, level, item);
    }

    public void handleEntityEvent(byte p_37484_) {
        if (p_37484_ == 3) {
            double d0 = 0.08;
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItem()), this.getX(), this.getY(), this.getZ(), ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08);
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        result.getEntity().hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 0.0f);
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide) {
            if (this.random.nextInt(8) == 0) {
                int i = 1;
                if (this.random.nextInt(32) == 0) {
                    i = 4;
                }
                for (int j = 0; j < i; ++j) {
                    CluckshroomEntity chicken = (CluckshroomEntity)EntityRegistry.CLUCKSHROOM.get().create(this.level(), EntitySpawnReason.TRIGGERED);
                    if (chicken == null) continue;
                    chicken.setAge(-24000);
                    chicken.snapTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
                    Optional.ofNullable((EitherHolder)this.getItem().get(VariantRegistry.CLUCKSHROOM_VARIANT.get())).flatMap(p_409407_ -> p_409407_.unwrap((HolderLookup.Provider)this.registryAccess())).ifPresent(chicken::setVariant);
                    if (!chicken.fudgePositionAfterSizeChange(ZERO_SIZED_DIMENSIONS)) break;
                    this.level().addFreshEntity((Entity)chicken);
                }
            }
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    protected Item getDefaultItem() {
        return (Item)ItemRegistry.RED_EGG.get();
    }
}

