/*
 * Decompiled with CFR 0.152.
 */
package com.ambient_expanded.common.entity.redpanda;

import com.ambient_expanded.common.entity.redpanda.RedPandaAnimations;
import com.ambient_expanded.common.entity.redpanda.RedPandaRenderState;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class RedPandaModel
extends EntityModel<RedPandaRenderState> {
    private final ModelPart root;
    private final ModelPart body_stand;
    private final ModelPart body_scare;
    private final ModelPart body;
    private final ModelPart body_sleep;
    private final ModelPart head_stand;
    private final ModelPart head;
    private final ModelPart head_scare;
    private final ModelPart tail;
    private final ModelPart tail_stand;
    private final ModelPart tail_scare;
    private final ModelPart tail_sleep;
    private final ModelPart leg0;
    private final ModelPart leg0_scare;
    private final ModelPart leg1;
    private final ModelPart leg1_scare;
    private final ModelPart leg2;
    private final ModelPart leg3;

    public RedPandaModel(ModelPart root) {
        super(root);
        this.root = root.getChild("root");
        this.body_stand = this.root.getChild("body_stand");
        this.body_scare = this.body_stand.getChild("body_scare");
        this.body = this.body_scare.getChild("body");
        this.body_sleep = this.body.getChild("body_sleep");
        this.head_stand = this.body_sleep.getChild("head_stand");
        this.head = this.head_stand.getChild("head");
        this.head_scare = this.head.getChild("head_scare");
        this.tail = this.body.getChild("tail");
        this.tail_stand = this.tail.getChild("tail_stand");
        this.tail_scare = this.tail_stand.getChild("tail_scare");
        this.tail_sleep = this.tail_scare.getChild("tail_sleep");
        this.leg0 = this.body_scare.getChild("leg0");
        this.leg0_scare = this.leg0.getChild("leg0_scare");
        this.leg1 = this.body_scare.getChild("leg1");
        this.leg1_scare = this.leg1.getChild("leg1_scare");
        this.leg2 = this.root.getChild("leg2");
        this.leg3 = this.root.getChild("leg3");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body_stand = root.addOrReplaceChild("body_stand", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-5.5f, (float)4.5f));
        PartDefinition body_scare = body_stand.addOrReplaceChild("body_scare", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = body_scare.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.5f, (float)-4.5f));
        PartDefinition body_sleep = body.addOrReplaceChild("body_sleep", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -4.0f, -6.0f, 7.0f, 5.0f, 12.0f, new CubeDeformation(0.001f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head_stand = body_sleep.addOrReplaceChild("head_stand", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)2.0f, (float)-12.0f));
        PartDefinition head = head_stand.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-4.0f, (float)6.0f));
        PartDefinition head_scare = head.addOrReplaceChild("head_scare", CubeListBuilder.create().texOffs(32, 17).addBox(-4.0f, -7.0f, -6.0f, 8.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 33).addBox(-2.0f, -2.0f, -7.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(10, 33).addBox(-5.0f, -8.0f, -5.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(10, 33).mirror().addBox(2.0f, -8.0f, -5.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-3.5f, (float)6.0f, (float)-0.48f, (float)0.0f, (float)0.0f));
        PartDefinition tail_stand = tail.addOrReplaceChild("tail_stand", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition tail_scare = tail_stand.addOrReplaceChild("tail_scare", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition tail_sleep = tail_scare.addOrReplaceChild("tail_sleep", CubeListBuilder.create().texOffs(0, 17).addBox(0.0f, -2.0f, 0.0f, 4.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)2.0f, (float)0.0f));
        PartDefinition leg0 = body_scare.addOrReplaceChild("leg0", CubeListBuilder.create(), PartPose.offset((float)2.0f, (float)1.5f, (float)-9.0f));
        PartDefinition leg0_scare = leg0.addOrReplaceChild("leg0_scare", CubeListBuilder.create().texOffs(32, 30).mirror().addBox(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leg1 = body_scare.addOrReplaceChild("leg1", CubeListBuilder.create(), PartPose.offset((float)-2.0f, (float)1.5f, (float)-9.0f));
        PartDefinition leg1_scare = leg1.addOrReplaceChild("leg1_scare", CubeListBuilder.create().texOffs(32, 30).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leg2 = root.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(32, 30).mirror().addBox(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)2.0f, (float)-4.0f, (float)4.5f));
        PartDefinition leg3 = root.addOrReplaceChild("leg3", CubeListBuilder.create().texOffs(32, 30).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)-4.0f, (float)4.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(RedPandaRenderState state) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.head.xRot = state.xRot * ((float)Math.PI / 180);
        this.head.yRot = state.yRot * ((float)Math.PI / 180);
        this.animateWalk(RedPandaAnimations.WALK, state.walkAnimationPos, state.walkAnimationSpeed, 2.0f, 2.5f);
        this.animate(state.scare, RedPandaAnimations.SCARE_LOOP, state.ageInTicks);
        this.animate(state.scare_start, RedPandaAnimations.SCARE_START, state.ageInTicks);
        this.animate(state.scare_stop, RedPandaAnimations.SCARE_STOP, state.ageInTicks);
        this.animate(state.sleep, RedPandaAnimations.SLEEPING, state.ageInTicks);
    }
}

