/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.luminoushalloween.init;

import net.mcreator.luminoushalloween.entity.HorselessHeadsmanEntity;
import net.mcreator.luminoushalloween.entity.PumpkinMinionEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class LuminousHalloweenModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"luminous_halloween");
    public static final DeferredHolder<EntityType<?>, EntityType<PumpkinMinionEntity>> PUMPKIN_MINION = LuminousHalloweenModEntities.register("pumpkin_minion", EntityType.Builder.of(PumpkinMinionEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<HorselessHeadsmanEntity>> HORSELESS_HEADSMAN = LuminousHalloweenModEntities.register("horseless_headsman", EntityType.Builder.of(HorselessHeadsmanEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(1.3f, 2.8f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            PumpkinMinionEntity.init();
            HorselessHeadsmanEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)PUMPKIN_MINION.get(), PumpkinMinionEntity.createAttributes().build());
        event.put((EntityType)HORSELESS_HEADSMAN.get(), HorselessHeadsmanEntity.createAttributes().build());
    }
}

