/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import harmonised.pmmo.client.utils.ClientUtils;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.codecs.CodecTypes;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.util.RegistryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.fml.LogicalSide;
import org.joml.Matrix4f;

public class TutorialOverlayGUI
implements LayeredDraw.Layer {
    private Minecraft mc;
    private Font fontRenderer;
    private List<ClientTooltipComponent> lines = new ArrayList<ClientTooltipComponent>();
    private BlockHitResult bhr;

    public void render(GuiGraphics guiGraphics, DeltaTracker partialTick) {
        if (this.mc == null) {
            this.mc = Minecraft.getInstance();
        }
        if (!(this.mc.hitResult instanceof BlockHitResult)) {
            return;
        }
        this.bhr = (BlockHitResult)this.mc.hitResult;
        if (this.fontRenderer == null) {
            this.fontRenderer = this.mc.font;
        }
        int renderLeft = guiGraphics.guiWidth() / 8 * 5;
        int renderTop = guiGraphics.guiHeight() / 4;
        int tooltipWidth = 3 * (guiGraphics.guiWidth() / 8);
        if (!this.mc.getDebugOverlay().showDebugScreen() && ((Boolean)Config.SALVAGE_HIGHLIGHTS.get()).booleanValue()) {
            if (this.mc.level.getBlockState(this.bhr.getBlockPos()).getBlock().equals(BuiltInRegistries.BLOCK.get(Config.server().general().salvageBlock()))) {
                this.lines = new ArrayList<ClientTooltipComponent>(ClientUtils.ctc(LangProvider.SALVAGE_TUTORIAL_HEADER.asComponent().withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GOLD}), tooltipWidth));
                if (!(!this.mc.player.isCrouching() || this.mc.player.getMainHandItem().isEmpty() && this.mc.player.getOffhandItem().isEmpty())) {
                    ItemStack salvageStack = this.mc.player.getMainHandItem().isEmpty() ? this.mc.player.getOffhandItem() : this.mc.player.getMainHandItem();
                    this.gatherSalvageData(salvageStack).forEach(line -> this.lines.addAll(ClientUtils.ctc(line, tooltipWidth)));
                } else {
                    this.lines.addAll(ClientUtils.ctc(LangProvider.SALVAGE_TUTORIAL_USAGE.asComponent(), tooltipWidth));
                }
            } else {
                return;
            }
            guiGraphics.pose().pushPose();
            RenderSystem.enableBlend();
            if (!this.lines.isEmpty()) {
                int i = 0;
                int j = this.lines.size() == 1 ? -2 : 0;
                for (ClientTooltipComponent clienttooltipcomponent : this.lines) {
                    int k = clienttooltipcomponent.getWidth(this.mc.font);
                    if (k > i) {
                        i = k;
                    }
                    j += clienttooltipcomponent.getHeight();
                }
                int l = renderLeft;
                int i1 = renderTop;
                guiGraphics.pose().pushPose();
                Tesselator tesselator = Tesselator.getInstance();
                BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
                RenderSystem.setShader(GameRenderer::getPositionColorShader);
                Matrix4f matrix4f = guiGraphics.pose().last().pose();
                TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)l, (int)i1, (int)i, (int)j, (int)400);
                RenderSystem.enableDepthTest();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                MultiBufferSource.BufferSource multibuffersource$buffersource = guiGraphics.bufferSource();
                guiGraphics.pose().translate(0.0f, 0.0f, 400.0f);
                int k1 = i1;
                for (int l1 = 0; l1 < this.lines.size(); ++l1) {
                    ClientTooltipComponent clienttooltipcomponent1 = this.lines.get(l1);
                    clienttooltipcomponent1.renderText(this.mc.font, l, k1, matrix4f, multibuffersource$buffersource);
                    k1 += clienttooltipcomponent1.getHeight() + (l1 == 0 ? 2 : 0);
                }
                multibuffersource$buffersource.endBatch();
                k1 = i1;
                for (int i2 = 0; i2 < this.lines.size(); ++i2) {
                    ClientTooltipComponent clienttooltipcomponent2 = this.lines.get(i2);
                    clienttooltipcomponent2.renderImage(this.mc.font, l, k1, guiGraphics);
                    k1 += clienttooltipcomponent2.getHeight() + (i2 == 0 ? 2 : 0);
                }
            }
            guiGraphics.pose().popPose();
        }
    }

    protected static void fillGradient(Matrix4f pMatrix, BufferBuilder pBuilder, int pX1, int pY1, int pX2, int pY2, int pBlitOffset, int pColorA, int pColorB) {
        float f = (float)(pColorA >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(pColorA >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(pColorA >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(pColorA & 0xFF) / 255.0f;
        float f4 = (float)(pColorB >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(pColorB >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(pColorB >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(pColorB & 0xFF) / 255.0f;
        pBuilder.addVertex(pMatrix, (float)pX2, (float)pY1, (float)pBlitOffset).setColor(f1, f2, f3, f);
        pBuilder.addVertex(pMatrix, (float)pX1, (float)pY1, (float)pBlitOffset).setColor(f1, f2, f3, f);
        pBuilder.addVertex(pMatrix, (float)pX1, (float)pY2, (float)pBlitOffset).setColor(f5, f6, f7, f4);
        pBuilder.addVertex(pMatrix, (float)pX2, (float)pY2, (float)pBlitOffset).setColor(f5, f6, f7, f4);
    }

    private List<MutableComponent> gatherSalvageData(ItemStack stack) {
        ArrayList<MutableComponent> outList = new ArrayList<MutableComponent>();
        for (Map.Entry<ResourceLocation, CodecTypes.SalvageData> entry : Core.get((LogicalSide)LogicalSide.CLIENT).getLoader().ITEM_LOADER.getData(RegistryUtil.getId(this.mc.level.registryAccess(), stack)).salvage().entrySet()) {
            outList.add(MutableComponent.create((ComponentContents)new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(entry.getKey())).getDisplayName().getContents()));
            CodecTypes.SalvageData data = entry.getValue();
            if (!data.levelReq().isEmpty()) {
                outList.add(LangProvider.SALVAGE_LEVEL_REQ.asComponent().withStyle(ChatFormatting.UNDERLINE));
                for (Map.Entry<String, Long> entry2 : data.levelReq().entrySet()) {
                    outList.add(Component.translatable((String)("pmmo." + entry2.getKey())).append((Component)Component.literal((String)(": " + String.valueOf(entry2.getValue())))));
                }
            }
            outList.add(LangProvider.SALVAGE_CHANCE.asComponent(data.baseChance(), data.maxChance()).withStyle(ChatFormatting.UNDERLINE));
            outList.add(LangProvider.SALVAGE_MAX.asComponent(data.salvageMax()).withStyle(ChatFormatting.UNDERLINE));
            if (!data.chancePerLevel().isEmpty()) {
                outList.add(LangProvider.SALVAGE_CHANCE_MOD.asComponent().withStyle(ChatFormatting.UNDERLINE));
                for (Map.Entry<String, Number> entry3 : data.chancePerLevel().entrySet()) {
                    outList.add(Component.translatable((String)("pmmo." + entry3.getKey())).append((Component)Component.literal((String)(": " + String.valueOf(entry3.getValue())))));
                }
            }
            if (data.xpAward().isEmpty()) continue;
            outList.add(LangProvider.SALVAGE_XP_AWARD.asComponent().withStyle(ChatFormatting.UNDERLINE));
            for (Map.Entry<String, Number> entry4 : data.xpAward().entrySet()) {
                outList.add(Component.translatable((String)("pmmo." + entry4.getKey())).append((Component)Component.literal((String)(": " + String.valueOf(entry4.getValue())))));
            }
        }
        return outList;
    }
}

