/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import harmonised.pmmo.client.events.ClientTickHandler;
import harmonised.pmmo.client.utils.DP;
import harmonised.pmmo.client.utils.DataMirror;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.codecs.SkillData;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.core.CoreUtils;
import harmonised.pmmo.features.veinmining.VeinMiningLogic;
import harmonised.pmmo.setup.CommonSetup;
import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.storage.Experience;
import harmonised.pmmo.util.Reference;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.LogicalSide;

public class XPOverlayGUI
implements LayeredDraw.Layer {
    private final Core core = Core.get(LogicalSide.CLIENT);
    private int skillGap = 0;
    private Minecraft mc;
    private Font fontRenderer;
    private Map<String, Double> modifiers = new HashMap<String, Double>();
    private final LinkedHashMap<String, SkillLine> lineRenderers = new LinkedHashMap();
    private int maxCharge = 0;
    private int currentCharge = 0;

    public void render(GuiGraphics guiGraphics, DeltaTracker partialTick) {
        if (this.mc == null) {
            this.mc = Minecraft.getInstance();
        }
        if (this.fontRenderer == null) {
            this.fontRenderer = this.mc.font;
        }
        if (!this.mc.getDebugOverlay().showDebugScreen()) {
            guiGraphics.pose().pushPose();
            RenderSystem.enableBlend();
            if (((Boolean)Config.SKILL_LIST_DISPLAY.get()).booleanValue()) {
                this.renderSkillList(guiGraphics, (Double)Config.SKILL_LIST_OFFSET_X.get(), (Double)Config.SKILL_LIST_OFFSET_Y.get());
            }
            if (Config.server().veinMiner().enabled() && ((Boolean)Config.VEIN_GAUGE_DISPLAY.get()).booleanValue()) {
                this.renderVeinGauge(guiGraphics, (Double)Config.VEIN_GAUGE_OFFSET_X.get(), (Double)Config.VEIN_GAUGE_OFFSET_Y.get());
            }
            if (((Boolean)Config.GAIN_LIST_DISPLAY.get()).booleanValue()) {
                if (!ClientTickHandler.xpGains.isEmpty() && ClientTickHandler.xpGains.get((int)0).duration <= 0) {
                    ClientTickHandler.xpGains.remove(0);
                }
                this.renderGains(guiGraphics, (Double)Config.GAIN_LIST_OFFSET_X.get(), (Double)Config.GAIN_LIST_OFFSET_Y.get());
            }
            guiGraphics.pose().popPose();
        }
        if (ClientTickHandler.isRefreshTick()) {
            ClientTickHandler.resetTicks();
        }
    }

    private void renderSkillList(GuiGraphics graphics, double skillListX, double skillListY) {
        int renderX = (int)((double)this.mc.getWindow().getGuiScaledWidth() * skillListX);
        int renderY = (int)((double)this.mc.getWindow().getGuiScaledHeight() * skillListY);
        if (ClientTickHandler.isRefreshTick()) {
            this.modifiers = this.core.getConsolidatedModifierMap((Player)this.mc.player);
            List<String> skillsKeys = this.core.getData().getXpMap(null).keySet().stream().filter(a -> Config.skills().skills().getOrDefault(a, SkillData.Builder.getDefault()).getShowInList()).sorted(Comparator.comparingLong(a -> this.core.getData().getLevel((String)a, null)).reversed()).toList();
            LinkedHashMap<String, SkillLine> holderMap = this.lineRenderers;
            this.lineRenderers.clear();
            AtomicInteger yOffset = new AtomicInteger(0);
            this.skillGap = skillsKeys.stream().map(skill -> this.fontRenderer.width(Component.translatable((String)("pmmo." + skill)).getString())).max(Comparator.comparingInt(t -> t)).orElse(0);
            skillsKeys.forEach(skillKey -> {
                Experience xpRaw = this.core.getData().getXpMap(null).getOrDefault(skillKey, new Experience());
                this.lineRenderers.put((String)skillKey, xpRaw != holderMap.getOrDefault(skillKey, SkillLine.DEFAULT).xpValue() ? new SkillLine((String)skillKey, this.modifiers.getOrDefault(skillKey, 1.0), xpRaw, yOffset.get(), this.skillGap) : new SkillLine((SkillLine)holderMap.get(skillKey), yOffset.get()));
                yOffset.getAndIncrement();
            });
        }
        this.lineRenderers.forEach((skill, line) -> line.render(graphics, renderX, renderY, this.fontRenderer));
    }

    private void renderVeinGauge(GuiGraphics graphics, double gaugeX, double gaugeY) {
        int renderX = (int)((double)this.mc.getWindow().getGuiScaledWidth() * gaugeX);
        int renderY = (int)((double)this.mc.getWindow().getGuiScaledHeight() * gaugeY);
        if (ClientTickHandler.isRefreshTick()) {
            this.maxCharge = VeinMiningLogic.getMaxChargeFromAllItems((Player)this.mc.player);
            if (this.maxCharge > 0) {
                this.currentCharge = (int)this.mc.player.getAttribute(CommonSetup.VEIN_AMOUNT).getValue();
            }
        }
        if (this.currentCharge > 0) {
            graphics.drawString(this.fontRenderer, (Component)LangProvider.VEIN_LIMIT.asComponent(Config.VEIN_LIMIT.get()), renderX, renderY - 11, 0xFFFFFF);
            graphics.drawString(this.fontRenderer, (Component)LangProvider.VEIN_CHARGE.asComponent(this.currentCharge, this.maxCharge), renderX, renderY, 0xFFFFFF);
        }
    }

    private void renderGains(GuiGraphics graphics, double listX, double listY) {
        int renderX = (int)((double)this.mc.getWindow().getGuiScaledWidth() * listX);
        int renderY = (int)((double)this.mc.getWindow().getGuiScaledHeight() * listY);
        for (int i = 0; i < ClientTickHandler.xpGains.size(); ++i) {
            ClientTickHandler.GainEntry entry = ClientTickHandler.xpGains.get(i);
            graphics.drawString(this.fontRenderer, entry.display(), renderX, 3 + renderY + i * 9, entry.getColor());
        }
    }

    private record SkillLine(String xpRaw, ResourceLocation icon, int iconSize, MutableComponent skillName, String bonusLine, Experience xpValue, int color, int yOffset, int skillGap) {
        public static SkillLine DEFAULT = new SkillLine("", Reference.mc("missing"), 16, Component.literal((String)""), "", new Experience(), 0xFFFFFF, 0, 0);

        public SkillLine(String skillName, double bonus, Experience xpValue, int yOffset, int skillGap) {
            this(SkillLine.rawXpLine(xpValue, skillName), Config.skills().skills().getOrDefault(skillName, SkillData.Builder.getDefault()).getIcon(), Config.skills().skills().getOrDefault(skillName, SkillData.Builder.getDefault()).getIconSize(), Component.translatable((String)("pmmo." + skillName)), SkillLine.bonusLine(bonus), xpValue, CoreUtils.getSkillColor(skillName), yOffset * 9, skillGap);
        }

        public SkillLine(SkillLine src, int yOffset) {
            this(src.xpRaw(), src.icon(), src.iconSize(), src.skillName(), src.bonusLine(), src.xpValue(), src.color, yOffset * 9, src.skillGap());
        }

        private static String rawXpLine(Experience xpValue, String skillKey) {
            double level = ((DataMirror)Core.get(LogicalSide.CLIENT).getData()).getXpWithPercentToNextLevel(xpValue);
            if (level > (double)Config.skills().get(skillKey).getMaxLevel()) {
                return "" + Config.skills().get(skillKey).getMaxLevel();
            }
            if (level > (double)Config.server().levels().maxLevel()) {
                return "" + Config.server().levels().maxLevel();
            }
            return DP.dpCustom(Math.floor(level * 100.0) / 100.0, 2);
        }

        private static String bonusLine(double bonus) {
            if (bonus != 1.0) {
                return ((bonus = (Math.max(0.0, bonus) - 1.0) * 100.0) >= 0.0 ? "+" : "-") + DP.dp(bonus) + "%";
            }
            return "";
        }

        public void render(GuiGraphics graphics, int skillListX, int skillListY, Font fontRenderer) {
            int levelGap = fontRenderer.width(this.xpRaw());
            graphics.drawString(fontRenderer, this.xpRaw(), skillListX, skillListY + 3 + this.yOffset(), this.color());
            if (((Boolean)Config.SKILL_LIST_USE_ICONS.get()).booleanValue()) {
                graphics.blit(this.icon(), skillListX + levelGap + 2, skillListY + 3 + this.yOffset(), 9, 9, 0.0f, 0.0f, this.iconSize(), this.iconSize(), this.iconSize(), this.iconSize());
            } else {
                graphics.drawString(fontRenderer, " | " + this.skillName.getString(), skillListX + levelGap, skillListY + 3 + this.yOffset(), this.color());
            }
            graphics.drawString(fontRenderer, this.bonusLine, skillListX + levelGap + ((Boolean)Config.SKILL_LIST_USE_ICONS.get() != false ? 6 : this.skillGap()) + 9, skillListY + 3 + this.yOffset(), this.color());
        }
    }
}

