/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.client.gui.component;

import com.mojang.blaze3d.vertex.Tesselator;
import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ModifierDataType;
import harmonised.pmmo.api.enums.ObjectType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.client.gui.GlossarySelectScreen;
import harmonised.pmmo.client.gui.component.GuiEnumGroup;
import harmonised.pmmo.client.utils.ClientUtils;
import harmonised.pmmo.client.utils.DP;
import harmonised.pmmo.client.utils.DataMirror;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.codecs.CodecTypes;
import harmonised.pmmo.config.codecs.DataSource;
import harmonised.pmmo.config.codecs.EnhancementsData;
import harmonised.pmmo.config.codecs.LocationData;
import harmonised.pmmo.config.codecs.MobModifier;
import harmonised.pmmo.config.codecs.PlayerData;
import harmonised.pmmo.config.codecs.VeinData;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.core.CoreUtils;
import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.storage.Experience;
import harmonised.pmmo.util.Reference;
import harmonised.pmmo.util.RegistryUtil;
import harmonised.pmmo.util.TagUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.client.gui.widget.ScrollPanel;

public class StatScrollWidget
extends ScrollPanel {
    Minecraft mc = Minecraft.getInstance();
    Core core = Core.get(LogicalSide.CLIENT);
    private final List<Element> content = new ArrayList<Element>();
    private final Supplier<List<ItemStack>> itemSupplier = () -> CreativeModeTabs.searchTab().getDisplayItems().stream().toList();
    private static final String PREDICATE_KEY = "usesPredicate";

    private StatScrollWidget(int width, int height, int top, int left) {
        super(Minecraft.getInstance(), width, height, top, left, 4);
        CreativeModeTabs.tryRebuildTabContents((FeatureFlagSet)this.mc.player.connection.enabledFeatures(), (boolean)this.mc.player.canUseGameMasterBlocks(), (HolderLookup.Provider)this.mc.player.clientLevel.registryAccess());
    }

    public StatScrollWidget(int width, int height, int top, int left, int pointless) {
        this(width, height, top, left);
        this.populateLocation(List.of(this.mc.level.dimension().location()), new ReqType[]{ReqType.TRAVEL}, new ModifierDataType[]{ModifierDataType.DIMENSION}, "", false, true, true);
        this.populateLocation(List.of(((ResourceKey)this.mc.level.getBiome(this.mc.player.blockPosition()).unwrapKey().get()).location()), new ReqType[]{ReqType.TRAVEL}, new ModifierDataType[]{ModifierDataType.BIOME}, "", true, true, true);
    }

    public StatScrollWidget(int width, int height, int top, int left, ItemStack stack) {
        this(width, height, top, left);
        EventType[] events = stack.getItem() instanceof BlockItem ? EventType.BLOCKITEM_APPLICABLE_EVENTS : EventType.ITEM_APPLICABLE_EVENTS;
        ReqType[] reqs = stack.getItem() instanceof BlockItem ? ReqType.BLOCKITEM_APPLICABLE_EVENTS : ReqType.ITEM_APPLICABLE_EVENTS;
        this.populateItems(List.of(stack), events, reqs, ModifierDataType.values(), "", true, true);
    }

    public StatScrollWidget(int width, int height, int top, int left, Entity entity) {
        this(width, height, top, left);
        this.populateEntity(List.of(entity), EventType.ENTITY_APPLICABLE_EVENTS, ReqType.ENTITY_APPLICABLE_EVENTS, entity instanceof Player, "");
    }

    public StatScrollWidget(int width, int height, int top, int left, BlockPos pos) {
        this(width, height, top, left);
        this.populateBlockFromWorld(pos, ReqType.BLOCK_APPLICABLE_EVENTS);
    }

    public StatScrollWidget(int width, int height, int top, int left, GlossarySelectScreen.SELECTION selection, GlossarySelectScreen.OBJECT object, String skill, GuiEnumGroup type) {
        this(width, height, top, left);
        this.generateGlossary(selection, object, skill, type);
    }

    private int step(int level) {
        return level * 10;
    }

    public void generateGlossary(GlossarySelectScreen.SELECTION selection, GlossarySelectScreen.OBJECT object, String skill, GuiEnumGroup type) {
        block0 : switch (selection) {
            case REQS: {
                EventType[] events = new EventType[]{};
                ModifierDataType[] bonuses = new ModifierDataType[]{};
                switch (object) {
                    case ITEMS: {
                        ReqType[] reqTypeArray;
                        if (type == null) {
                            reqTypeArray = ReqType.ITEM_APPLICABLE_EVENTS;
                        } else {
                            ReqType[] reqTypeArray2 = new ReqType[1];
                            reqTypeArray = reqTypeArray2;
                            reqTypeArray2[0] = (ReqType)type;
                        }
                        this.populateItems(this.itemSupplier.get(), events, reqTypeArray, bonuses, skill, false, false);
                        break block0;
                    }
                    case BLOCKS: {
                        ReqType[] reqTypeArray;
                        List<Block> list = BuiltInRegistries.BLOCK.stream().toList();
                        if (type == null) {
                            reqTypeArray = ReqType.BLOCK_APPLICABLE_EVENTS;
                        } else {
                            ReqType[] reqTypeArray3 = new ReqType[1];
                            reqTypeArray = reqTypeArray3;
                            reqTypeArray3[0] = (ReqType)type;
                        }
                        this.populateBlocks(list, events, reqTypeArray, false, skill);
                        break block0;
                    }
                    case ENTITY: {
                        ReqType[] reqTypeArray;
                        List<Entity> list = BuiltInRegistries.ENTITY_TYPE.stream().map(entityType -> entityType.create((Level)this.mc.level)).filter(Objects::nonNull).toList();
                        if (type == null) {
                            reqTypeArray = ReqType.ENTITY_APPLICABLE_EVENTS;
                        } else {
                            ReqType[] reqTypeArray4 = new ReqType[1];
                            reqTypeArray = reqTypeArray4;
                            reqTypeArray4[0] = (ReqType)type;
                        }
                        this.populateEntity(list, events, reqTypeArray, false, skill);
                        break block0;
                    }
                    case DIMENSIONS: {
                        this.populateLocation(this.mc.player.connection.levels().stream().map(ResourceKey::location).toList(), new ReqType[]{ReqType.TRAVEL}, bonuses, skill, false, false, false);
                        break block0;
                    }
                    case BIOMES: {
                        this.populateLocation(this.mc.player.level().registryAccess().registryOrThrow(Registries.BIOME).keySet().stream().toList(), new ReqType[]{ReqType.TRAVEL}, bonuses, skill, true, false, false);
                        break block0;
                    }
                    case ENCHANTS: {
                        Registry reg = this.mc.player.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
                        this.populateEnchants(new ArrayList<ResourceLocation>(reg.keySet()), skill);
                        break block0;
                    }
                }
                break;
            }
            case XP: {
                ReqType[] reqs = new ReqType[]{};
                ModifierDataType[] bonuses = new ModifierDataType[]{};
                switch (object) {
                    case ITEMS: {
                        EventType[] eventTypeArray;
                        if (type == null) {
                            eventTypeArray = EventType.ITEM_APPLICABLE_EVENTS;
                        } else {
                            EventType[] eventTypeArray2 = new EventType[1];
                            eventTypeArray = eventTypeArray2;
                            eventTypeArray2[0] = (EventType)type;
                        }
                        this.populateItems(this.itemSupplier.get(), eventTypeArray, reqs, bonuses, skill, false, false);
                        break block0;
                    }
                    case BLOCKS: {
                        EventType[] eventTypeArray;
                        List<Block> list = BuiltInRegistries.BLOCK.stream().toList();
                        if (type == null) {
                            eventTypeArray = EventType.BLOCK_APPLICABLE_EVENTS;
                        } else {
                            EventType[] eventTypeArray3 = new EventType[1];
                            eventTypeArray = eventTypeArray3;
                            eventTypeArray3[0] = (EventType)type;
                        }
                        this.populateBlocks(list, eventTypeArray, reqs, false, skill);
                        break block0;
                    }
                    case ENTITY: {
                        EventType[] eventTypeArray;
                        List<Entity> list = BuiltInRegistries.ENTITY_TYPE.stream().map(entityType -> entityType.create((Level)Minecraft.getInstance().level)).filter(entity -> entity != null).toList();
                        if (type == null) {
                            eventTypeArray = EventType.ENTITY_APPLICABLE_EVENTS;
                        } else {
                            EventType[] eventTypeArray4 = new EventType[1];
                            eventTypeArray = eventTypeArray4;
                            eventTypeArray4[0] = (EventType)type;
                        }
                        this.populateEntity(list, eventTypeArray, reqs, false, skill);
                        break block0;
                    }
                    case EFFECTS: {
                        this.populateEffects(BuiltInRegistries.MOB_EFFECT.holders().collect(Collectors.toSet()), new EventType[]{EventType.EFFECT}, reqs, skill);
                        break block0;
                    }
                }
                break;
            }
            case BONUS: {
                ReqType[] reqs = new ReqType[]{};
                EventType[] events = new EventType[]{};
                switch (object) {
                    case ITEMS: {
                        ModifierDataType[] modifierDataTypeArray;
                        if (type == null) {
                            modifierDataTypeArray = ModifierDataType.values();
                        } else {
                            ModifierDataType[] modifierDataTypeArray2 = new ModifierDataType[1];
                            modifierDataTypeArray = modifierDataTypeArray2;
                            modifierDataTypeArray2[0] = (ModifierDataType)type;
                        }
                        this.populateItems(this.itemSupplier.get(), events, reqs, modifierDataTypeArray, skill, false, false);
                        break block0;
                    }
                    case DIMENSIONS: {
                        ModifierDataType[] modifierDataTypeArray;
                        List<ResourceLocation> list = this.mc.player.connection.levels().stream().map(key -> key.location()).toList();
                        if (type == null) {
                            modifierDataTypeArray = ModifierDataType.values();
                        } else {
                            ModifierDataType[] modifierDataTypeArray3 = new ModifierDataType[1];
                            modifierDataTypeArray = modifierDataTypeArray3;
                            modifierDataTypeArray3[0] = (ModifierDataType)type;
                        }
                        this.populateLocation(list, reqs, modifierDataTypeArray, skill, false, false, false);
                        break block0;
                    }
                    case BIOMES: {
                        ModifierDataType[] modifierDataTypeArray;
                        List<ResourceLocation> list = this.mc.player.level().registryAccess().registryOrThrow(Registries.BIOME).keySet().stream().toList();
                        if (type == null) {
                            modifierDataTypeArray = ModifierDataType.values();
                        } else {
                            ModifierDataType[] modifierDataTypeArray4 = new ModifierDataType[1];
                            modifierDataTypeArray = modifierDataTypeArray4;
                            modifierDataTypeArray4[0] = (ModifierDataType)type;
                        }
                        this.populateLocation(list, reqs, modifierDataTypeArray, skill, true, false, false);
                        break block0;
                    }
                }
                break;
            }
            case SALVAGE: {
                if (object != GlossarySelectScreen.OBJECT.ITEMS) break;
                this.populateItems(this.itemSupplier.get(), new EventType[0], new ReqType[0], new ModifierDataType[0], skill, true, false);
                break;
            }
            case VEIN: {
                ReqType[] reqs = new ReqType[]{};
                EventType[] events = new EventType[]{};
                ModifierDataType[] bonuses = new ModifierDataType[]{};
                switch (object) {
                    case ITEMS: {
                        this.populateItems(this.itemSupplier.get(), events, reqs, bonuses, skill, false, true);
                        break block0;
                    }
                    case BLOCKS: {
                        this.populateBlocks(BuiltInRegistries.BLOCK.stream().toList(), events, reqs, true, skill);
                        break block0;
                    }
                    case DIMENSIONS: {
                        this.populateLocation(this.mc.player.connection.levels().stream().map(key -> key.location()).toList(), reqs, bonuses, skill, false, true, false);
                        break block0;
                    }
                    case BIOMES: {
                        this.populateLocation(this.mc.player.level().registryAccess().registryOrThrow(Registries.BIOME).keySet().stream().toList(), reqs, bonuses, skill, true, true, false);
                        break block0;
                    }
                }
                break;
            }
            case MOB_SCALING: {
                ReqType[] reqs = new ReqType[]{};
                ModifierDataType[] bonuses = new ModifierDataType[]{};
                switch (object) {
                    case DIMENSIONS: {
                        this.populateLocation(this.mc.player.connection.levels().stream().map(key -> key.location()).toList(), reqs, bonuses, skill, false, false, true);
                        break block0;
                    }
                    case BIOMES: {
                        this.populateLocation(this.mc.player.level().registryAccess().registryOrThrow(Registries.BIOME).keySet().stream().toList(), reqs, bonuses, skill, true, false, true);
                        break block0;
                    }
                }
                break;
            }
            case PERKS: {
                this.populatePerks(skill);
                break;
            }
        }
    }

    private void populateItems(List<ItemStack> items, EventType[] events, ReqType[] reqs, ModifierDataType[] modifiers, String skillFilter, boolean includeSalvage, boolean includeVein) {
        for (ItemStack stack : items) {
            int lengthBeforeProcessing = this.content.size() + 1;
            if (items.size() > 1) {
                this.content.add(new RenderableElement(stack.getDisplayName(), 1, (int)stack.getRarity().color().getColor(), (int)((Integer)Config.SECTION_HEADER_COLOR.get()), stack));
            }
            this.addEventSection(event -> {
                Map<String, Long> map = this.core.getExperienceAwards((EventType)event, stack, (Player)this.mc.player, new CompoundTag());
                if (stack.getItem() instanceof BlockItem) {
                    map = this.core.getCommonXpAwardData((Map<String, Long>)new HashMap<String, Long>(), (EventType)event, RegistryUtil.getId(this.mc.level.registryAccess(), stack), (Player)this.mc.player, ObjectType.BLOCK, TagUtils.stackTag(stack, (Level)this.mc.level));
                }
                return map;
            }, events, skillFilter);
            this.addReqSection(reqType -> {
                Map<String, Long> reqMap = this.core.getReqMap((ReqType)reqType, stack, (Level)this.mc.level, true);
                if (reqType == ReqType.USE_ENCHANTMENT) {
                    this.core.getEnchantReqs(stack).forEach((skill, level) -> reqMap.merge((String)skill, (Long)level, (o, n) -> o > n ? o : n));
                }
                if (stack.getItem() instanceof BlockItem) {
                    reqMap.putAll(this.core.getCommonReqData((Map<String, Long>)new HashMap<String, Long>(), ObjectType.BLOCK, RegistryUtil.getId(this.mc.level.registryAccess(), stack), (ReqType)reqType, TagUtils.stackTag(stack, (Level)this.mc.level)));
                }
                return reqMap;
            }, CoreUtils.getEffects(this.core.getLoader().getLoader(ObjectType.ITEM).getData(RegistryUtil.getId(this.mc.level.registryAccess(), stack)).getNegativeEffect(), true), reqs, skillFilter);
            this.addModifierSection(mod -> this.core.getTooltipRegistry().bonusTooltipExists(RegistryUtil.getId(this.mc.level.registryAccess(), stack), (ModifierDataType)mod) ? this.core.getTooltipRegistry().getBonusTooltipData(RegistryUtil.getId(this.mc.level.registryAccess(), stack), (ModifierDataType)mod, stack) : this.core.getObjectModifierMap(ObjectType.ITEM, RegistryUtil.getId(this.mc.level.registryAccess(), stack), (ModifierDataType)mod, TagUtils.stackTag(stack, (Level)this.mc.level)), modifiers, skillFilter);
            if (includeSalvage) {
                this.addSalvageSection(this.core.getLoader().ITEM_LOADER.getData(RegistryUtil.getId(this.mc.level.registryAccess(), stack)).salvage());
            }
            if (includeVein) {
                this.addItemVeinSection(this.core.getLoader().ITEM_LOADER.getData(RegistryUtil.getId(this.mc.level.registryAccess(), stack)).veinData(), stack.getItem() instanceof BlockItem);
            }
            if (lengthBeforeProcessing != this.content.size()) continue;
            this.content.remove(this.content.size() - 1);
        }
    }

    private void populateBlockFromWorld(BlockPos block, ReqType[] reqs) {
        this.addEventSection(event -> this.core.getExperienceAwards((EventType)event, block, (Level)Minecraft.getInstance().level, null, new CompoundTag()), EventType.BLOCK_APPLICABLE_EVENTS, "");
        this.addReqSection(reqType -> this.core.getReqMap((ReqType)reqType, block, (Level)Minecraft.getInstance().level), new ArrayList<MobEffectInstance>(), reqs, "");
        this.addBlockVeinSection(this.core.getLoader().BLOCK_LOADER.getData(RegistryUtil.getId(Minecraft.getInstance().level.getBlockState(block))).veinData());
    }

    private void populateBlocks(Collection<Block> blocks, EventType[] events, ReqType[] reqs, boolean includeVein, String skillFilter) {
        for (Block block : blocks) {
            int lengthBeforeProcessing = this.content.size() + 1;
            ItemStack stack = new ItemStack((ItemLike)block.asItem());
            ResourceLocation id = RegistryUtil.getId(block);
            this.content.add(new RenderableElement(stack.getDisplayName(), 1, (int)stack.getRarity().color().getColor(), (int)((Integer)Config.SECTION_HEADER_COLOR.get()), block));
            this.addEventSection(event -> this.core.getTooltipRegistry().xpGainTooltipExists(id, (EventType)event) ? Collections.singletonMap(PREDICATE_KEY, 0L) : this.core.getObjectExperienceMap(ObjectType.BLOCK, id, (EventType)event, new CompoundTag()), events, skillFilter);
            this.addReqSection(reqType -> this.core.getPredicateRegistry().predicateExists(id, (ReqType)reqType) ? Collections.singletonMap(PREDICATE_KEY, 0L) : this.core.getObjectSkillMap(ObjectType.BLOCK, id, (ReqType)reqType, new CompoundTag()), new ArrayList<MobEffectInstance>(), reqs, skillFilter);
            if (includeVein) {
                this.addBlockVeinSection(this.core.getLoader().BLOCK_LOADER.getData(RegistryUtil.getId(block)).veinData());
            }
            if (lengthBeforeProcessing != this.content.size()) continue;
            this.content.remove(this.content.size() - 1);
        }
    }

    private void populateEntity(List<? extends Entity> entities, EventType[] events, ReqType[] reqs, boolean isPlayer, String skillFilter) {
        for (Entity entity : entities) {
            int lengthBeforeProcessing = this.content.size() + 1;
            if (entities.size() > 1) {
                this.content.add(new RenderableElement(entity.getDisplayName(), 1, 0xEEEEEE, (int)((Integer)Config.SECTION_HEADER_COLOR.get()), entity));
            }
            this.addEventSection(event -> this.core.getExperienceAwards((EventType)event, entity, null, new CompoundTag()), events, skillFilter);
            this.addReqSection(reqType -> this.core.getReqMap((ReqType)reqType, entity), new ArrayList<MobEffectInstance>(), reqs, skillFilter);
            if (isPlayer) {
                this.addPlayerSection(entity);
            }
            if (lengthBeforeProcessing != this.content.size()) continue;
            this.content.remove(this.content.size() - 1);
        }
    }

    private void populateEffects(Collection<Holder<MobEffect>> effects, EventType[] events, ReqType[] reqs, String skillFilter) {
        for (Holder<MobEffect> effect : effects) {
            int lengthBeforeProcessing = this.content.size() + 1;
            if (effects.size() > 1) {
                this.content.addAll(TextElement.build(((MobEffect)effect.value()).getDisplayName(), this.width, 1, 0xEEEEEE, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
            }
            ArrayList<TextElement> holder = new ArrayList<TextElement>();
            for (int lvl = 0; lvl <= this.getEffectHighestConfiguration(effect); ++lvl) {
                Map<String, Long> xpMap = this.core.getExperienceAwards(new MobEffectInstance(effect, 30, lvl), null, new CompoundTag());
                if (xpMap.isEmpty() || xpMap.entrySet().stream().allMatch(entry -> (Long)entry.getValue() == 0L)) continue;
                holder.addAll(TextElement.build((Component)Component.literal((String)String.valueOf(lvl)), this.width, 1, 0xFFFFFF, false, 0));
                for (Map.Entry<String, Long> map : xpMap.entrySet()) {
                    if (map.getValue() == 0L) continue;
                    holder.addAll(TextElement.build(map.getKey(), map.getValue(), this.width, this.step(1), CoreUtils.getSkillColor(map.getKey())));
                }
            }
            if (!holder.isEmpty()) {
                this.content.addAll(TextElement.build((Component)LangProvider.EVENT_HEADER.asComponent().withStyle(ChatFormatting.BOLD), this.width, 1, 0xEEEEEE, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
                this.content.addAll(holder);
            }
            if (lengthBeforeProcessing != this.content.size()) continue;
            this.content.remove(this.content.size() - 1);
        }
    }

    private int getEffectHighestConfiguration(Holder<MobEffect> effect) {
        DataSource data = (DataSource)this.core.getLoader().getLoader(ObjectType.EFFECT).getData().get(((ResourceKey)effect.unwrapKey().get()).location());
        return data == null ? 0 : ((EnhancementsData)data).skillArray().keySet().stream().max(Comparator.naturalOrder()).orElse(-1);
    }

    private void populateLocation(List<ResourceLocation> locations, ReqType[] reqs, ModifierDataType[] modifiers, String skillFilter, boolean isBiome, boolean includeVein, boolean includeScaling) {
        locations.forEach(loc -> {
            int lengthBeforeProcessing = this.content.size() + 1;
            if (locations.size() > 1) {
                this.content.addAll(TextElement.build((Component)Component.literal((String)loc.toString()).withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GOLD}), this.width, 1, 0xEEEEEE, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
            }
            this.addReqSection(reqType -> this.core.getObjectSkillMap(isBiome ? ObjectType.BIOME : ObjectType.DIMENSION, (ResourceLocation)loc, (ReqType)reqType, new CompoundTag()), isBiome ? CoreUtils.getEffects(this.core.getLoader().getLoader(ObjectType.BIOME).getData((ResourceLocation)loc).getNegativeEffect(), true) : new ArrayList<MobEffectInstance>(), reqs, skillFilter);
            if (reqs.length > 0 && isBiome) {
                this.addReqEffectSection(CoreUtils.getEffects(isBiome ? this.core.getLoader().getLoader(ObjectType.BIOME).getData((ResourceLocation)loc).getPositiveEffect() : this.core.getLoader().getLoader(ObjectType.DIMENSION).getData((ResourceLocation)loc).getPositiveEffect(), false), false);
            }
            this.addModifierSection(mod -> this.core.getObjectModifierMap(isBiome ? ObjectType.BIOME : ObjectType.DIMENSION, (ResourceLocation)loc, (ModifierDataType)mod, new CompoundTag()), modifiers, skillFilter);
            if (includeVein) {
                this.addVeinBlacklistSection(isBiome ? ObjectType.BIOME : ObjectType.DIMENSION, (ResourceLocation)loc);
            }
            if (includeScaling) {
                this.addMobModifierSection(isBiome ? ObjectType.BIOME : ObjectType.DIMENSION, (ResourceLocation)loc);
            }
            if (lengthBeforeProcessing == this.content.size()) {
                this.content.remove(this.content.size() - 1);
            }
        });
    }

    private void populateEnchants(List<ResourceLocation> enchants, String skillFilter) {
        enchants.forEach(ench -> {
            int lengthBeforeProcessing = this.content.size() + 1;
            if (enchants.size() > 1) {
                this.content.addAll(TextElement.build((Component)Component.literal((String)ench.toString()).withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GOLD}), this.width, 1, 0xEEEEEE, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
            }
            ArrayList<TextElement> holder = new ArrayList<TextElement>();
            for (int i = 0; i <= ((Enchantment)this.mc.player.registryAccess().registryOrThrow(Registries.ENCHANTMENT).get(ench)).getMaxLevel(); ++i) {
                Map<String, Long> reqMap = this.core.getEnchantmentReqs((ResourceLocation)ench, i).entrySet().stream().filter(entry -> ((String)entry.getKey()).contains(skillFilter)).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Long)e.getValue()));
                if (reqMap.isEmpty() || reqMap.entrySet().stream().allMatch(entry -> (Long)entry.getValue() == 0L)) continue;
                holder.addAll(TextElement.build((Component)Component.literal((String)String.valueOf(i)), this.width, 1, 0xFFFFFF, false, 0));
                for (Map.Entry<String, Long> map : reqMap.entrySet()) {
                    if (map.getValue() == 0L) continue;
                    holder.addAll(TextElement.build(map.getKey(), map.getValue(), this.width, this.step(1), CoreUtils.getSkillColor(map.getKey())));
                }
            }
            if (holder.size() > 0) {
                this.content.addAll(TextElement.build((Component)LangProvider.REQ_HEADER.asComponent().withStyle(ChatFormatting.BOLD), this.width, 1, 0xEEEEEE, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
                this.content.addAll(holder);
            }
            if (lengthBeforeProcessing == this.content.size()) {
                this.content.remove(this.content.size() - 1);
            }
        });
    }

    private void populatePerks(String skillFilter) {
        for (EventType cause : EventType.values()) {
            ArrayList holder = new ArrayList();
            LocalPlayer player = Minecraft.getInstance().player;
            ((List)Config.perks().perks().getOrDefault(cause, new ArrayList())).forEach(arg_0 -> this.lambda$populatePerks$27(skillFilter, (Player)player, holder, arg_0));
            if (holder.size() <= 0) continue;
            this.content.addAll(TextElement.build(cause, this.width, 1, 0xEEEEEE, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
            this.content.addAll(holder);
        }
        for (DataMirror.GLM glm : ((DataMirror)this.core.getData()).lootModifiers) {
            if (!skillFilter.isEmpty() && !glm.skill().equals(skillFilter)) continue;
            ArrayList elements = new ArrayList();
            glm.getGUILines(this.core).forEach(c -> elements.addAll(TextElement.build(c, this.width, c.getStyle().isBold() ? 0 : 1, c.getStyle().isBold() ? 0xFFFFFF : 0xEEEEEE, c.getStyle().isBold(), (int)((Integer)Config.SECTION_HEADER_COLOR.get()))));
            this.content.addAll(elements);
        }
    }

    private void addEventSection(Function<EventType, Map<String, Long>> xpSrc, EventType[] events, String skillFilter) {
        if (events.length > 0) {
            ArrayList<TextElement> holder = new ArrayList<TextElement>();
            for (EventType event : events) {
                Map<String, Long> xpAwards = CoreUtils.processSkillGroupXP(xpSrc.apply(event)).entrySet().stream().filter(entry -> ((String)entry.getKey()).contains(skillFilter)).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Long)e.getValue()));
                if (xpAwards.containsKey(PREDICATE_KEY)) {
                    holder.addAll(TextElement.build((Component)LangProvider.ADDON_AFFECTED_ATTRIBUTE.asComponent(), this.width, 5, 16751619, false, 0));
                    continue;
                }
                if (xpAwards.isEmpty()) continue;
                holder.addAll(TextElement.build(event, this.width, 1, 0xFFFFFF, false, 0));
                for (Map.Entry<String, Long> map : xpAwards.entrySet()) {
                    holder.addAll(TextElement.build(map.getKey(), map.getValue(), this.width, 5, CoreUtils.getSkillColor(map.getKey())));
                }
            }
            if (!holder.isEmpty()) {
                this.content.addAll(TextElement.build((Component)LangProvider.EVENT_HEADER.asComponent().withStyle(ChatFormatting.BOLD), this.width, 1, 0xEEEEEE, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
                this.content.addAll(holder);
            }
        }
    }

    private void addReqSection(Function<ReqType, Map<String, Long>> reqSrc, List<MobEffectInstance> reqEffects, ReqType[] reqs, String skillFilter) {
        if (reqs.length > 0) {
            ArrayList<TextElement> holder = new ArrayList<TextElement>();
            for (ReqType reqType : reqs) {
                Map<String, Long> reqMap = CoreUtils.processSkillGroupReqs(reqSrc.apply(reqType)).entrySet().stream().filter(entry -> ((String)entry.getKey()).contains(skillFilter)).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Long)e.getValue()));
                if (reqMap.isEmpty() || reqMap.entrySet().stream().allMatch(entry -> (Long)entry.getValue() == 0L)) continue;
                holder.addAll(TextElement.build(reqType, this.width, 1, 0xFFFFFF, false, 0));
                for (Map.Entry<String, Long> map : reqMap.entrySet()) {
                    if (map.getValue() == 0L) continue;
                    holder.addAll(TextElement.build(map.getKey(), map.getValue(), this.width, this.step(1), CoreUtils.getSkillColor(map.getKey())));
                }
            }
            if (!holder.isEmpty()) {
                this.content.addAll(TextElement.build((Component)LangProvider.REQ_HEADER.asComponent().withStyle(ChatFormatting.BOLD), this.width, 1, 0xEEEEEE, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
                this.content.addAll(holder);
                this.addReqEffectSection(reqEffects, true);
            }
        }
    }

    private void addReqEffectSection(List<MobEffectInstance> reqEffects, boolean isNegative) {
        if (!reqEffects.isEmpty()) {
            this.content.addAll(TextElement.build((Component)(isNegative ? LangProvider.REQ_EFFECTS_HEADER.asComponent() : LangProvider.BIOME_EFFECT_POS.asComponent()), this.width, 1, 0xFFFFFF, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
            for (MobEffectInstance mei : reqEffects) {
                this.content.addAll(TextElement.build(((MobEffect)mei.getEffect().value()).getDisplayName(), this.width, this.step(1), 0xFFFFFF, false, 0));
            }
        }
    }

    private void addModifierSection(Function<ModifierDataType, Map<String, Double>> bonusSrc, ModifierDataType[] mods, String skillFilter) {
        if (mods.length > 0) {
            ArrayList<TextElement> holder = new ArrayList<TextElement>();
            for (ModifierDataType mod : mods) {
                Map<String, Double> modifiers = bonusSrc.apply(mod).entrySet().stream().filter(entry -> ((String)entry.getKey()).contains(skillFilter)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                if (modifiers.isEmpty()) continue;
                holder.addAll(TextElement.build(mod, this.width, 1, 0xFFFFFF, false, 0));
                modifiers.forEach((key, value) -> holder.addAll(TextElement.build(key, value, this.width, this.step(1), CoreUtils.getSkillColor(key))));
            }
            if (!holder.isEmpty()) {
                this.content.addAll(TextElement.build((Component)LangProvider.MODIFIER_HEADER.asComponent().withStyle(ChatFormatting.BOLD), this.width, 1, 0xEEEEEE, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
                this.content.addAll(holder);
            }
        }
    }

    private void addSalvageSection(Map<ResourceLocation, CodecTypes.SalvageData> salvage) {
        if (!salvage.isEmpty()) {
            this.content.addAll(TextElement.build((Component)LangProvider.SALVAGE_HEADER.asComponent().withStyle(ChatFormatting.BOLD), this.width, 1, 0xFFFFFF, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
            for (Map.Entry<ResourceLocation, CodecTypes.SalvageData> salvageEntry : salvage.entrySet()) {
                CodecTypes.SalvageData data = salvageEntry.getValue();
                ItemStack resultStack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(salvageEntry.getKey()));
                this.content.addAll(TextElement.build(resultStack.getDisplayName(), this.width, this.step(1), 0xFFFFFF, true, (int)((Integer)Config.SALVAGE_ITEM_COLOR.get())));
                if (!data.levelReq().isEmpty()) {
                    this.content.addAll(TextElement.build((Component)LangProvider.SALVAGE_LEVEL_REQ.asComponent().withStyle(ChatFormatting.UNDERLINE), this.width, this.step(1), 0xFFFFFF, false, 0));
                    for (Map.Entry<String, Long> entry : data.levelReq().entrySet()) {
                        this.content.addAll(TextElement.build(entry.getKey(), entry.getValue(), this.width, this.step(2), CoreUtils.getSkillColor(entry.getKey())));
                    }
                }
                this.content.addAll(TextElement.build((Component)LangProvider.SALVAGE_CHANCE.asComponent(data.baseChance(), data.maxChance()).withStyle(ChatFormatting.UNDERLINE), this.width, this.step(1), 0xFFFFFF, false, 0));
                this.content.addAll(TextElement.build((Component)LangProvider.SALVAGE_MAX.asComponent(data.salvageMax()).withStyle(ChatFormatting.UNDERLINE), this.width, this.step(1), 0xFFFFFF, false, 0));
                if (!data.chancePerLevel().isEmpty()) {
                    this.content.addAll(TextElement.build((Component)LangProvider.SALVAGE_CHANCE_MOD.asComponent().withStyle(ChatFormatting.UNDERLINE), this.width, this.step(1), 0xFFFFFF, false, 0));
                    for (Map.Entry<String, Number> entry : data.chancePerLevel().entrySet()) {
                        this.content.addAll(TextElement.build(entry.getKey(), (Double)entry.getValue(), this.width, this.step(2), CoreUtils.getSkillColor(entry.getKey())));
                    }
                }
                if (data.xpAward().isEmpty()) continue;
                this.content.addAll(TextElement.build((Component)LangProvider.SALVAGE_XP_AWARD.asComponent().withStyle(ChatFormatting.UNDERLINE), this.width, this.step(1), 0xFFFFFF, false, 0));
                for (Map.Entry<String, Number> entry : data.xpAward().entrySet()) {
                    this.content.addAll(TextElement.build(entry.getKey(), (Long)entry.getValue(), this.width, this.step(2), CoreUtils.getSkillColor(entry.getKey())));
                }
            }
        }
    }

    private void addItemVeinSection(VeinData veinData, boolean isBlockItem) {
        if (!veinData.isEmpty()) {
            this.content.addAll(TextElement.build((Component)LangProvider.VEIN_HEADER.asComponent().withStyle(ChatFormatting.BOLD), this.width, 1, 0xFFFFFF, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
            this.content.addAll(TextElement.build((Component)LangProvider.VEIN_RATE.asComponent(veinData.chargeRate.orElse(0.0) * 2.0), this.width, this.step(1), 0xFFFFFF, false, 0));
            this.content.addAll(TextElement.build((Component)LangProvider.VEIN_CAP.asComponent(veinData.chargeCap.orElse(0)), this.width, this.step(1), 0xFFFFFF, false, 0));
            if (isBlockItem) {
                this.content.addAll(TextElement.build((Component)LangProvider.VEIN_CONSUME.asComponent(veinData.consumeAmount.orElse(0)), this.width, this.step(1), 0xFFFFFF, false, 0));
            }
        }
    }

    private void addBlockVeinSection(VeinData veinData) {
        if (veinData.consumeAmount.orElse(0) != 0) {
            this.content.addAll(TextElement.build((Component)LangProvider.VEIN_HEADER.asComponent().withStyle(ChatFormatting.BOLD), this.width, 1, 0xFFFFFF, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
            this.content.addAll(TextElement.build((Component)LangProvider.VEIN_CONSUME.asComponent(veinData.consumeAmount.orElse(0)), this.width, this.step(1), 0xFFFFFF, false, 0));
        }
    }

    private void addPlayerSection(Entity entity) {
        this.content.addAll(TextElement.build((Component)LangProvider.PLAYER_HEADER.asComponent(), this.width, this.step(1), 0xFFFFFF, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
        PlayerData data = this.core.getLoader().PLAYER_LOADER.getData(Reference.mc(entity.getUUID().toString()));
        this.content.addAll(TextElement.build((Component)LangProvider.PLAYER_IGNORE_REQ.asComponent(data.ignoreReq()), this.width, this.step(2), 0xFFFFFF, false, 0));
        if (!data.bonuses().isEmpty()) {
            this.content.addAll(TextElement.build((Component)LangProvider.PLAYER_BONUSES.asComponent(), this.width, this.step(2), 0xFFFFFF, true, (int)((Integer)Config.SALVAGE_ITEM_COLOR.get())));
            for (Map.Entry<String, Double> bonus : data.bonuses().entrySet()) {
                this.content.addAll(TextElement.build(bonus.getKey(), bonus.getValue(), this.width, this.step(3), CoreUtils.getSkillColor(bonus.getKey())));
            }
        }
        Map<String, Experience> rawXp = this.core.getData().getXpMap(entity.getUUID());
        LinkedHashMap orderedMap = new LinkedHashMap();
        ArrayList skillKeys = new ArrayList(rawXp.keySet().stream().toList());
        skillKeys.stream().sorted(Comparator.comparingLong(a -> ((Experience)rawXp.get(a)).getLevel().getLevel()).reversed());
        skillKeys.forEach(skill -> orderedMap.put(skill, this.core.getData().getLevel((String)skill, null)));
        this.content.addAll(TextElement.build((Component)LangProvider.SKILL_LIST_HEADER.asComponent(), this.step(1), this.width, 0xFFFFFF, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
        for (Map.Entry rawMap : orderedMap.entrySet()) {
            this.content.addAll(TextElement.build((String)rawMap.getKey(), (Long)rawMap.getValue(), this.width, this.step(2), CoreUtils.getSkillColor((String)rawMap.getKey())));
        }
    }

    private void addVeinBlacklistSection(ObjectType type, ResourceLocation location) {
        LocationData loader = (LocationData)this.core.getLoader().getLoader(type).getData(location);
        if (!loader.veinBlacklist().isEmpty()) {
            this.content.addAll(TextElement.build((Component)LangProvider.VEIN_BLACKLIST_HEADER.asComponent().withStyle(ChatFormatting.BOLD), this.width, this.step(1), 0xFFFFFF, false, 0));
            for (ResourceLocation blockID : loader.veinBlacklist()) {
                this.content.addAll(TextElement.build((Component)Component.literal((String)blockID.toString()), this.width, this.step(2), 0xEEEEEE, false, 0));
            }
        }
    }

    private void addMobModifierSection(ObjectType type, ResourceLocation location) {
        LocationData loader = (LocationData)this.core.getLoader().getLoader(type).getData(location);
        if (!loader.mobModifiers().isEmpty() || !loader.globalModifiers().isEmpty()) {
            this.content.addAll(TextElement.build((Component)LangProvider.MOB_MODIFIER_HEADER.asComponent().withStyle(ChatFormatting.BOLD), this.width, this.step(1), 0xFFFFFF, false, 0));
            for (MobModifier mobModifier : loader.globalModifiers()) {
                Attribute attribute = (Attribute)BuiltInRegistries.ATTRIBUTE.get(mobModifier.attribute());
                MutableComponent text = attribute == null ? Component.literal((String)mobModifier.attribute().toString()) : Component.translatable((String)attribute.getDescriptionId());
                text.append((Component)Component.literal((String)(": " + mobModifier.display() + mobModifier.amount())));
                this.content.addAll(TextElement.build((Component)text, this.width, this.step(2), 0xFFFFFF, false, 0xFFFFFF));
            }
            for (Map.Entry entry : loader.mobModifiers().entrySet()) {
                Entity entity = ((EntityType)BuiltInRegistries.ENTITY_TYPE.get((ResourceLocation)entry.getKey())).create((Level)this.mc.level);
                this.content.add(new RenderableElement(entity.getName(), this.step(1), 0xFFFFFF, (int)((Integer)Config.SALVAGE_ITEM_COLOR.get()), entity));
                for (MobModifier mobModifier : (List)entry.getValue()) {
                    Attribute attribute = (Attribute)BuiltInRegistries.ATTRIBUTE.get(mobModifier.attribute());
                    MutableComponent text = attribute == null ? Component.literal((String)mobModifier.attribute().toString()) : Component.translatable((String)attribute.getDescriptionId());
                    text.append((Component)Component.literal((String)(": " + mobModifier.display() + mobModifier.amount())));
                    this.content.addAll(TextElement.build((Component)text, this.width, this.step(2), 0xFFFFFF, false, 0xFFFFFF));
                }
            }
        }
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void updateNarration(NarrationElementOutput p_169152_) {
    }

    protected int getContentHeight() {
        return this.content.size() * 12;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scroll, double delta) {
        return super.mouseScrolled(mouseX, mouseY, scroll, delta);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int partialTicks) {
        return super.mouseClicked(mouseX, mouseY, partialTicks);
    }

    protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
        for (int i = 0; i < this.content.size(); ++i) {
            this.content.get(i).render(guiGraphics, this.left, (int)((float)(relativeY + i * 12) - this.scrollDistance), this.width, tess);
        }
    }

    private /* synthetic */ void lambda$populatePerks$27(String skillFilter, Player player, List holder, CompoundTag nbt) {
        if (!skillFilter.isEmpty() && nbt.contains("skill") && !nbt.getString("skill").equals(skillFilter)) {
            return;
        }
        ResourceLocation perkID = Reference.of(nbt.getString("perk"));
        nbt.putLong("level", nbt.contains("skill") ? Core.get(player.level()).getData().getLevel(nbt.getString("skill"), player.getUUID()) : 0L);
        holder.addAll(TextElement.build((Component)Component.translatable((String)("perk." + perkID.getNamespace() + "." + perkID.getPath())), this.width, this.step(1), 65280, false, 65280));
        holder.addAll(TextElement.build((Component)this.core.getPerkRegistry().getDescription(perkID).copy(), this.width, this.step(1), 0x99CCFF, false, 0x99CCFF));
        for (MutableComponent line : this.core.getPerkRegistry().getStatusLines(perkID, player, nbt)) {
            holder.addAll(TextElement.build((Component)line, this.width, this.step(2), 0xAAFFFF, false, 0xAAFFFF));
        }
    }

    private record RenderableElement(Component text, int xOffset, int color, int headerColor, ItemStack stack, Block block, Entity entity) implements Element
    {
        RenderableElement(Component text, int xOffset, int color, int headerColor, ItemStack stack) {
            this(text, xOffset, color, headerColor, stack, null, null);
        }

        RenderableElement(Component text, int xOffset, int color, int headerColor, Block block) {
            this(text, xOffset, color, headerColor, null, block, null);
        }

        RenderableElement(Component text, int xOffset, int color, int headerColor, Entity entity) {
            this(text, xOffset, color, headerColor, null, null, entity);
        }

        @Override
        public void render(GuiGraphics graphics, int x, int y, int width, Tesselator tess) {
            graphics.fill(RenderType.gui(), x, y, x + width, y + 12, this.headerColor());
            Font font = Minecraft.getInstance().font;
            if (this.stack() != null || this.block() != null) {
                ItemStack renderStack = this.stack() == null ? new ItemStack((ItemLike)this.block().asItem()) : this.stack();
                graphics.renderItem(renderStack, x + width - 25, y);
                graphics.drawString(font, renderStack.getDisplayName(), x + 10, y, 0xFFFFFF);
            } else {
                Entity renderStack = this.entity;
                if (renderStack instanceof LivingEntity) {
                    LivingEntity renderEntity = (LivingEntity)renderStack;
                    int scale = Math.max(1, 10 / Math.max(1, (int)renderEntity.getBoundingBox().getSize()));
                    int px = x + width - 30;
                    InventoryScreen.renderEntityInInventoryFollowsAngle((GuiGraphics)graphics, (int)px, (int)y, (int)(px + 30), (int)(y + 30), (int)scale, (float)0.0f, (float)0.0f, (float)0.0f, (LivingEntity)renderEntity);
                    graphics.drawString(font, renderEntity.getDisplayName(), x, y, 0xFFFFFF);
                }
            }
        }
    }

    private record TextElement(ClientTooltipComponent text, int xOffset, int color, boolean isHeader, int headerColor) implements Element
    {
        public static List<TextElement> build(Component component, int width, int xOffset, int color, boolean isHeader, int headerColor) {
            return TextElement.format(component.copy(), width, xOffset, color, isHeader, headerColor);
        }

        public static List<TextElement> build(String key, int value, int width, int xOffset, int color) {
            return TextElement.format(Component.translatable((String)("pmmo." + key)).append((Component)Component.literal((String)(": " + value))), width, xOffset, color, false, 0);
        }

        public static List<TextElement> build(String key, long value, int width, int xOffset, int color) {
            return TextElement.format(Component.translatable((String)("pmmo." + key)).append((Component)Component.literal((String)(": " + value))), width, xOffset, color, false, 0);
        }

        public static List<TextElement> build(String key, double value, int width, int xOffset, int color) {
            return TextElement.format(Component.translatable((String)("pmmo." + key)).append((Component)Component.literal((String)(": " + DP.dp(value * 100.0) + "%"))), width, xOffset, color, false, 0);
        }

        public static List<TextElement> build(Enum<?> type, int width, int xOffset, int color, boolean isHeader, int headerColor) {
            return TextElement.format(Component.translatable((String)("pmmo.enum." + type.name())), width - xOffset, xOffset, color, isHeader, headerColor);
        }

        @Override
        public void render(GuiGraphics graphics, int x, int y, int width, Tesselator tess) {
            if (this.isHeader()) {
                graphics.fill(RenderType.gui(), x, y, x + width, y + 12, this.headerColor());
            }
            MultiBufferSource.BufferSource buffer = graphics.bufferSource();
            this.text().renderText(Minecraft.getInstance().font, x + this.xOffset(), y, graphics.pose().last().pose(), buffer);
            buffer.endBatch();
        }

        private static List<TextElement> format(MutableComponent component, int width, int xOffset, int color, boolean isHeader, int headerColor) {
            return ClientUtils.ctc(component.withStyle(component.getStyle().withColor(color)), width).stream().map(line -> new TextElement((ClientTooltipComponent)line, xOffset, color, isHeader, headerColor)).toList();
        }
    }

    private static interface Element {
        public void render(GuiGraphics var1, int var2, int var3, int var4, Tesselator var5);
    }
}

